/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCRuntimeException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.ArraySerializer;
import de.timroes.axmlrpc.serializer.Base64Serializer;
import de.timroes.axmlrpc.serializer.BooleanSerializer;
import de.timroes.axmlrpc.serializer.DateTimeSerializer;
import de.timroes.axmlrpc.serializer.DoubleSerializer;
import de.timroes.axmlrpc.serializer.IntSerializer;
import de.timroes.axmlrpc.serializer.LongSerializer;
import de.timroes.axmlrpc.serializer.NullSerializer;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.serializer.StringSerializer;
import de.timroes.axmlrpc.serializer.StructSerializer;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;

public class SerializerHandler {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_INT = "int";
    public static final String TYPE_INT2 = "i4";
    public static final String TYPE_LONG = "i8";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_DATETIME = "dateTime.iso8601";
    public static final String TYPE_STRUCT = "struct";
    public static final String TYPE_ARRAY = "array";
    public static final String TYPE_BASE64 = "base64";
    public static final String TYPE_NULL = "nil";
    private static SerializerHandler instance;
    private StringSerializer string;
    private BooleanSerializer bool = new BooleanSerializer();
    private IntSerializer integer = new IntSerializer();
    private LongSerializer long8 = new LongSerializer();
    private StructSerializer struct = new StructSerializer();
    private DoubleSerializer floating = new DoubleSerializer();
    private DateTimeSerializer datetime = new DateTimeSerializer();
    private ArraySerializer array = new ArraySerializer();
    private Base64Serializer base64 = new Base64Serializer();
    private NullSerializer nil = new NullSerializer();
    private int flags;

    public static void initialize(int flags) {
        instance = new SerializerHandler(flags);
    }

    public static SerializerHandler getDefault() {
        if (instance == null) {
            throw new XMLRPCRuntimeException("The SerializerHandler has not been initialized.");
        }
        return instance;
    }

    private SerializerHandler(int flags) {
        this.flags = flags;
        this.string = new StringSerializer((flags & 0x1000) == 0, (flags & 0x800) == 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deserialize(Element element) throws XMLRPCException {
        if (!"value".equals(element.getNodeName())) {
            throw new XMLRPCException("Value tag is missing around value.");
        }
        if (!XMLUtil.hasChildElement(element.getChildNodes())) {
            if ((this.flags & 0x100) == 0) throw new XMLRPCException("Missing type element inside of value element.");
            return this.string.deserialize(element);
        }
        element = XMLUtil.getOnlyChildElement(element.getChildNodes());
        Serializer s = null;
        String type = (this.flags & 0x200) != 0 ? (element.getLocalName() == null ? element.getNodeName() : element.getLocalName()) : element.getNodeName();
        if ((this.flags & 8) != 0 && TYPE_NULL.equals(type)) {
            s = this.nil;
            return s.deserialize(element);
        } else if (TYPE_STRING.equals(type)) {
            s = this.string;
            return s.deserialize(element);
        } else if (TYPE_BOOLEAN.equals(type)) {
            s = this.bool;
            return s.deserialize(element);
        } else if (TYPE_DOUBLE.equals(type)) {
            s = this.floating;
            return s.deserialize(element);
        } else if (TYPE_INT.equals(type) || TYPE_INT2.equals(type)) {
            s = this.integer;
            return s.deserialize(element);
        } else if (TYPE_DATETIME.equals(type)) {
            s = this.datetime;
            return s.deserialize(element);
        } else if (TYPE_LONG.equals(type)) {
            if ((this.flags & 2) == 0) throw new XMLRPCException("8 byte integer is not in the specification. You must use FLAGS_8BYTE_INT to enable the i8 tag.");
            s = this.long8;
            return s.deserialize(element);
        } else if (TYPE_STRUCT.equals(type)) {
            s = this.struct;
            return s.deserialize(element);
        } else if (TYPE_ARRAY.equals(type)) {
            s = this.array;
            return s.deserialize(element);
        } else {
            if (!TYPE_BASE64.equals(type)) throw new XMLRPCException("No deserializer found for type '" + type + "'.");
            s = this.base64;
        }
        return s.deserialize(element);
    }

    public XmlElement serialize(Object object) throws XMLRPCException {
        Serializer s = null;
        if ((this.flags & 8) != 0 && object == null) {
            s = this.nil;
        } else if (object instanceof String) {
            s = this.string;
        } else if (object instanceof Boolean) {
            s = this.bool;
        } else if (object instanceof Double || object instanceof Float || object instanceof BigDecimal) {
            s = this.floating;
        } else if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            s = this.integer;
        } else if (object instanceof Long) {
            if ((this.flags & 2) != 0) {
                s = this.long8;
            } else {
                long l = (Long)object;
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    throw new XMLRPCException("FLAGS_8BYTE_INT must be set, if values outside the 4 byte integer range should be transfered.");
                }
                s = this.integer;
            }
        } else if (object instanceof Date) {
            s = this.datetime;
        } else if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
            s = this.datetime;
        } else if (object instanceof Map) {
            s = this.struct;
        } else if (object instanceof byte[]) {
            byte[] old = object;
            Byte[] boxed = new Byte[old.length];
            for (int i = 0; i < boxed.length; ++i) {
                boxed[i] = new Byte(old[i]);
            }
            object = boxed;
            s = this.base64;
        } else if (object instanceof Byte[]) {
            s = this.base64;
        } else if (object instanceof Iterable) {
            s = this.array;
        } else {
            throw new XMLRPCException("No serializer found for type '" + object.getClass().getName() + "'.");
        }
        return s.serialize(object);
    }
}

