/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxdialogs.desktop.dialogs;

import com.badlogic.gdx.Gdx;
import de.tomgrill.gdxdialogs.core.dialogs.GDXTextPrompt;
import de.tomgrill.gdxdialogs.core.listener.TextPromptListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DesktopGDXTextPrompt
implements GDXTextPrompt {
    private CharSequence title = "";
    private CharSequence message = "";
    private CharSequence value = "";
    private CharSequence cancelButtonLabel = "Cancel";
    private CharSequence confirmButtonLabel = "OK";
    private TextPromptListener listener;
    private GDXTextPrompt.InputType inputType = GDXTextPrompt.InputType.PLAIN_TEXT;

    public GDXTextPrompt show() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JTextField textField;
                Gdx.app.debug("gdx-dialogs (1.2.5)", DesktopGDXTextPrompt.class.getSimpleName() + " now shown");
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                JLabel label = new JLabel(DesktopGDXTextPrompt.this.message.toString());
                switch (DesktopGDXTextPrompt.this.inputType) {
                    case PASSWORD: {
                        textField = new JPasswordField();
                        textField.setText(String.valueOf(DesktopGDXTextPrompt.this.value));
                        break;
                    }
                    default: {
                        textField = new JTextField();
                        textField.setText(String.valueOf(DesktopGDXTextPrompt.this.value));
                    }
                }
                panel.add(label);
                panel.add(textField);
                Object[] options = new String[]{(String)DesktopGDXTextPrompt.this.confirmButtonLabel, (String)DesktopGDXTextPrompt.this.cancelButtonLabel};
                int response = JOptionPane.showOptionDialog(null, panel, (String)DesktopGDXTextPrompt.this.title, 1, 3, null, options, options[1]);
                if (DesktopGDXTextPrompt.this.listener != null) {
                    if (response == 1) {
                        DesktopGDXTextPrompt.this.listener.cancel();
                    } else {
                        switch (DesktopGDXTextPrompt.this.inputType) {
                            case PASSWORD: {
                                DesktopGDXTextPrompt.this.listener.confirm(new String(((JPasswordField)textField).getPassword()));
                                break;
                            }
                            default: {
                                DesktopGDXTextPrompt.this.listener.confirm(textField.getText());
                            }
                        }
                    }
                }
            }
        }).start();
        return this;
    }

    public GDXTextPrompt setTitle(CharSequence title) {
        this.title = title;
        return this;
    }

    public GDXTextPrompt setMaxLength(int maxLength) {
        if (maxLength < 1) {
            throw new RuntimeException("Char limit must be >= 1");
        }
        return this;
    }

    public GDXTextPrompt setMessage(CharSequence message) {
        this.message = message;
        return this;
    }

    public GDXTextPrompt setCancelButtonLabel(CharSequence label) {
        this.cancelButtonLabel = label;
        return this;
    }

    public GDXTextPrompt setConfirmButtonLabel(CharSequence label) {
        this.confirmButtonLabel = label;
        return this;
    }

    public GDXTextPrompt build() {
        return this;
    }

    public GDXTextPrompt setTextPromptListener(TextPromptListener listener) {
        this.listener = listener;
        return this;
    }

    public GDXTextPrompt setInputType(GDXTextPrompt.InputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public GDXTextPrompt setValue(CharSequence inputTip) {
        this.value = inputTip;
        return this;
    }

    public GDXTextPrompt dismiss() {
        Gdx.app.debug("gdx-dialogs (1.2.5)", DesktopGDXTextPrompt.class.getSimpleName() + " dismiss ignored. (Desktop TextPrompt cannot be dismissed)");
        return this;
    }
}

