/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxdialogs.html.dialogs;

import de.tomgrill.gdxdialogs.core.dialogs.GDXButtonDialog;
import de.tomgrill.gdxdialogs.core.dialogs.GDXTextPrompt;
import de.tomgrill.gdxdialogs.core.listener.TextPromptListener;
import java.util.LinkedHashMap;
import java.util.Map;

public class HTMLGDXTextPrompt
implements GDXTextPrompt {
    public static Map<String, HTMLGDXTextPrompt> dialogs = new LinkedHashMap<String, HTMLGDXTextPrompt>();
    String title;
    String message;
    String value;
    String cancel;
    String confirm = "";
    TextPromptListener listener;
    boolean isBuild = false;
    private int maxLength = 16;
    private String inputType = "text";

    public GDXTextPrompt setTitle(CharSequence title) {
        this.title = (String)title;
        return this;
    }

    public GDXTextPrompt setMaxLength(int maxLength) {
        if (maxLength < 1) {
            throw new RuntimeException("Char limit must be >= 1");
        }
        this.maxLength = maxLength;
        return this;
    }

    public GDXTextPrompt show() {
        if (!this.isBuild) {
            throw new RuntimeException(GDXButtonDialog.class.getSimpleName() + " has not been build. Use build() before show().");
        }
        this.showJSTextPrompt(this.toString());
        return this;
    }

    public GDXTextPrompt dismiss() {
        if (!this.isBuild) {
            throw new RuntimeException(GDXButtonDialog.class.getSimpleName() + " has not been build. Use build() before dismiss().");
        }
        this.dismissJSTextPrompt(this.toString());
        return this;
    }

    public GDXTextPrompt build() {
        this.createJSTextPrompt(this.title, this.message, this.maxLength, this.inputType, this.toString(), this.value, this.cancel, this.confirm, this.listener);
        this.isBuild = true;
        return this;
    }

    public GDXTextPrompt setMessage(CharSequence message) {
        this.message = (String)message;
        return this;
    }

    public GDXTextPrompt setValue(CharSequence inputTip) {
        this.value = (String)inputTip;
        return this;
    }

    public GDXTextPrompt setCancelButtonLabel(CharSequence label) {
        this.cancel = (String)label;
        return this;
    }

    public GDXTextPrompt setConfirmButtonLabel(CharSequence label) {
        this.confirm = (String)label;
        return this;
    }

    public GDXTextPrompt setTextPromptListener(TextPromptListener listener) {
        this.listener = listener;
        return this;
    }

    public GDXTextPrompt setInputType(GDXTextPrompt.InputType inputType) {
        switch (inputType) {
            case PLAIN_TEXT: {
                this.inputType = "text";
                break;
            }
            case PASSWORD: {
                this.inputType = "password";
            }
        }
        return this;
    }

    public static void cancel(String id) {
        for (Map.Entry<String, HTMLGDXTextPrompt> entry : dialogs.entrySet()) {
            if (!id.equals(entry.getKey())) continue;
            HTMLGDXTextPrompt prompt = entry.getValue();
            if (prompt.listener == null) continue;
            prompt.listener.cancel();
        }
    }

    public static void confirm(String id, String text) {
        for (Map.Entry<String, HTMLGDXTextPrompt> o : dialogs.entrySet()) {
            Map.Entry<String, HTMLGDXTextPrompt> entry = o;
            if (!id.equals(entry.getKey())) continue;
            HTMLGDXTextPrompt prompt = entry.getValue();
            if (prompt.listener == null) continue;
            prompt.listener.confirm(text);
        }
    }

    protected native void createJSTextPrompt(String var1, String var2, int var3, String var4, String var5, String var6, String var7, String var8, TextPromptListener var9);

    protected native void showJSTextPrompt(String var1);

    protected native void dismissJSTextPrompt(String var1);
}

