/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdCommand;
import de.tototec.cmdoption.CmdOption;
import de.tototec.cmdoption.CmdOptionDelegate;
import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CmdlineParserException;
import de.tototec.cmdoption.CommandHandle;
import de.tototec.cmdoption.DefaultUsageFormatter;
import de.tototec.cmdoption.I18n;
import de.tototec.cmdoption.I18nFactory;
import de.tototec.cmdoption.OptionHandle;
import de.tototec.cmdoption.UsageFormatter;
import de.tototec.cmdoption.Util;
import de.tototec.cmdoption.handler.AddToCollectionHandler;
import de.tototec.cmdoption.handler.BooleanFieldHandler;
import de.tototec.cmdoption.handler.BooleanOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.handler.PutIntoMapHandler;
import de.tototec.cmdoption.handler.StringFieldHandler;
import de.tototec.cmdoption.handler.StringMethodHandler;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdlineParser {
    private I18n i18n = I18nFactory.getI18n(CmdlineParser.class);
    private OptionHandle parameter = null;
    private final List<OptionHandle> options = new LinkedList<OptionHandle>();
    private final Map<String, OptionHandle> quickOptionMap = new LinkedHashMap<String, OptionHandle>();
    private final List<CommandHandle> commands = new LinkedList<CommandHandle>();
    private final Map<String, CommandHandle> quickCommandMap = new LinkedHashMap<String, CommandHandle>();
    private String defaultCommandName = null;
    private final Map<Class<? extends CmdOptionHandler>, CmdOptionHandler> handlerRegistry;
    private UsageFormatter usageFormatter = new DefaultUsageFormatter(true);
    private String programName;
    private String parsedCommandName;
    private String aboutLine;
    private boolean debugAllowed = true;
    private boolean debugMode = false;
    final String DEBUG_PREFIX = "CMDOPTION_DEBUG: ";
    private final CmdlineParser parent;
    private ResourceBundle resourceBundle;

    protected CmdlineParser(CmdlineParser parent, String commandName, Object commandObject) {
        this.parent = parent;
        this.debugMode = parent.debugMode;
        this.programName = commandName;
        this.handlerRegistry = parent.handlerRegistry;
        this.scanOptions(commandObject);
    }

    public CmdlineParser(Object ... objects) {
        this.parent = null;
        this.programName = "<main class>";
        this.handlerRegistry = new LinkedHashMap<Class<? extends CmdOptionHandler>, CmdOptionHandler>();
        this.addObject(objects);
        this.registerHandler(new BooleanOptionHandler());
        this.registerHandler(new BooleanFieldHandler());
        this.registerHandler(new StringFieldHandler());
        this.registerHandler(new PutIntoMapHandler());
        this.registerHandler(new AddToCollectionHandler());
        this.registerHandler(new StringMethodHandler());
    }

    private void debug(String msg, Object ... args) {
        if (this.parent != null) {
            this.parent.debug(msg, args);
        } else if (this.debugMode) {
            if (args == null || args.length == 0) {
                System.out.println("CMDOPTION_DEBUG: " + msg);
            } else {
                System.out.println("CMDOPTION_DEBUG: " + MessageFormat.format(msg, args));
            }
        }
    }

    public void setDebugModeAllowed(boolean debugAllowed) {
        this.debugAllowed = debugAllowed;
    }

    public void setUsageFormatter(UsageFormatter usageFormatter) {
        this.usageFormatter = usageFormatter;
    }

    public void setDefaultCommandName(String defaultCommandName) {
        this.defaultCommandName = defaultCommandName;
    }

    public void setDefaultCommandClass(Class<?> defaultCommandClass) {
        CmdCommand anno = defaultCommandClass.getAnnotation(CmdCommand.class);
        if (anno == null) {
            throw new IllegalArgumentException("Given class is not annotated with @" + CmdCommand.class.getSimpleName());
        }
        if (anno.names() == null || anno.names().length == 0 || anno.names()[0].length() == 0) {
            throw new IllegalArgumentException("Given default command class has no valid name");
        }
        this.setDefaultCommandName(anno.names()[0]);
    }

    public void parse(String ... cmdline) {
        this.parse(false, true, cmdline);
    }

    public void parse(boolean dryrun, boolean detectHelpAndSkipValidation, String ... cmdline) {
        if (this.defaultCommandName != null && !this.quickCommandMap.containsKey(this.defaultCommandName)) {
            String msg = I18n.marktr("Default command \"{0}\" is not a known command.");
            throw new CmdlineParserException(null, msg, this.defaultCommandName);
        }
        if (!dryrun) {
            this.parse(true, detectHelpAndSkipValidation, cmdline);
        }
        if (dryrun) {
            this.validateOptions();
        }
        cmdline = cmdline == null ? new String[]{} : cmdline;
        boolean parseOptions = true;
        String stopOption = "--";
        LinkedHashMap<OptionHandle, Integer> optionCount = new LinkedHashMap<OptionHandle, Integer>();
        for (OptionHandle option : this.options) {
            optionCount.put(option, 0);
        }
        if (this.parameter != null) {
            optionCount.put(this.parameter, 0);
        }
        boolean helpDetected = false;
        for (int index = 0; index < cmdline.length; ++index) {
            CommandHandle commandHandle;
            String param = cmdline[index];
            if (parseOptions && "--".equals(param)) {
                parseOptions = false;
                continue;
            }
            if (this.debugAllowed && param.equals("--CMDOPTION_DEBUG")) {
                if (this.debugMode) continue;
                this.debugMode = true;
                this.debug("Enabled debug mode", new Object[0]);
                this.debug("Parameter: " + this.parameter, new Object[0]);
                this.debug("Options: " + Util.mkString(this.options, "\n  ", ",\n  ", null), new Object[0]);
                this.debug("Commands: " + Util.mkString(this.commands, "\n  ", ",\n  ", null), new Object[0]);
                continue;
            }
            if (parseOptions && this.quickOptionMap.containsKey(param)) {
                OptionHandle optionHandle = this.quickOptionMap.get(param);
                optionCount.put(optionHandle, (Integer)optionCount.get(optionHandle) + 1);
                if (optionHandle.isHelp()) {
                    helpDetected = true;
                }
                if (cmdline.length <= index + optionHandle.getArgsCount()) {
                    throw new CmdlineParserException(null, I18n.marktr("Missing arguments(s): {0}. Option \"{1}\" requires {2} arguments, but you gave {3}."), Util.mkString(Arrays.asList(optionHandle.getArgs()).subList(cmdline.length - index - 1, optionHandle.getArgsCount()), null, ", ", null), param, optionHandle.getArgsCount(), cmdline.length - index - 1);
                }
                Object[] optionArgs = Arrays.copyOfRange(cmdline, index + 1, index + 1 + optionHandle.getArgsCount());
                index += optionHandle.getArgsCount();
                AccessibleObject element = optionHandle.getElement();
                CmdOptionHandler handler = this.findHandler(element, optionHandle.getArgsCount(), optionHandle.getCmdOptionHandlerType());
                if (handler == null) {
                    throw new CmdlineParserException(null, I18n.marktr("No suitable handler found for option: {0} ({1} argument(s))"), param, optionHandle.getArgsCount());
                }
                if (dryrun) continue;
                try {
                    handler.applyParams(optionHandle.getObject(), element, (String[])optionArgs, param);
                    continue;
                }
                catch (CmdOptionHandlerException e) {
                    throw new CmdlineParserException(e.getMessage(), e, e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new CmdlineParserException(e, I18n.marktr("Could not apply parameters {0} to field/method {1}"), Arrays.toString(optionArgs), element);
                }
            }
            if (parseOptions && this.quickCommandMap.containsKey(param)) {
                commandHandle = this.quickCommandMap.get(param);
                if (!dryrun) {
                    this.parsedCommandName = param;
                }
                commandHandle.getCmdlineParser().parse(dryrun, detectHelpAndSkipValidation, Arrays.copyOfRange(cmdline, index + 1, cmdline.length));
                break;
            }
            if (this.parameter == null && this.defaultCommandName != null && this.quickCommandMap.containsKey(this.defaultCommandName)) {
                this.debug("Unsupported option '" + param + "' found, assuming default command: " + this.defaultCommandName, new Object[0]);
                commandHandle = this.quickCommandMap.get(this.defaultCommandName);
                if (!dryrun) {
                    this.parsedCommandName = this.defaultCommandName;
                }
                commandHandle.getCmdlineParser().parse(dryrun, detectHelpAndSkipValidation, Arrays.copyOfRange(cmdline, index, cmdline.length));
                break;
            }
            if (this.parameter != null) {
                optionCount.put(this.parameter, (Integer)optionCount.get(this.parameter) + 1);
                if (cmdline.length <= index + this.parameter.getArgsCount() - 1) {
                    int countOfGivenParams = cmdline.length - index;
                    throw new CmdlineParserException(null, I18n.marktr("Missing arguments: {0} Parameter requires {1} arguments, but you gave {2}."), Arrays.asList(this.parameter.getArgs()).subList(countOfGivenParams, this.parameter.getArgsCount()), this.parameter.getArgsCount(), countOfGivenParams);
                }
                Object[] optionArgs = Arrays.copyOfRange(cmdline, index, index + this.parameter.getArgsCount());
                index += this.parameter.getArgsCount() - 1;
                AccessibleObject element = this.parameter.getElement();
                CmdOptionHandler handler = this.findHandler(element, this.parameter.getArgsCount(), this.parameter.getCmdOptionHandlerType());
                if (handler == null) {
                    throw new CmdlineParserException(null, I18n.marktr("No suitable handler found for option: {0}"), param);
                }
                if (dryrun) continue;
                try {
                    this.debug("Apply main parameter from parameters: {0}", Util.mkString(optionArgs, null, ", ", null));
                    handler.applyParams(this.parameter.getObject(), element, (String[])optionArgs, param);
                    continue;
                }
                catch (CmdOptionHandlerException e) {
                    throw new CmdlineParserException(e.getMessage(), e, e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new CmdlineParserException(e, I18n.marktr("Could not apply parameters {0} to field/method {1}"), Arrays.toString(optionArgs), element);
                }
            }
            throw new CmdlineParserException(null, I18n.marktr("Unsupported option or parameter found: {0}"), param);
        }
        if (!detectHelpAndSkipValidation || !helpDetected) {
            for (Map.Entry optionC : optionCount.entrySet()) {
                Object[] msgArgsTr;
                Object[] msgArgs;
                String msg;
                Object[] rangeArgs;
                String rangeMsg;
                OptionHandle option = (OptionHandle)optionC.getKey();
                Integer count = (Integer)optionC.getValue();
                if (count >= option.getMinCount() && (option.getMaxCount() <= 0 || count <= option.getMaxCount())) continue;
                if (option.getMaxCount() < 0) {
                    rangeMsg = I18n.marktr("at least {0}");
                    rangeArgs = new Object[]{option.getMinCount()};
                } else if (option.getMinCount() == option.getMaxCount()) {
                    rangeMsg = I18n.marktr("exactly {0}");
                    rangeArgs = new Object[]{option.getMinCount()};
                } else {
                    rangeMsg = I18n.marktr("between {0} and {1}");
                    rangeArgs = new Object[]{option.getMinCount(), option.getMaxCount()};
                }
                if (option.getNames() == null || option.getNames().length == 0) {
                    msg = I18n.marktr("Main parameter \"{0}\" was given {1} times, but must be given {2} times");
                    msgArgs = new Object[]{Util.mkString(option.getArgs(), null, " ", null), count, MessageFormat.format(rangeMsg, rangeArgs)};
                    msgArgsTr = new Object[]{Util.mkString(option.getArgs(), null, " ", null), count, this.i18n.tr(rangeMsg, rangeArgs)};
                } else {
                    msg = I18n.marktr("Option \"{0}\" was given {1} times, but must be given {2} times");
                    msgArgs = new Object[]{option.getNames()[0], count, MessageFormat.format(rangeMsg, rangeArgs)};
                    msgArgsTr = new Object[]{option.getNames()[0], count, this.i18n.tr(rangeMsg, rangeArgs)};
                }
                throw new CmdlineParserException(MessageFormat.format(msg, msgArgs), this.i18n.tr(msg, msgArgsTr));
            }
            for (Map.Entry optionC : optionCount.entrySet()) {
                if ((Integer)optionC.getValue() <= 0) continue;
                OptionHandle calledOption = (OptionHandle)optionC.getKey();
                for (String required : calledOption.getRequires()) {
                    Integer reqOptionCount;
                    OptionHandle reqOptionHandle = this.quickOptionMap.get(required);
                    if (reqOptionHandle == null || (reqOptionCount = (Integer)optionCount.get(reqOptionHandle)) != null && reqOptionCount > 0) continue;
                    throw new CmdlineParserException(null, I18n.marktr("When using option \"{0}\" also option \"{1}\" must be given."), calledOption.getNames()[0], required);
                }
                for (String conflict : calledOption.getConflictsWith()) {
                    Integer conflictOptionCount;
                    OptionHandle conflictOptionHandle = this.quickOptionMap.get(conflict);
                    if (conflictOptionHandle == null || (conflictOptionCount = (Integer)optionCount.get(conflictOptionHandle)) == null || conflictOptionCount <= 0) continue;
                    throw new CmdlineParserException(null, I18n.marktr("Options \"{0}\" and \"{1}\" cannot be used at the same time."), calledOption.getNames()[0], conflict);
                }
            }
        }
    }

    public String getParsedCommandName() {
        return this.parsedCommandName;
    }

    public Object getParsedCommandObject() {
        if (this.parsedCommandName != null) {
            return this.quickCommandMap.get(this.parsedCommandName).getObject();
        }
        return null;
    }

    protected CmdOptionHandler findHandler(AccessibleObject element, int argsCount, Class<? extends CmdOptionHandler> cmdOptionHandlerType) {
        CmdOptionHandler handler = null;
        if (cmdOptionHandlerType != null && !cmdOptionHandlerType.equals(CmdOptionHandler.class)) {
            if (this.handlerRegistry.containsKey(cmdOptionHandlerType)) {
                handler = this.handlerRegistry.get(cmdOptionHandlerType);
            } else {
                try {
                    handler = cmdOptionHandlerType.newInstance();
                }
                catch (Exception e) {
                    throw new CmdlineParserException(e, I18n.marktr("Could not create handler: {0}"), cmdOptionHandlerType);
                }
            }
        } else {
            for (CmdOptionHandler regHandle : this.handlerRegistry.values()) {
                if (!regHandle.canHandle(element, argsCount)) continue;
                handler = regHandle;
                break;
            }
        }
        if (handler == null && this.parent != null) {
            return this.parent.findHandler(element, argsCount, cmdOptionHandlerType);
        }
        return handler;
    }

    public void addObject(Object ... objects) {
        for (Object object : objects) {
            if (object.getClass().getAnnotation(CmdCommand.class) != null) {
                this.scanCommand(object);
                continue;
            }
            this.scanOptions(object);
        }
    }

    protected void scanCommand(Object object) {
        CmdCommand commandAnno = object.getClass().getAnnotation(CmdCommand.class);
        String[] names = commandAnno.names();
        if (names == null || names.length == 0) {
            throw new CmdlineParserException(null, I18n.marktr("Command found without required name in: {0}"), object);
        }
        CmdlineParser subCmdlineParser = new CmdlineParser(this, names[0], object);
        CommandHandle command = new CommandHandle(names, commandAnno.description(), subCmdlineParser, object, commandAnno.hidden());
        for (String name : names) {
            if (this.quickCommandMap.containsKey(name) || this.quickOptionMap.containsKey(name)) {
                throw new CmdlineParserException(null, I18n.marktr("Duplicate command/option name \"{0}\" found in: {1}"), name, object);
            }
            this.quickCommandMap.put(name, command);
        }
        this.commands.add(command);
    }

    protected void validateOptions() {
        for (OptionHandle optionHandle : this.options) {
            String optionName;
            for (String reqOptionName : optionHandle.getRequires()) {
                if (this.quickOptionMap.get(reqOptionName) != null) continue;
                optionName = optionHandle.getNames() == null ? "<no name>" : optionHandle.getNames()[0];
                throw new CmdlineParserException(null, I18n.marktr("The option \"{0}\" requires the unknown/missing option \"{1}\"."), optionName, reqOptionName);
            }
            for (String conflictOptionName : optionHandle.getConflictsWith()) {
                String string = optionName = optionHandle.getNames() == null ? "<no name>" : optionHandle.getNames()[0];
                if (Arrays.asList(optionHandle.getNames()).contains(conflictOptionName)) {
                    throw new CmdlineParserException(null, I18n.marktr("Option \"{0}\" is configured to conflicts with itself."), optionName);
                }
                if (this.quickOptionMap.get(conflictOptionName) != null) continue;
                throw new CmdlineParserException(null, I18n.marktr("The option \"{0}\" conflicts with a unknown/missing option \"{1}\"."), optionName, conflictOptionName);
            }
        }
    }

    protected void scanOptions(Object object) {
        Class<?> class1 = object.getClass();
        LinkedHashSet<AccessibleObject> elements = new LinkedHashSet<AccessibleObject>();
        elements.addAll(Arrays.asList(class1.getDeclaredFields()));
        elements.addAll(Arrays.asList(class1.getFields()));
        elements.addAll(Arrays.asList(class1.getDeclaredMethods()));
        elements.addAll(Arrays.asList(class1.getMethods()));
        for (AccessibleObject element : elements) {
            Class<? extends CmdOptionHandler> annoHandlerType;
            element.setAccessible(true);
            if (element instanceof Field && element.getAnnotation(CmdOptionDelegate.class) != null) {
                this.debug("Found delegate object at: {0}", element);
                try {
                    Object delegate = ((Field)element).get(object);
                    if (delegate == null) continue;
                    this.scanOptions(delegate);
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not scan delegate object at: {0}", element);
                }
                catch (IllegalAccessException e) {
                    this.debug("Could not scan delegate object at: {0}", element);
                }
                continue;
            }
            CmdOption anno = element.getAnnotation(CmdOption.class);
            if (anno == null) continue;
            String[] names = anno.names();
            Class<? extends CmdOptionHandler> clazz = annoHandlerType = anno.handler() == CmdOptionHandler.class ? null : anno.handler();
            if (names == null || names.length == 0) {
                if (this.parameter != null) {
                    throw new CmdlineParserException(null, I18n.marktr("More than one parameter definition found. First definition: {0} Second definition: {1}"), this.parameter.getElement(), element);
                }
                OptionHandle paramHandle = new OptionHandle(new String[0], anno.description(), annoHandlerType, object, element, anno.args(), anno.minCount(), anno.maxCount(), false, anno.hidden(), anno.requires(), anno.conflictsWith());
                if (paramHandle.getArgsCount() <= 0) {
                    throw new CmdlineParserException(null, I18n.marktr("Parameter definition must support at least on argument."));
                }
                this.parameter = paramHandle;
                continue;
            }
            OptionHandle option = new OptionHandle(names, anno.description(), annoHandlerType, object, element, anno.args(), anno.minCount(), anno.maxCount(), anno.isHelp(), anno.hidden(), anno.requires(), anno.conflictsWith());
            for (String name : names) {
                if (this.quickCommandMap.containsKey(name) || this.quickOptionMap.containsKey(name)) {
                    throw new CmdlineParserException(null, I18n.marktr("Duplicate command/option name \"{0}\" found in: {1}"), name, element);
                }
                this.quickOptionMap.put(name, option);
            }
            this.options.add(option);
        }
    }

    public void unregisterAllHandler() {
        this.handlerRegistry.clear();
    }

    public void unregisterHandler(Class<? extends CmdOptionHandler> type) {
        if (type != null) {
            this.handlerRegistry.remove(type);
        }
    }

    public void registerHandler(CmdOptionHandler handler) {
        if (handler != null) {
            this.debug("Register CmdOptionHandler: {0}", handler);
            this.handlerRegistry.put(handler.getClass(), handler);
        }
    }

    public void commandUsage(Class<?> command) {
        for (CommandHandle cmdHandle : this.commands) {
            if (!cmdHandle.getObject().getClass().equals(command)) continue;
            cmdHandle.getCmdlineParser().usage();
            return;
        }
        throw new IllegalArgumentException("Given command is not known or does not have a @" + CmdCommand.class.getSimpleName() + "-annotation");
    }

    public void usage() {
        StringBuilder output = new StringBuilder();
        this.usage(output);
        System.out.print(output.toString());
    }

    public void usage(StringBuilder output) {
        this.usageFormatter.format(output, this.getCmdlineModel());
    }

    public CmdlineModel getCmdlineModel() {
        String programName = this.programName;
        if (this.parent != null) {
            programName = this.parent.programName + " " + programName;
        }
        return new CmdlineModel(programName, this.options, this.commands, this.parameter, this.aboutLine, this.resourceBundle);
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public void setAboutLine(String aboutLine) {
        this.aboutLine = aboutLine;
    }

    public void setResourceBundle(String resourceBundleName, ClassLoader classloader) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), classloader);
        }
        catch (MissingResourceException e) {
            this.resourceBundle = null;
        }
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }
}

