/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.Util;
import de.tototec.cmdoption.handler.CmdOptionHandler;
import java.lang.reflect.AccessibleObject;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionHandle {
    private final String[] names;
    private final String description;
    private final Class<? extends CmdOptionHandler> cmdOptionHandlerType;
    private final AccessibleObject element;
    private final String[] args;
    private final int minCount;
    private final int maxCount;
    private final boolean help;
    private final Object object;
    private final boolean hidden;
    private String[] requires;
    private String[] conflictsWith;

    public OptionHandle(String[] names, String description, Class<? extends CmdOptionHandler> cmdOptionHandlerType, Object object, AccessibleObject element, String[] args, int minCount, int maxCount, boolean help, boolean hidden, String[] requires, String[] conflictsWith) {
        this.names = names;
        this.description = description;
        this.cmdOptionHandlerType = cmdOptionHandlerType;
        this.object = object;
        this.element = element;
        this.args = args;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.help = help;
        this.hidden = hidden;
        this.requires = requires;
        this.conflictsWith = conflictsWith;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends CmdOptionHandler> getCmdOptionHandlerType() {
        return this.cmdOptionHandlerType;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getArgsCount() {
        return this.args == null ? 0 : this.args.length;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public Object getObject() {
        return this.object;
    }

    public AccessibleObject getElement() {
        return this.element;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isHelp() {
        return this.help;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public String[] getConflictsWith() {
        return this.conflictsWith;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(names=" + Util.mkString(this.getNames(), null, ",", null) + ",args=" + Util.mkString(this.getArgs(), null, ",", null) + ",minCount=" + this.getMinCount() + ",maxCount=" + this.getMaxCount() + ",description=" + this.getDescription() + ",requires=" + Util.mkString(this.getRequires(), null, ",", null) + ",conflictsWith=" + Util.mkString(this.getConflictsWith(), null, ",", null) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptionHandleComparator
    implements Comparator<OptionHandle> {
        @Override
        public int compare(OptionHandle o1, OptionHandle o2) {
            return this.sanitizeString(o1.getNames()[0]).compareTo(this.sanitizeString(o2.getNames()[0]));
        }

        public String sanitizeString(String string) {
            Pattern pattern = Pattern.compile("^[^A-Za-z0-9]*(.*)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return string;
        }
    }
}

