/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;

public class StringMethodHandler
implements CmdOptionHandler {
    public boolean canHandle(AccessibleObject element, int argCount) {
        Method method;
        if (element instanceof Method && (method = (Method)element).getParameterTypes().length == argCount) {
            boolean areStrings = true;
            for (Class<?> p : method.getParameterTypes()) {
                areStrings &= String.class.isAssignableFrom(p);
            }
            return areStrings;
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        try {
            Method method = (Method)element;
            method.invoke(config, (Object[])args);
        }
        catch (Exception e) {
            throw new CmdOptionHandlerException("Could not apply parameters: " + Arrays.toString(args) + " to method " + element, e);
        }
    }
}

