/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.cert.bundle;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreImpl
extends KeyStoreSpi {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreImpl.class);
    private TimedRenewalCertMap certMap;

    public KeyStoreImpl(BundleFactory bundleFactory) {
        LOG.debug("cTor KeyStoreImpl(bundleFac) called");
        this.certMap = new TimedRenewalCertMap(bundleFactory);
    }

    public KeyStoreImpl(TimedRenewalCertMap certMap, String alias) {
        LOG.debug("cTor KeyStoreImpl(certMap, alias) called");
        this.certMap = certMap;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        LOG.debug("engineGetKey({}, ***** )", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb == null) {
            LOG.debug("engineGetKey({}, ***** ) throws UnrecoverableKeyException ", (Object)alias);
            throw new UnrecoverableKeyException("alias '" + alias + "' unknown");
        }
        LOG.debug("engineGetKey({}, ***** ) returns key ", (Object)alias);
        return kcb.getKey();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOG.debug("engineGetCertificateChain({})", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb == null) {
            LOG.info("alias '" + alias + "' unknown");
            return null;
        }
        LOG.debug("engineGetCertificateChain({} ) return chain with {} elements", (Object)alias, (Object)kcb.getCertificateChain().length);
        return kcb.getCertificateChain();
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        LOG.debug("engineGetCertificate({})", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb == null) {
            LOG.info("alias '" + alias + "' unknown");
            return null;
        }
        return kcb.getCertificate();
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOG.debug("engineGetCreationDate({})", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb == null) {
            LOG.info("alias '" + alias + "' unknown");
            return null;
        }
        return kcb.getCreationDate();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        LOG.debug("engineSetKeyEntry({}, chain)", (Object)alias, (Object)chain.length);
        this.certMap.put(alias, chain, chain[0], key);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new RuntimeException("engineSetKeyEntry not supported");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new RuntimeException("engineSetCertificateEntry not supported");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new RuntimeException("engineDeleteEntry not supported");
    }

    @Override
    public Enumeration<String> engineAliases() {
        LOG.debug("engineAliases()");
        Set<String> aliasSet = this.certMap.aliases();
        for (String alias : aliasSet) {
            LOG.debug("returning alias {}", (Object)alias);
        }
        Vector<String> v = new Vector<String>(aliasSet);
        return v.elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        LOG.debug("engineContainsAlias({})", (Object)alias);
        return this.certMap.containsAlias(alias);
    }

    @Override
    public int engineSize() {
        LOG.debug("engineSize()");
        return this.certMap.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        LOG.debug("engineIsKeyEntry({})", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb != null) {
            LOG.info("alias '" + alias + "' found");
            return true;
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        LOG.debug("engineIsCertificateEntry({})", (Object)alias);
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        LOG.debug("engineIsCertificateEntry({})", (Object)cert.toString());
        return this.certMap.getAliasForCertificate(cert);
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug("engineStore(stream, ****) : nothing to do");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.info("engineLoad(stream, ****) : retrieving certificate (if neccessary)");
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.info("engineLoad(param) : retrieving certificate (if neccessary)");
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        LOG.debug("engineEntryInstanceOf({}, entryClass)", (Object)alias);
        if (!this.engineContainsAlias(alias)) {
            return false;
        }
        try {
            if (this.engineIsCertificateEntry(alias)) {
                return entryClass.isAssignableFrom(Class.forName("java.security.KeyStore$TrustedCertificateEntry"));
            }
            if (this.engineIsKeyEntry(alias)) {
                if (entryClass.isAssignableFrom(Class.forName("java.security.KeyStore$PrivateKeyEntry"))) {
                    return this.engineGetCertificate(alias) != null;
                }
                if (entryClass.isAssignableFrom(Class.forName("java.security.KeyStore$SecretKeyEntry"))) {
                    return this.engineGetCertificate(alias) == null;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        LOG.debug("engineGetEntry({}, protParam)", (Object)alias);
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (this.engineIsCertificateEntry(alias)) {
            return new KeyStore.TrustedCertificateEntry(this.engineGetCertificate(alias));
        }
        char[] passW = null;
        if (protParam != null) {
            if (protParam instanceof KeyStore.PasswordProtection) {
                try {
                    passW = ((KeyStore.PasswordProtection)protParam).getPassword();
                }
                catch (IllegalStateException ee) {
                    throw new KeyStoreException("Password was destroyed", ee);
                }
            } else {
                if (protParam instanceof KeyStore.CallbackHandlerProtection) {
                    throw new UnrecoverableEntryException("ProtectionParameter :PasswordFromCallBack not supported.");
                }
                throw new UnrecoverableEntryException("ProtectionParameter object is not PasswordProtection: " + protParam);
            }
        }
        if (this.engineIsKeyEntry(alias)) {
            Key key = this.engineGetKey(alias, passW);
            if (key instanceof PrivateKey) {
                return new KeyStore.PrivateKeyEntry((PrivateKey)key, this.engineGetCertificateChain(alias));
            }
            if (key instanceof SecretKey) {
                return new KeyStore.SecretKeyEntry((SecretKey)key);
            }
        }
        throw new NoSuchAlgorithmException("Unknown KeyStore.Entry object");
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        LOG.debug("engineSetEntry({}, entry, protParam)", (Object)alias);
        if (entry == null) {
            throw new KeyStoreException("entry == null");
        }
        if (this.engineContainsAlias(alias)) {
            this.engineDeleteEntry(alias);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trE = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trE.getTrustedCertificate());
            return;
        }
        char[] passW = null;
        if (protParam instanceof KeyStore.PasswordProtection) {
            try {
                passW = ((KeyStore.PasswordProtection)protParam).getPassword();
            }
            catch (IllegalStateException ee) {
                throw new KeyStoreException("Password was destroyed", ee);
            }
        } else {
            if (protParam instanceof KeyStore.CallbackHandlerProtection) {
                try {
                    throw new UnrecoverableEntryException("ProtectionParameter :PasswordFromCallBack not supported.");
                }
                catch (Exception e) {
                    throw new KeyStoreException(e);
                }
            }
            throw new KeyStoreException("protParam should be PasswordProtection or CallbackHandlerProtection");
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry prE = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(alias, prE.getPrivateKey(), passW, prE.getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry skE = (KeyStore.SecretKeyEntry)entry;
            this.engineSetKeyEntry(alias, skE.getSecretKey(), passW, null);
            return;
        }
        throw new KeyStoreException("Entry object is neither PrivateKeyObject nor SecretKeyEntry nor TrustedCertificateEntry: " + entry);
    }
}

