/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.cert.bundle;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedRenewalCertMap {
    private static final Logger LOG = LoggerFactory.getLogger(TimedRenewalCertMap.class);
    private HashMap<String, KeyCertBundle> bundleSet = new HashMap();
    private BundleFactory bundleFactory;
    private BundleFactory bundleFactoryFallback;
    private long minValiditySeconds = 86400L;

    public TimedRenewalCertMap(BundleFactory bundleFactory) {
        this(bundleFactory, null);
    }

    public TimedRenewalCertMap(BundleFactory bundleFactory, BundleFactory bundleFactoryFallback) {
        LOG.debug("cTor TimedRenewalCertMap(bundleFac, bundleFallback)");
        this.bundleFactory = bundleFactory;
        this.bundleFactoryFallback = bundleFactoryFallback;
        TimerTask repeatedTask = new TimerTask(){

            @Override
            public void run() {
                TimedRenewalCertMap.this.refreshFallbackBundles();
                Date refreshDate = new Date(System.currentTimeMillis() + TimedRenewalCertMap.this.minValiditySeconds * 1000L);
                Date now = new Date();
                LOG.info("Task 'renewal' started on " + now + ", refreshing #{} certificates expiring before {}", (Object)TimedRenewalCertMap.this.bundleSet.size(), (Object)refreshDate);
                for (KeyCertBundle kcb : TimedRenewalCertMap.this.bundleSet.values()) {
                    String bundleName = kcb.getAlias();
                    Date notAfter = kcb.getCertificate().getNotAfter();
                    LOG.debug("checking renewal for alias '{}', expiring on {} ", (Object)bundleName, (Object)notAfter);
                    if (now.after(notAfter)) {
                        LOG.error("renewal in time FAILED for alias '{}', expired on {} !", (Object)bundleName, (Object)notAfter);
                    }
                    if (!refreshDate.after(notAfter)) continue;
                    LOG.info("renewal required for alias '{}', expiring on {} ", (Object)bundleName, (Object)notAfter);
                    try {
                        TimedRenewalCertMap.this.putNewBundle(bundleName);
                    }
                    catch (GeneralSecurityException e) {
                        LOG.warn("renewal for alias '{}' expiring on {} failed : {}", new Object[]{bundleName, notAfter, e.getMessage()});
                        LOG.debug("certificate renewal failed", (Throwable)e);
                    }
                }
            }
        };
        Timer timer = new Timer("Timer");
        long delay = 1800000L;
        long period = 1800000L;
        timer.scheduleAtFixedRate(repeatedTask, delay, period);
    }

    void refreshFallbackBundles() {
        for (KeyCertBundle kcb : this.bundleSet.values()) {
            String bundleName = kcb.getAlias();
            if (!kcb.isFallbackCert() || this.bundleFactory == null) continue;
            LOG.info("forcing renewal of fallback bundle for alias '{}'", (Object)bundleName);
            try {
                KeyCertBundle bundle = this.bundleFactory.newKeyBundle(bundleName, this.minValiditySeconds);
                if (bundle == null) continue;
                this.bundleSet.put(bundleName, bundle);
                LOG.debug("default bundle factory created new bundle.");
            }
            catch (GeneralSecurityException e) {
                LOG.warn("fallback renewal for alias '{}' failed : {}", (Object)bundleName, (Object)e.getMessage());
                LOG.debug("certificate renewal failed", (Throwable)e);
            }
        }
    }

    public KeyCertBundle findBundleForAlias(String bundleName) {
        KeyCertBundle kcb;
        if (!this.bundleSet.containsKey(bundleName)) {
            if (this.bundleSet.isEmpty()) {
                LOG.debug("findBundleForAlias('{}') initial call to empty map, filling with new bundle", (Object)bundleName);
            } else {
                LOG.warn("findBundleForAlias('{}') failed to find KeyCertBundle", (Object)bundleName);
            }
            try {
                this.putNewBundle(bundleName);
            }
            catch (GeneralSecurityException e) {
                LOG.warn("creation / renewal for alias '{}' failed : {}", (Object)bundleName, (Object)e.getMessage());
                LOG.debug("certificate creation / renewal failed", (Throwable)e);
            }
        }
        if ((kcb = this.bundleSet.get(bundleName)) != null) {
            X509Certificate x509Cert = kcb.getCertificate();
            LOG.info("findBundleForAlias('{}') returns {}", (Object)bundleName, (Object)x509Cert.getSubjectX500Principal().getName());
        }
        return kcb;
    }

    public static void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            System.err.format("IOException: %s%n", e);
        }
    }

    public Set<String> aliases() {
        return this.bundleSet.keySet();
    }

    public boolean containsAlias(String alias) {
        return this.bundleSet.containsKey(alias);
    }

    public int size() {
        return this.bundleSet.size();
    }

    public String getAliasForCertificate(Certificate cert) {
        for (KeyCertBundle kcb : this.bundleSet.values()) {
            if (!kcb.getCertificate().equals(cert)) continue;
            return kcb.getAlias();
        }
        return null;
    }

    public void put(String alias, Certificate[] chain, Certificate certificate, Key key) {
        KeyCertBundle kbr = new KeyCertBundle(alias, (X509Certificate[])chain, (X509Certificate)chain[0], key);
        this.bundleSet.put(alias, kbr);
    }

    public BundleFactory getBundleFactory() {
        return this.bundleFactory;
    }

    public BundleFactory getBundleFactoryFallback() {
        return this.bundleFactoryFallback;
    }

    public void setBundleFactory(BundleFactory bundleFactory) {
        this.bundleFactory = bundleFactory;
        this.refreshFallbackBundles();
    }

    public void setBundleFactoryFallback(BundleFactory bundleFactoryFallback) {
        this.bundleFactoryFallback = bundleFactoryFallback;
    }

    public void putNewBundle(String bundleName) throws GeneralSecurityException {
        KeyCertBundle bundle;
        boolean useFallback;
        block5: {
            boolean bl = useFallback = this.bundleFactoryFallback != null;
            if (this.bundleFactory != null) {
                try {
                    bundle = this.bundleFactory.newKeyBundle(bundleName, this.minValiditySeconds);
                    if (bundle != null) {
                        this.bundleSet.put(bundleName, bundle);
                        LOG.debug("default bundle factory created new bundle.");
                        useFallback = false;
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.debug("default bundle factory threw Exception {} while creating new bundle.", (Object)e.getLocalizedMessage());
                    if (useFallback) break block5;
                    throw e;
                }
            }
        }
        if (useFallback && (bundle = this.bundleFactoryFallback.newKeyBundle(bundleName, this.minValiditySeconds)) != null) {
            bundle.setFallbackCert(true);
            this.bundleSet.put(bundleName, bundle);
            LOG.debug("fallback bundle factory created new bundle.");
        }
    }
}

