/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.cert.bundle;

import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.ca3s.cert.bundle.KeyStoreImpl;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedRenewalKeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreImpl.class);
    private X509KeyManager defaultKeyManager;
    private TimedRenewalCertMap certMap;

    public TimedRenewalKeyManager(X509KeyManager defaultKeyManager, TimedRenewalCertMap certMap) {
        LOG.debug("cTor KeyStoreImpl(bundleFac) called");
        this.defaultKeyManager = defaultKeyManager;
        this.certMap = certMap;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        LOG.debug("getCertificateChain({})", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb == null) {
            LOG.info("alias '" + alias + "' unknown");
            return null;
        }
        LOG.debug("getCertificateChain({} ) return chain with {} elements", (Object)alias, (Object)kcb.getCertificateChain().length);
        return kcb.getCertificateChain();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        LOG.debug("getPrivateKey({}, ***** )", (Object)alias);
        KeyCertBundle kcb = this.certMap.findBundleForAlias(alias);
        if (kcb == null) {
            LOG.debug("getPrivateKey({}, ***** ) cannot find key for alias ", (Object)alias);
            return null;
        }
        LOG.debug("getPrivateKey({}, ***** ) returns key ", (Object)alias);
        return (PrivateKey)kcb.getKey();
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        LOG.debug("chooseClientAlias()");
        return this.defaultKeyManager.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        LOG.debug("chooseServerAlias()");
        return this.defaultKeyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LOG.debug("getClientAliases()");
        return this.defaultKeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        LOG.debug("getServerAliases()");
        return this.defaultKeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }
}

