/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.cert.bundle;

import de.trustable.ca3s.cert.bundle.KeyStoreImpl;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import de.trustable.ca3s.cert.bundle.TimedRenewalKeyManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedRenewalKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private static final String DEFAULT_ALGO = KeyManagerFactory.getDefaultAlgorithm();
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreImpl.class);
    private TimedRenewalKeyManager keyManager = null;
    private String algoName = null;
    TimedRenewalCertMap certMap;

    public TimedRenewalKeyManagerFactorySpi(String algoName, TimedRenewalCertMap certMap) {
        this.algoName = algoName;
        this.certMap = certMap;
    }

    @Override
    public KeyManager[] engineGetKeyManagers() {
        LOG.debug("TimedRenewalKeyManagerFactorySpi::engineGetKeyManagers()");
        return new KeyManager[]{this.keyManager};
    }

    @Override
    public void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        LOG.debug("TimedRenewalKeyManagerFactorySpi::engineInit(ks)");
        KeyManagerFactory factory = KeyManagerFactory.getInstance(DEFAULT_ALGO);
        factory.init(ks, password);
        KeyManager[] keyManagers = factory.getKeyManagers();
        if (keyManagers == null || keyManagers.length == 0) {
            throw new NoSuchAlgorithmException("The default algorithm :" + DEFAULT_ALGO + " produced no key managers");
        }
        X509KeyManager x509KeyManager = null;
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            x509KeyManager = (X509KeyManager)keyManagers[i];
            break;
        }
        if (x509KeyManager == null) {
            throw new NoSuchAlgorithmException("The default algorithm :" + DEFAULT_ALGO + " did not produce a X509 Key manager");
        }
        this.keyManager = new TimedRenewalKeyManager(x509KeyManager, this.certMap);
        Security.setProperty("ssl.KeyManagerFactory.algorithm", this.algoName);
    }

    @Override
    public void engineInit(ManagerFactoryParameters spec) {
        LOG.debug("TimedRenewalKeyManagerFactorySpi::engineInit(spec), no implementation");
    }
}

