/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.client.api;

import de.trustable.ca3s.client.invoker.ADCSApiClient;
import de.trustable.ca3s.client.invoker.ApiException;
import de.trustable.ca3s.client.invoker.ApiResponse;
import de.trustable.ca3s.client.invoker.Pair;
import de.trustable.ca3s.client.model.ADCSInstanceDetailsResponse;
import de.trustable.ca3s.client.model.CertificateEnrollmentResponse;
import de.trustable.ca3s.client.model.GetCertificateResponse;
import de.trustable.ca3s.client.model.JWSWrappedRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.GenericType;

public class RemoteADCSClient {
    private ADCSApiClient apiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public RemoteADCSClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public RemoteADCSClient(String baseUrl, String apiKey, TrustManager[] trustManagers) {
        ADCSApiClient defaultClient = new ADCSApiClient(trustManagers);
        defaultClient.setBasePath(baseUrl);
        defaultClient.setApiKey(apiKey);
        this.apiClient = defaultClient;
    }

    public ADCSApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ADCSApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CertificateEnrollmentResponse buildCertificate(JWSWrappedRequest jwSWrappedRequest) throws ApiException {
        return this.buildCertificateWithHttpInfo(jwSWrappedRequest).getData();
    }

    public ApiResponse<CertificateEnrollmentResponse> buildCertificateWithHttpInfo(JWSWrappedRequest jwSWrappedRequest) throws ApiException {
        JWSWrappedRequest localVarPostBody = jwSWrappedRequest;
        if (jwSWrappedRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'jwSWrappedRequest' when calling buildCertificate");
        }
        String localVarPath = "/adcsCertificateBuilder";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CertificateEnrollmentResponse> localVarReturnType = new GenericType<CertificateEnrollmentResponse>(){};
        return this.apiClient.invokeAPI("AdcsCertificateBuilderApi.buildCertificate", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void revokeCertificate(JWSWrappedRequest jwSWrappedRequest) throws ApiException {
        this.revokeCertificateWithHttpInfo(jwSWrappedRequest);
    }

    public ApiResponse<Void> revokeCertificateWithHttpInfo(JWSWrappedRequest jwSWrappedRequest) throws ApiException {
        JWSWrappedRequest localVarPostBody = jwSWrappedRequest;
        if (jwSWrappedRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'jwSWrappedRequest' when calling revokeCertificate");
        }
        String localVarPath = "/adcsCertificateRevoker";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.invokeAPI("AdcsCertificateRevokerApi.revokeCertificate", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public String getADCSInfo() throws ApiException {
        return this.getADCSInfoWithHttpInfo().getData();
    }

    public ApiResponse<String> getADCSInfoWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/adcsInfo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI("AdcsInfoApi.getADCSInfo", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ADCSInstanceDetailsResponse getCAInstanceDetails() throws ApiException {
        return this.getCAInstanceDetailsWithHttpInfo().getData();
    }

    public ApiResponse<ADCSInstanceDetailsResponse> getCAInstanceDetailsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/adcsInstanceDetails";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ADCSInstanceDetailsResponse> localVarReturnType = new GenericType<ADCSInstanceDetailsResponse>(){};
        return this.apiClient.invokeAPI("AdcsInfoApi.getCAInstanceDetails", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<String> getCATemplates() throws ApiException {
        return this.getCATemplatesWithHttpInfo().getData();
    }

    public ApiResponse<List<String>> getCATemplatesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/adcsTemplates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI("AdcsInfoApi.getCATemplates", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public GetCertificateResponse getRequestById(String reqId) throws ApiException {
        return this.getRequestByIdWithHttpInfo(reqId).getData();
    }

    public ApiResponse<GetCertificateResponse> getRequestByIdWithHttpInfo(String reqId) throws ApiException {
        Object localVarPostBody = null;
        if (reqId == null) {
            throw new ApiException(400, "Missing the required parameter 'reqId' when calling getRequestById");
        }
        String localVarPath = "/adcsRequest/{reqId}".replaceAll("\\{reqId\\}", this.apiClient.escapeString(reqId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<GetCertificateResponse> localVarReturnType = new GenericType<GetCertificateResponse>(){};
        return this.apiClient.invokeAPI("AdcsRequestApi.getRequestById", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<String> getRequestIdList(Integer offset, Long resolvedWhenTimestamp, Long revokedWhenTimestamp, Integer limit) throws ApiException {
        return this.getRequestIdListWithHttpInfo(offset, resolvedWhenTimestamp, revokedWhenTimestamp, limit).getData();
    }

    public ApiResponse<List<String>> getRequestIdListWithHttpInfo(Integer offset, Long resolvedWhenTimestamp, Long revokedWhenTimestamp, Integer limit) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/adcsRequests/Ids";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "resolvedWhenTimestamp", resolvedWhenTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "revokedWhenTimestamp", revokedWhenTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI("AdcsRequestsApi.getRequestIdList", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

