/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.client.invoker;

import de.trustable.ca3s.client.invoker.ApiClient;
import de.trustable.ca3s.client.invoker.auth.ApiKeyAuth;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.ClientBuilder;

public class ADCSApiClient
extends ApiClient {
    private static final Logger log = Logger.getLogger(ADCSApiClient.class.getName());
    private final TrustManager[] trustManagers;

    public ADCSApiClient(TrustManager[] trustManagers) {
        super(null);
        this.authentications = new HashMap();
        this.authentications.put("ApiKeyAuth", new ApiKeyAuth("header", "X-API-Key"));
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.trustManagers = trustManagers;
        this.httpClient = this.buildHttpClient();
        log.fine("instantiating ADCSApiClient with trustManagers " + Arrays.toString(trustManagers));
    }

    @Override
    protected void customizeClientBuilder(ClientBuilder clientBuilder) {
        if (this.trustManagers == null) {
            log.info("customizeClientBuilder without trustManagers");
        } else {
            log.fine("customizeClientBuilder with " + this.trustManagers.getClass().getName());
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, this.trustManagers, new SecureRandom());
                clientBuilder.sslContext(sslContext);
                log.fine("jackson client customized");
            }
            catch (GeneralSecurityException gse) {
                log.log(Level.SEVERE, "problem customizing jackson client", gse);
            }
        }
    }
}

