/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.client.invoker;

import de.trustable.ca3s.client.invoker.ApiException;
import de.trustable.ca3s.client.invoker.ApiResponse;
import de.trustable.ca3s.client.invoker.JSON;
import de.trustable.ca3s.client.invoker.JavaTimeFormatter;
import de.trustable.ca3s.client.invoker.Pair;
import de.trustable.ca3s.client.invoker.RFC3339DateFormat;
import de.trustable.ca3s.client.invoker.ServerConfiguration;
import de.trustable.ca3s.client.invoker.ServerVariable;
import de.trustable.ca3s.client.invoker.StringUtil;
import de.trustable.ca3s.client.invoker.auth.ApiKeyAuth;
import de.trustable.ca3s.client.invoker.auth.Authentication;
import de.trustable.ca3s.client.invoker.auth.HttpBasicAuth;
import de.trustable.ca3s.client.invoker.auth.HttpBearerAuth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ApiClient
extends JavaTimeFormatter {
    protected Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    protected Map<String, String> defaultCookieMap = new HashMap<String, String>();
    protected String basePath = "http://192.168.56.102:8080/ADCSConnector";
    protected String userAgent;
    private static final Logger log = Logger.getLogger(ApiClient.class.getName());
    protected List<ServerConfiguration> servers = new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("http://192.168.56.102:8080/ADCSConnector", "Generated server url", new HashMap<String, ServerVariable>())));
    protected Integer serverIndex = 0;
    protected Map<String, String> serverVariables = null;
    protected Map<String, List<ServerConfiguration>> operationServers = new HashMap<String, List<ServerConfiguration>>(){};
    protected Map<String, Integer> operationServerIndex = new HashMap<String, Integer>();
    protected Map<String, Map<String, String>> operationServerVariables = new HashMap<String, Map<String, String>>();
    protected boolean debugging = false;
    protected ClientConfig clientConfig;
    protected int connectionTimeout = 0;
    private int readTimeout = 0;
    protected Client httpClient;
    protected JSON json = new JSON();
    protected String tempFolderPath = null;
    protected Map<String, Authentication> authentications;
    protected Map<String, String> authenticationLookup;
    protected DateFormat dateFormat;

    public ApiClient() {
        this(null);
    }

    public ApiClient(Map<String, Authentication> authMap) {
        this.httpClient = this.buildHttpClient();
        this.dateFormat = new RFC3339DateFormat();
        this.setUserAgent("OpenAPI-Generator/v0/java");
        this.authentications = new HashMap<String, Authentication>();
        Object auth = null;
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.authenticationLookup = new HashMap<String, String>();
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public List<ServerConfiguration> getServers() {
        return this.servers;
    }

    public ApiClient setServers(List<ServerConfiguration> servers) {
        this.servers = servers;
        this.updateBasePath();
        return this;
    }

    public Integer getServerIndex() {
        return this.serverIndex;
    }

    public ApiClient setServerIndex(Integer serverIndex) {
        this.serverIndex = serverIndex;
        this.updateBasePath();
        return this;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public ApiClient setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        this.updateBasePath();
        return this;
    }

    private void updateBasePath() {
        if (this.serverIndex != null) {
            this.setBasePath(this.servers.get(this.serverIndex).URL(this.serverVariables));
        }
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public ApiClient setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return this;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return this;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient configureApiKeys(Map<String, String> secrets) {
        for (Map.Entry<String, Authentication> authEntry : this.authentications.entrySet()) {
            String name;
            Authentication auth = authEntry.getValue();
            if (!(auth instanceof ApiKeyAuth) || !secrets.containsKey(name = this.authenticationLookup.containsKey(name = authEntry.getKey()) ? this.authenticationLookup.get(name) : name)) continue;
            ((ApiKeyAuth)auth).setApiKey(secrets.get(name));
        }
        return this;
    }

    public ApiClient setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient setBearerToken(String bearerToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)auth).setBearerToken(bearerToken);
            return this;
        }
        throw new RuntimeException("No Bearer authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookieMap.put(key, value);
        return this;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ApiClient setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.httpClient = this.buildHttpClient();
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.httpClient = this.buildHttpClient();
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.httpClient.property("jersey.config.client.readTimeout", (Object)readTimeout);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(format)) {
            delimiter = ",";
        } else if ("ssv".equals(format)) {
            delimiter = " ";
        } else if ("tsv".equals(format)) {
            delimiter = "\t";
        } else if ("pipes".equals(format)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType, boolean isBodyNullable) throws ApiException {
        Entity entity;
        if (contentType.startsWith("multipart/form-data")) {
            MultiPart multiPart = new MultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    FormDataContentDisposition contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(file.getName())).size(file.length())).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                FormDataContentDisposition contentDisp = FormDataContentDisposition.name((String)param.getKey()).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, this.parameterToString(param.getValue())));
            }
            entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = isBodyNullable ? (obj instanceof String ? Entity.entity((Object)(obj == null ? "null" : "\"" + ((String)obj).replaceAll("\"", Matcher.quoteReplacement("\\\"")) + "\""), (String)contentType) : Entity.entity((Object)(obj == null ? "null" : obj), (String)contentType)) : (obj instanceof String ? Entity.entity((Object)(obj == null ? "" : "\"" + ((String)obj).replaceAll("\"", Matcher.quoteReplacement("\\\"")) + "\""), (String)contentType) : Entity.entity((Object)(obj == null ? "" : obj), (String)contentType));
        }
        return entity;
    }

    public String serializeToString(Object obj, Map<String, Object> formParams, String contentType, boolean isBodyNullable) throws ApiException {
        try {
            if (contentType.startsWith("multipart/form-data")) {
                throw new ApiException("multipart/form-data not yet supported for serializeToString (http signature authentication)");
            }
            if (contentType.startsWith("application/x-www-form-urlencoded")) {
                String formString = "";
                for (Map.Entry<String, Object> param : formParams.entrySet()) {
                    formString = param.getKey() + "=" + URLEncoder.encode(this.parameterToString(param.getValue()), "UTF-8") + "&";
                }
                if (formString.length() == 0) {
                    return formString;
                }
                return formString.substring(0, formString.length() - 1);
            }
            if (isBodyNullable) {
                return obj == null ? "null" : this.json.getMapper().writeValueAsString(obj);
            }
            return obj == null ? "" : this.json.getMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw new ApiException("Failed to perform serializeToString: " + ex.toString());
        }
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        if (returnType.getRawType() == File.class) {
            File file = this.downloadFileFromResponse(response);
            return (T)file;
        }
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = String.valueOf(contentTypes.get(0));
        }
        response.bufferEntity();
        return (T)response.readEntity(returnType);
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        String prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(Paths.get(this.tempFolderPath, new String[0]), prefix, suffix, new FileAttribute[0]).toFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> ApiResponse<T> invokeAPI(String operation, String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType, boolean isBodyNullable) throws ApiException {
        Object value;
        String targetURL;
        if (this.serverIndex != null && this.operationServers.containsKey(operation)) {
            Integer index = this.operationServerIndex.containsKey(operation) ? this.operationServerIndex.get(operation) : this.serverIndex;
            Map<String, String> variables = this.operationServerVariables.containsKey(operation) ? this.operationServerVariables.get(operation) : this.serverVariables;
            List<ServerConfiguration> list = this.operationServers.get(operation);
            if (index < 0 || index >= list.size()) {
                throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", index, list.size()));
            }
            targetURL = list.get(index).URL(variables) + path;
        } else {
            targetURL = this.basePath + path;
        }
        WebTarget target = this.httpClient.target(targetURL);
        if (queryParams != null) {
            for (Pair pair : queryParams) {
                if (pair.getValue() == null) continue;
                target = target.queryParam(pair.getName(), new Object[]{this.escapeString(pair.getValue())});
            }
        }
        Invocation.Builder invocationBuilder = accept != null ? target.request().accept(new String[]{accept}) : target.request();
        for (Map.Entry<String, String> entry : cookieParams.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), (String)value);
        }
        for (Map.Entry<String, String> entry : this.defaultCookieMap.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), (String)value);
        }
        Entity<?> entity = this.serialize(body, formParams, contentType, isBodyNullable);
        HashMap<String, String> allHeaderParams = new HashMap<String, String>(this.defaultHeaderMap);
        allHeaderParams.putAll(headerParams);
        this.updateParamsForAuth(authNames, queryParams, allHeaderParams, cookieParams, this.serializeToString(body, formParams, contentType, isBodyNullable), method, target.getUri());
        for (Map.Entry entry : allHeaderParams.entrySet()) {
            String value2 = (String)entry.getValue();
            if (value2 == null) continue;
            invocationBuilder = invocationBuilder.header((String)entry.getKey(), (Object)value2);
        }
        Response response = null;
        try {
            response = this.sendRequest(method, invocationBuilder, entity);
            int n = response.getStatusInfo().getStatusCode();
            Map<String, List<String>> responseHeaders = this.buildResponseHeaders(response);
            if (response.getStatusInfo() == Response.Status.NO_CONTENT) {
                ApiResponse apiResponse = new ApiResponse(n, responseHeaders);
                return apiResponse;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (returnType == null) {
                    ApiResponse apiResponse = new ApiResponse(n, responseHeaders);
                    return apiResponse;
                }
                ApiResponse<T> apiResponse = new ApiResponse<T>(n, responseHeaders, this.deserialize(response, returnType));
                return apiResponse;
            }
            String message = "error";
            String respBody = null;
            if (!response.hasEntity()) throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
                throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    private Response sendRequest(String method, Invocation.Builder invocationBuilder, Entity<?> entity) {
        Response response = "POST".equals(method) ? invocationBuilder.post(entity) : ("PUT".equals(method) ? invocationBuilder.put(entity) : ("DELETE".equals(method) ? invocationBuilder.method("DELETE", entity) : ("PATCH".equals(method) ? invocationBuilder.method("PATCH", entity) : invocationBuilder.method(method))));
        return response;
    }

    @Deprecated
    public <T> ApiResponse<T> invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType, boolean isBodyNullable) throws ApiException {
        return this.invokeAPI(null, path, method, queryParams, body, headerParams, cookieParams, formParams, accept, contentType, authNames, returnType, isBodyNullable);
    }

    protected Client buildHttpClient() {
        this.clientConfig = this.getDefaultClientConfig();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        this.customizeClientBuilder(clientBuilder);
        clientBuilder = clientBuilder.withConfig((Configuration)this.clientConfig);
        return clientBuilder.build();
    }

    public ClientConfig getDefaultClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        clientConfig.register((Object)this.json);
        clientConfig.register(JacksonFeature.class);
        clientConfig.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (this.debugging) {
            clientConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(51200)));
            clientConfig.property("jersey.config.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
            Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME).setLevel(Level.ALL);
        } else {
            Logger.getLogger("org.glassfish.jersey.client").setLevel(Level.SEVERE);
        }
        return clientConfig;
    }

    protected void customizeClientBuilder(ClientBuilder clientBuilder) {
    }

    protected void disableCertificateValidation(ClientBuilder clientBuilder) throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        clientBuilder.sslContext(sslContext);
    }

    protected Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), headers);
        }
        return responseHeaders;
    }

    protected void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) continue;
            auth.applyToParams(queryParams, headerParams, cookieParams, payload, method, uri);
        }
    }
}

