/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.client.invoker.auth;

import de.trustable.ca3s.client.invoker.ApiException;
import de.trustable.ca3s.client.invoker.Pair;
import de.trustable.ca3s.client.invoker.auth.Authentication;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private String bearerToken;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        if (this.bearerToken == null) {
            return;
        }
        headerParams.put("Authorization", (this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + this.bearerToken);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

