/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.util;

import com.puppetlabs.ssl_utils.ExtensionsUtils;
import de.trustable.util.AlgorithmInfo;
import de.trustable.util.JCESigner;
import de.trustable.util.OidNameMapper;
import de.trustable.util.PKILevel;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cmp.RevRepContentBuilder;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.CertificateRequestMessageBuilder;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    private static final String SERIAL_PADDING_PATTERN = "000000000000000000000";
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoUtil.class);
    private static final Logger LOGGERContentProtection = LoggerFactory.getLogger((String)(CryptoUtil.class.getName() + ".ContentProtection"));
    SecureRandom secRandom = new SecureRandom();

    public static String getPaddedSerial(String serial) {
        int len = serial.length();
        if (len >= SERIAL_PADDING_PATTERN.length()) {
            return serial;
        }
        return SERIAL_PADDING_PATTERN.substring(serial.length()) + serial;
    }

    public static byte[] generateSHA1Fingerprint(byte[] ba) {
        return CryptoUtil.generateFingerprint(ba, "SHA1");
    }

    public static byte[] generateMD5Fingerprint(byte[] ba) {
        return CryptoUtil.generateFingerprint(ba, "MD5");
    }

    public static byte[] generateFingerprint(byte[] ba, String algoName) {
        try {
            MessageDigest md = MessageDigest.getInstance(algoName);
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.error("'" + algoName + "' algorithm not supported", (Throwable)nsae);
            return null;
        }
    }

    public static String usageAsString(boolean[] usage) {
        if (usage == null || usage.length == 0) {
            return "unspecified usage";
        }
        String desc = "valid for ";
        if (usage[0]) {
            desc = desc + "digitalSignature ";
        }
        if (usage.length > 1 && usage[1]) {
            desc = desc + "nonRepudiation ";
        }
        if (usage.length > 2 && usage[2]) {
            desc = desc + "keyEncipherment ";
        }
        if (usage.length > 3 && usage[3]) {
            desc = desc + "dataEncipherment ";
        }
        if (usage.length > 4 && usage[4]) {
            desc = desc + "keyAgreement ";
        }
        if (usage.length > 5 && usage[5]) {
            desc = desc + "keyCertSign ";
        }
        if (usage.length > 6 && usage[6]) {
            desc = desc + "cRLSign ";
        }
        if (usage.length > 7 && usage[7]) {
            desc = desc + "encipherOnly ";
        }
        if (usage.length > 8 && usage[8]) {
            desc = desc + "decipherOnly ";
        }
        return desc;
    }

    public Pkcs10RequestHolder parseCertificateRequest(byte[] csr) throws IOException, GeneralSecurityException {
        return this.parseCertificateRequest(new PKCS10CertificationRequest(csr));
    }

    public Pkcs10RequestHolder parseCertificateRequest(PKCS10CertificationRequest p10Request) throws IOException, GeneralSecurityException {
        Pkcs10RequestHolder reqHolder = new Pkcs10RequestHolder();
        reqHolder.setP10Req(p10Request);
        X500Name subject = reqHolder.getP10Req().getSubject();
        reqHolder.setSubjectRDNs(subject.getRDNs());
        reqHolder.setSubject(subject.toString());
        reqHolder.setReqAttributes(reqHolder.getP10Req().getAttributes());
        String signingAlgorithm = reqHolder.getP10Req().getSignatureAlgorithm().getAlgorithm().getId();
        AlgorithmInfo algorithmInfo = new AlgorithmInfo(signingAlgorithm);
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)reqHolder.getP10Req().getSignatureAlgorithm().getAlgorithm())) {
            RSASSAPSSparams rsassapssParams = RSASSAPSSparams.getInstance((Object)reqHolder.getP10Req().getSignatureAlgorithm().getParameters());
            LOGGER.info("rsassapsSparams : " + rsassapssParams.getHashAlgorithm().getAlgorithm().getId());
            algorithmInfo = new AlgorithmInfo(rsassapssParams);
        }
        reqHolder.setAlgorithmInfo(algorithmInfo);
        reqHolder.setSigningAlgorithm(signingAlgorithm);
        reqHolder.setSigningAlgorithmName(OidNameMapper.lookupOid(signingAlgorithm));
        SubjectPublicKeyInfo subjectPKInfo = reqHolder.getP10Req().getSubjectPublicKeyInfo();
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)subjectPKInfo).getBytes());
            reqHolder.setX509KeySpec(xspec.getFormat());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithm();
            reqHolder.setPublicKeyAlgorithm(keyAlg.getAlgorithm().getId());
            reqHolder.setPublicKeyAlgorithmName(OidNameMapper.lookupOid(keyAlg.getAlgorithm().getId()));
            reqHolder.setPublicKeyAlgorithmShortName(AlgorithmInfo.getSigAlgoShortName(reqHolder.getPublicKeyAlgorithmName()));
            PublicKey publicKey = KeyFactory.getInstance(keyAlg.getAlgorithm().getId(), "BC").generatePublic(xspec);
            reqHolder.setPublicSigningKey(publicKey);
            reqHolder.setSubjectPublicKeyInfoBase64(Base64.toBase64String((byte[])subjectPKInfo.getEncoded()));
            reqHolder.setPublicKeyHash(this.getHashAsBase64(publicKey.getEncoded()));
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
            reqHolder.setCSRValid(reqHolder.getP10Req().isSignatureValid(contentVerifierProvider));
            LOGGER.info("p10Request.getSignature() : \n" + Base64.toBase64String((byte[])p10Request.getSignature()));
            LOGGER.info("SubjectPublicKeyInfo().getAlgorithm() : " + p10Request.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId());
        }
        catch (OperatorCreationException e1) {
            LOGGER.info("Problem processing the incoming csr", (Throwable)e1);
            throw new GeneralSecurityException(e1.getMessage());
        }
        catch (PKCSException e) {
            LOGGER.info("Problem parsing the incoming csr", (Throwable)e);
            throw new GeneralSecurityException(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            LOGGER.info("retrieving public key from CSR failed", (Throwable)e);
            throw new GeneralSecurityException("error retrieving public key from CSR: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("algorithm of CSR unknown", (Throwable)e);
            throw new GeneralSecurityException("algorithm of CSR unknown: " + e.getMessage());
        }
        return reqHolder;
    }

    public PublicKey getPublicKeyFromCSR(PKCS10CertificationRequest p10Req) throws IOException, GeneralSecurityException {
        PublicKey publicKey;
        SubjectPublicKeyInfo subjectPKInfo = p10Req.getSubjectPublicKeyInfo();
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)subjectPKInfo).getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithm();
            publicKey = KeyFactory.getInstance(keyAlg.getAlgorithm().getId(), "BC").generatePublic(xspec);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.info("retrieving public key from CSR failed", (Throwable)e);
            throw new GeneralSecurityException("error retrieving public key from CSR: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("algorithm of CSR unknown", (Throwable)e);
            throw new GeneralSecurityException("algorithm of CSR unknown: " + e.getMessage());
        }
        return publicKey;
    }

    public static String pkcs10RequestToPem(PKCS10CertificationRequest req) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)req);
        pemWriter.close();
        return stringWriter.toString();
    }

    public String x509CertToPem(X509Certificate cert) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)cert);
        pemWriter.close();
        return stringWriter.toString();
    }

    public String publicKeyToPem(PublicKey pk) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        pemWriter.writeObject((Object)pk);
        pemWriter.close();
        return stringWriter.toString();
    }

    public Pkcs10RequestHolder parseCertificateRequest(String csr) throws IOException, GeneralSecurityException {
        return this.parseCertificateRequest(this.convertPemToPKCS10CertificationRequest(csr));
    }

    public PKCS10CertificationRequest convertPemToPKCS10CertificationRequest(String pem) throws GeneralSecurityException {
        PKCS10CertificationRequest csr;
        block11: {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of CSR failed! Not PEM encoded?");
                }
                if (parsedObj instanceof PKCS10CertificationRequest) {
                    csr = (PKCS10CertificationRequest)parsedObj;
                    break block11;
                }
                throw new GeneralSecurityException("Parsing of CSR failed! Unexpected content of type: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOGGER.error("IOException, convertPemToPublicKey", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of CSR failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOGGER.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return csr;
    }

    public PublicKey convertPemToPublicKey(String pem) throws GeneralSecurityException {
        PublicKey pubKey = null;
        ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
        InputStreamReader pemReader = new InputStreamReader(pemStream);
        PEMParser pemParser = new PEMParser((Reader)pemReader);
        try {
            Object parsedObj = pemParser.readObject();
            if (parsedObj == null) {
                throw new GeneralSecurityException("Parsing of PublicKey failed! Not PEM encoded?");
            }
            if (parsedObj instanceof PublicKey) {
                pubKey = (PublicKey)parsedObj;
            }
        }
        catch (IOException ex) {
            LOGGER.error("IOException, convertPemToPublicKey", (Throwable)ex);
            throw new GeneralSecurityException("Parsing of PublicKey  failed! Not PEM encoded?");
        }
        finally {
            try {
                pemParser.close();
            }
            catch (IOException e) {
                LOGGER.debug("IOException on close()", (Throwable)e);
            }
        }
        return pubKey;
    }

    public X509CertificateHolder convertPemToCertificateHolder(String pem) throws GeneralSecurityException {
        X509Certificate x509Cert = CryptoUtil.convertPemToCertificate(pem);
        try {
            return new X509CertificateHolder(x509Cert.getEncoded());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static X509Certificate convertPemToCertificate(String pem) throws GeneralSecurityException {
        X509Certificate cert;
        block11: {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
                }
                LOGGER.debug("PemParser returned: " + parsedObj);
                if (parsedObj instanceof X509CertificateHolder) {
                    cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)parsedObj);
                    break block11;
                }
                throw new GeneralSecurityException("Unexpected parsing result: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOGGER.error("IOException, convertPemToCertificate", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOGGER.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return cert;
    }

    public PrivateKey convertPemToPrivateKey(String pem) throws GeneralSecurityException {
        PrivateKey privKey;
        block11: {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
                }
                if (parsedObj instanceof PrivateKeyInfo) {
                    privKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey((PrivateKeyInfo)parsedObj);
                    break block11;
                }
                throw new GeneralSecurityException("Unexpected parsing result: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOGGER.error("IOException, convertPemToCertificate", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOGGER.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return privKey;
    }

    public ASN1Primitive getDERObject(byte[] ba) throws IOException {
        try (ASN1InputStream ins = new ASN1InputStream(ba);){
            ASN1Primitive aSN1Primitive = ins.readObject();
            return aSN1Primitive;
        }
    }

    public String getHashAsBase64(byte[] content) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(content);
        byte[] digest = md.digest();
        return Base64.toBase64String((byte[])digest);
    }

    public static String getCsrAsPEM(X500Principal subject, PublicKey pubKey, PrivateKey priKey, char[] password) throws GeneralSecurityException, IOException {
        PKCS10CertificationRequest req = CryptoUtil.getCsr(subject, pubKey, priKey, password);
        return CryptoUtil.pkcs10RequestToPem(req);
    }

    public static PKCS10CertificationRequest getCsr(X500Principal subject, PublicKey pubKey, PrivateKey priKey, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.getCsr(subject, pubKey, priKey, password, null, null);
    }

    public static PKCS10CertificationRequest getCsr(X500Principal subject, PublicKey pubKey, PrivateKey priKey, char[] password, List<Map<String, Object>> extensions) throws GeneralSecurityException, IOException {
        return CryptoUtil.getCsr(subject, pubKey, priKey, password, extensions, null);
    }

    public static PKCS10CertificationRequest getCsr(X500Principal subject, PublicKey pubKey, PrivateKey priKey, char[] password, List<Map<String, Object>> extensions, GeneralName[] sanArray) throws GeneralSecurityException, IOException {
        return CryptoUtil.getCsr(subject, pubKey, priKey, password, extensions, sanArray, "SHA256WithRSAEncryption");
    }

    public static PKCS10CertificationRequest getCsr(X500Principal subject, PublicKey pubKey, PrivateKey priKey, char[] password, List<Map<String, Object>> extensions, GeneralName[] sanArray, String signingAlgorithmName) throws GeneralSecurityException, IOException {
        ContentSigner signer;
        SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signingAlgorithmName);
        try {
            signer = signerBuilder.build(priKey);
        }
        catch (OperatorCreationException e) {
            throw new IOException(e);
        }
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(X500Name.getInstance((Object)subject.getEncoded()), pkInfo);
        if (password != null) {
            DERPrintableString cpSet = new DERPrintableString(new String(password));
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)cpSet);
        }
        if (extensions != null && extensions.size() > 0) {
            Extensions parsedExts = ExtensionsUtils.getExtensionsObjFromMap(extensions);
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)parsedExts);
        }
        if (sanArray != null && sanArray.length > 0) {
            ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
            GeneralNames subjectAltNames = new GeneralNames(sanArray);
            extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
            LOGGER.debug("added #{} sans", (Object)sanArray.length);
            for (GeneralName gn : sanArray) {
                LOGGER.debug("san :" + gn);
            }
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
        }
        return builder.build(signer);
    }

    public String getDescription(X509Certificate x509Certificate) {
        String subject = "noSubject";
        String issuer = "noIssuer";
        String serial = "noSerial";
        if (x509Certificate != null) {
            if (x509Certificate.getSubjectDN() != null) {
                subject = x509Certificate.getSubjectDN().getName();
            }
            if (x509Certificate.getIssuerDN() != null) {
                issuer = x509Certificate.getIssuerDN().getName();
            }
            serial = String.valueOf(x509Certificate.getSerialNumber());
        }
        if (subject == null || subject.length() == 0) {
            return issuer + " / #" + serial;
        }
        return subject + " (#" + serial + ")";
    }

    public CRLReason crlReasonFromString(String revocationReasonStr) {
        int revReason;
        block10: {
            revReason = 0;
            try {
                revReason = Integer.parseInt(revocationReasonStr);
            }
            catch (NumberFormatException nfe) {
                if ("keyCompromise".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 1;
                }
                if ("cACompromise".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 2;
                }
                if ("affiliationChanged".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 3;
                }
                if ("superseded".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 4;
                }
                if ("cessationOfOperation".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 5;
                }
                if ("privilegeWithdrawn".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 9;
                }
                if ("aACompromise".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 10;
                }
                if ("certificateHold".equalsIgnoreCase(revocationReasonStr)) {
                    revReason = 6;
                }
                if (!"removeFromCRL".equalsIgnoreCase(revocationReasonStr)) break block10;
                revReason = 8;
            }
        }
        return CRLReason.lookup((int)revReason);
    }

    public String crlReasonAsString(CRLReason crlReason) {
        switch (crlReason.getValue().intValue()) {
            case 1: {
                return "keyCompromise";
            }
            case 2: {
                return "cACompromise";
            }
            case 3: {
                return "affiliationChanged";
            }
            case 4: {
                return "superseded";
            }
            case 5: {
                return "cessationOfOperation";
            }
            case 9: {
                return "privilegeWithdrawn";
            }
            case 10: {
                return "aACompromise";
            }
            case 6: {
                return "certificateHold";
            }
            case 8: {
                return "removeFromCRL";
            }
        }
        return "unspecified";
    }

    public static String limitLength(String in, int maxLength) {
        if (in == null) {
            return "";
        }
        int len = Math.min(in.length(), maxLength);
        return in.substring(0, len);
    }

    public static SubjectKeyIdentifier[] getSKI(X509Certificate x509Cert) throws NoSuchAlgorithmException {
        SubjectKeyIdentifier skiTruncated;
        SubjectKeyIdentifier skiCalculated;
        SubjectKeyIdentifier[] skiArr = new SubjectKeyIdentifier[2];
        JcaX509ExtensionUtils util = new JcaX509ExtensionUtils();
        skiArr[0] = skiCalculated = util.createSubjectKeyIdentifier(x509Cert.getPublicKey());
        skiArr[1] = skiTruncated = util.createTruncatedSubjectKeyIdentifier(x509Cert.getPublicKey());
        return skiArr;
    }

    public String getSHA256DigestAsString(byte[] bInArr) throws NoSuchAlgorithmException {
        return Base64.toBase64String((byte[])this.getSHA256Digest(bInArr));
    }

    public byte[] getSHA256Digest(byte[] bInArr) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(bInArr);
        return md.digest();
    }

    public ProtectedPKIMessageBuilder getPKIBuilder(X500Name recipientDN, X500Name senderDN) {
        long millis = System.currentTimeMillis();
        byte[] senderNonce = ("nonce" + millis).getBytes();
        byte[] transactionId = ("transactionId" + millis).getBytes();
        byte[] keyId = ("keyId" + millis).getBytes();
        return this.getPKIBuilder(recipientDN, senderDN, senderNonce, null, transactionId, keyId, null);
    }

    public ProtectedPKIMessageBuilder getPKIResponseBuilder(X500Name recipientDN, X500Name senderDN, PKIHeader pkiHeader) {
        byte[] senderNonce = null;
        if (pkiHeader.getSenderNonce() != null) {
            senderNonce = pkiHeader.getSenderNonce().getOctets();
        }
        byte[] transactionId = null;
        if (pkiHeader.getTransactionID() != null) {
            transactionId = pkiHeader.getTransactionID().getOctets();
        }
        byte[] keyId = null;
        if (pkiHeader.getRecipKID() != null) {
            keyId = pkiHeader.getRecipKID().getOctets();
        }
        return this.getPKIBuilder(recipientDN, senderDN, null, senderNonce, transactionId, null, keyId);
    }

    public ProtectedPKIMessageBuilder getPKIBuilder(X500Name recipientDN, X500Name senderDN, byte[] senderNonce, byte[] recipNonce, byte[] transactionId, byte[] keyId, byte[] recipKeyId) {
        GeneralName sender = new GeneralName(senderDN);
        GeneralName recipient = new GeneralName(recipientDN);
        ProtectedPKIMessageBuilder pbuilder = new ProtectedPKIMessageBuilder(sender, recipient);
        pbuilder.setMessageTime(new Date());
        if (senderNonce != null) {
            pbuilder.setSenderNonce(senderNonce);
        }
        if (recipNonce != null) {
            pbuilder.setRecipNonce(recipNonce);
        }
        if (transactionId != null) {
            pbuilder.setTransactionID(transactionId);
        }
        if (keyId != null) {
            pbuilder.setSenderKID(keyId);
        }
        if (recipKeyId != null) {
            pbuilder.setRecipKID(recipKeyId);
        }
        return pbuilder;
    }

    public PKMACBuilder getMacCalculatorBuilder() throws CRMFException {
        JcePKMACValuesCalculator jcePkmacCalc = new JcePKMACValuesCalculator();
        AlgorithmIdentifier digAlg = new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"));
        AlgorithmIdentifier macAlg = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.2.9"));
        LOGGER.debug("instantiating MacCalculatorBuilder for : {} ( {}", (Object)digAlg, (Object)macAlg);
        jcePkmacCalc.setup(digAlg, macAlg);
        return new PKMACBuilder((PKMACValuesCalculator)jcePkmacCalc);
    }

    public MacCalculator getMacCalculator(String hmacSecret) throws CRMFException {
        PKMACBuilder macbuilder = this.getMacCalculatorBuilder();
        return macbuilder.build(hmacSecret.toCharArray());
    }

    public X509Certificate buildSelfsignedCertificate(X500Name issuer, KeyPair keyPair) throws NoSuchAlgorithmException, IOException, CertificateException {
        return this.issueCertificate(issuer, keyPair, issuer, keyPair.getPublic().getEncoded(), 1, 1, PKILevel.ROOT);
    }

    public byte[] handleCMPRequest(String alias, String hmacSecret, byte[] requestBytes, java.security.cert.Certificate issuingCertificate, X500Name issuer, KeyPair keyPair) throws IOException, GeneralSecurityException, CRMFException, CMPException {
        ASN1Primitive derObject;
        PKIMessage pkiMessage;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("incoming CMP request: " + Base64.toBase64String((byte[])requestBytes));
        }
        if ((pkiMessage = PKIMessage.getInstance((Object)(derObject = this.getDERObject(requestBytes)))) == null) {
            throw new GeneralSecurityException("No CMP message could be parsed from received Der object.");
        }
        this.printPKIMessageInfo(pkiMessage);
        PKIBody requestBody = pkiMessage.getBody();
        int type = requestBody.getType();
        switch (type) {
            case 0: 
            case 2: {
                LOGGER.debug("incoming CMP certificate request");
                CertReqMessages certReqMsgs = (CertReqMessages)requestBody.getContent();
                CertReqMsg[] certReqMsgArr = certReqMsgs.toCertReqMsgArray();
                if ("fail".equals(alias)) {
                    return this.buildErrorResponse(pkiMessage, hmacSecret, issuer);
                }
                return this.buildCertificateResponse(pkiMessage, certReqMsgArr, hmacSecret, issuingCertificate, issuer, keyPair);
            }
            case 11: {
                LOGGER.debug("incoming CMP revocation request");
                return this.buildRevocationResponse(pkiMessage, hmacSecret, issuer);
            }
            case 21: {
                LOGGER.debug("incoming CMP general message");
                return this.buildErrorResponse(pkiMessage, hmacSecret, issuer);
            }
        }
        throw new CMPException("unexpected request type '" + requestBody.getType() + "'");
    }

    PKIBody readPKIBodyFromRequest(byte[] requestBytes) throws IOException, GeneralSecurityException {
        ASN1Primitive derObject = this.getDERObject(requestBytes);
        PKIMessage pkiMessage = PKIMessage.getInstance((Object)derObject);
        if (pkiMessage == null) {
            throw new GeneralSecurityException("No CMP message could be parsed from received Der object.");
        }
        this.printPKIMessageInfo(pkiMessage);
        return pkiMessage.getBody();
    }

    private void printPKIMessageInfo(PKIMessage pkiMessage) {
        PKIHeader header = pkiMessage.getHeader();
        PKIBody body = pkiMessage.getBody();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received CMP message with pvno=" + header.getPvno() + ", sender=" + header.getSender().toString() + ", recipient=" + header.getRecipient().toString());
            LOGGER.debug("Body is of type: " + body.getType());
            LOGGER.debug("Transaction id: " + header.getTransactionID());
        }
    }

    private void printPKIMessageInfo(GeneralPKIMessage pkiMessage) {
        PKIHeader header = pkiMessage.getHeader();
        PKIBody body = pkiMessage.getBody();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received " + (pkiMessage.hasProtection() ? " protected " : "") + "CMP message with pvno=" + header.getPvno() + ", sender=" + header.getSender().toString() + ", recipient=" + header.getRecipient().toString());
            LOGGER.debug("Body is of type: " + body.getType());
            LOGGER.debug("Transaction id: " + header.getTransactionID());
        }
    }

    PKIMessage readPKIMessageFromRequest(byte[] requestBytes) throws IOException, GeneralSecurityException {
        ASN1Primitive derObject = this.getDERObject(requestBytes);
        PKIMessage pkiMessage = PKIMessage.getInstance((Object)derObject);
        if (pkiMessage == null) {
            throw new GeneralSecurityException("No CMP message could be parsed from received Der object.");
        }
        return pkiMessage;
    }

    public byte[] buildCertificateResponse(PKIMessage pkiMessageIn, CertReqMsg[] certReqMsgArr, String hmacSecret, java.security.cert.Certificate issuingCertificate, X500Name issuer, KeyPair keyPair) throws IOException, CRMFException, CMPException, GeneralSecurityException {
        CMPCertificate[] caPubs = new CMPCertificate[]{new CMPCertificate(Certificate.getInstance((Object)this.getDERObject(issuingCertificate.getEncoded())))};
        CertReqMsg certReqMsg = certReqMsgArr[0];
        CertRequest certReq = certReqMsg.getCertReq();
        CertTemplate certTemplate = certReq.getCertTemplate();
        AttributeTypeAndValue[] atavArr = certReqMsg.getRegInfo();
        if (atavArr != null) {
            for (AttributeTypeAndValue atav : atavArr) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("certificate request AttributeTypeAndValue: " + atav.getType().getId() + " -> " + atav.toASN1Primitive());
            }
        }
        X509Certificate issuedCertificate = this.issueCertificate(issuer, keyPair, certTemplate.getSubject(), certTemplate.getPublicKey().getEncoded(), 1, 1);
        CMPCertificate cmpCert = new CMPCertificate(Certificate.getInstance((Object)this.getDERObject(issuedCertificate.getEncoded())));
        CertifiedKeyPair certifiedKeyPair = new CertifiedKeyPair(new CertOrEncCert(cmpCert));
        ASN1OctetString rspInfo = null;
        CertResponse certResponse = new CertResponse(certReq.getCertReqId(), new PKIStatusInfo(PKIStatus.granted), certifiedKeyPair, rspInfo);
        CertResponse[] certResponseArr = new CertResponse[]{certResponse};
        CertRepMessage certRepMessage = new CertRepMessage(caPubs, certResponseArr);
        ProtectedPKIMessageBuilder pbuilder = this.getPKIResponseBuilder(issuer, certTemplate.getSubject(), pkiMessageIn.getHeader());
        PKIBody pkiBody = new PKIBody(3, (ASN1Encodable)certRepMessage);
        pbuilder.setBody(pkiBody);
        X509CertificateHolder certHolder = new X509CertificateHolder(caPubs[0].getX509v3PKCert());
        pbuilder.addCMPCertificate(certHolder);
        MacCalculator macCalculator = this.getMacCalculator(hmacSecret);
        ProtectedPKIMessage message = pbuilder.build(macCalculator);
        PKIMessage pkiMessage = message.toASN1Structure();
        return pkiMessage.getEncoded();
    }

    public X509Certificate issueCertificate(X500Name issuer, KeyPair issuerKeyPair, X500Name subject, byte[] issuerPKByteArr, int validityPeriodType, int validityPeriod) throws NoSuchAlgorithmException, CertificateException, IOException {
        return this.issueCertificate(issuer, issuerKeyPair, subject, SubjectPublicKeyInfo.getInstance((Object)issuerPKByteArr), validityPeriodType, validityPeriod, null, null, PKILevel.END_ENTITY);
    }

    public X509Certificate issueCertificate(X500Name issuer, KeyPair issuerKeyPair, X500Name subject, byte[] issuerPKByteArr, int validityPeriodType, int validityPeriod, PKILevel pkiLevel) throws NoSuchAlgorithmException, CertificateException, IOException {
        return this.issueCertificate(issuer, issuerKeyPair, subject, SubjectPublicKeyInfo.getInstance((Object)issuerPKByteArr), validityPeriodType, validityPeriod, null, null, pkiLevel);
    }

    public X509Certificate issueCertificate(X500Name issuer, KeyPair issuerKeyPair, X500Name subject, SubjectPublicKeyInfo spkInfo, int validityPeriodType, int validityPeriod, PKILevel pkiLevel) throws NoSuchAlgorithmException, CertificateException, IOException {
        return this.issueCertificate(issuer, issuerKeyPair, subject, spkInfo, validityPeriodType, validityPeriod, null, null, pkiLevel);
    }

    public X509Certificate issueCertificate(X500Name issuer, KeyPair issuerKeyPair, X500Name subject, SubjectPublicKeyInfo spkInfo, int validityPeriodType, int validityPeriod, GeneralNames subjectAltNames, List<Map<String, Object>> extensions, PKILevel pkiLevel) throws NoSuchAlgorithmException, CertificateException, IOException {
        boolean hasCN;
        KeyUsage usage;
        Date dateOfIssuing = new Date();
        Calendar expiryCal = Calendar.getInstance();
        expiryCal.add(validityPeriodType, validityPeriod);
        Date dateOfExpiry = expiryCal.getTime();
        BigInteger serialNumber = BigInteger.valueOf(this.secRandom.nextLong()).abs();
        LOGGER.debug("certification request for subject '" + subject + "'");
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serialNumber, dateOfIssuing, dateOfExpiry, subject, spkInfo);
        if (PKILevel.ROOT.equals((Object)pkiLevel) || PKILevel.INTERMEDIATE.equals((Object)pkiLevel)) {
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            usage = new KeyUsage(132);
        } else {
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            usage = new KeyUsage(224);
        }
        certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)usage);
        if (extensions != null && extensions.size() > 0) {
            try {
                Extensions parsedExts = ExtensionsUtils.getExtensionsObjFromMap(extensions);
                certBuilder.addExtension(parsedExts.getExtension(Extension.extendedKeyUsage));
            }
            catch (GeneralSecurityException e) {
                LOGGER.debug("problem parsing requested extensions", (Throwable)e);
                throw new CertificateException(e.getMessage());
            }
        }
        boolean bl = hasCN = subject != null && subject.getRDNs(BCStyle.CN).length > 0;
        if (subjectAltNames != null) {
            certBuilder.addExtension(Extension.subjectAlternativeName, !hasCN, (ASN1Encodable)subjectAltNames);
            LOGGER.debug("added #{} sans, critical : {}", (Object)subjectAltNames.getNames().length, (Object)(!hasCN ? 1 : 0));
        }
        JcaX509ExtensionUtils x509ExtensionUtils = new JcaX509ExtensionUtils();
        certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createSubjectKeyIdentifier(spkInfo));
        if (!PKILevel.ROOT.equals((Object)pkiLevel)) {
            certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createAuthorityKeyIdentifier(issuerKeyPair.getPublic()));
        }
        byte[] certBytes = certBuilder.build((ContentSigner)new JCESigner(issuerKeyPair.getPrivate())).getEncoded();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    public byte[] buildRevocationResponse(PKIMessage pkiMessageIn, String hmacSecret, X500Name issuer) throws IOException, CRMFException, CMPException {
        PKIStatusInfo status = new PKIStatusInfo(PKIStatus.revocationNotification);
        RevRepContent revRepContent = new RevRepContentBuilder().add(status).build();
        X500Name subject = new X500Name("CN=test cert " + System.currentTimeMillis() + ", O=trustable Ltd, C=DE");
        ProtectedPKIMessageBuilder pbuilder = this.getPKIResponseBuilder(issuer, subject, pkiMessageIn.getHeader());
        PKIBody pkiBody = new PKIBody(12, (ASN1Encodable)revRepContent);
        pbuilder.setBody(pkiBody);
        MacCalculator macCalculator = this.getMacCalculator(hmacSecret);
        ProtectedPKIMessage message = pbuilder.build(macCalculator);
        PKIMessage pkiMessage = message.toASN1Structure();
        return pkiMessage.getEncoded();
    }

    public byte[] buildErrorResponse(PKIMessage pkiMessageIn, String hmacSecret, X500Name issuer) throws IOException, CRMFException, CMPException {
        PKIStatusInfo status = new PKIStatusInfo(PKIStatus.rejection);
        ErrorMsgContent emc = new ErrorMsgContent(status);
        X500Name subject = new X500Name("CN=test cert " + System.currentTimeMillis() + ", O=trustable Ltd, C=DE");
        ProtectedPKIMessageBuilder pbuilder = this.getPKIResponseBuilder(issuer, subject, pkiMessageIn.getHeader());
        PKIBody pkiBody = new PKIBody(23, (ASN1Encodable)emc);
        pbuilder.setBody(pkiBody);
        MacCalculator macCalculator = this.getMacCalculator(hmacSecret);
        ProtectedPKIMessage message = pbuilder.build(macCalculator);
        PKIMessage pkiMessage = message.toASN1Structure();
        return pkiMessage.getEncoded();
    }

    public RevRepContent readRevResponse(byte[] responseBytes, String plainSecret) throws IOException, GeneralSecurityException {
        GeneralPKIMessage pkiMessage = this.buildPKIMessage(responseBytes, plainSecret);
        PKIHeader header = pkiMessage.getHeader();
        if (header.getRecipNonce() == null) {
            LOGGER.debug("no recip nonce");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("recip nonce : " + Base64.toBase64String((byte[])header.getRecipNonce().getOctets()));
        }
        if (header.getSenderNonce() == null) {
            LOGGER.debug("no sender nonce");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("sender nonce : " + Base64.toBase64String((byte[])header.getSenderNonce().getOctets()));
        }
        PKIBody body = pkiMessage.getBody();
        int tagno = body.getType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received CMP message with pvno=" + header.getPvno() + ", sender=" + header.getSender().toString() + ", recipient=" + header.getRecipient().toString());
            LOGGER.debug("Body is of type: " + tagno);
            LOGGER.debug("Transaction id: " + header.getTransactionID());
        }
        if (tagno == 23) {
            this.handleCMPError(body);
        } else if (tagno == 12) {
            LOGGER.debug("Rev response received");
            if (body.getContent() != null) {
                RevRepContent revRepContent = RevRepContent.getInstance((Object)body.getContent());
                CertId[] certIdArr = revRepContent.getRevCerts();
                if (certIdArr != null) {
                    for (CertId certId : certIdArr) {
                        LOGGER.info("revoked certId : " + certId.getIssuer() + " / " + certId.getSerialNumber().getValue());
                    }
                } else {
                    LOGGER.debug("no certId ");
                }
                return revRepContent;
            }
        } else {
            throw new GeneralSecurityException("unexpected PKI body type :" + tagno);
        }
        return null;
    }

    public GenMsgContent readGenMsgResponse(byte[] responseBytes, String plainSecret) throws IOException, GeneralSecurityException {
        this.buildPKIMessage(responseBytes, plainSecret);
        ASN1Primitive derObject = this.getDERObject(responseBytes);
        PKIMessage pkiMessage = PKIMessage.getInstance((Object)derObject);
        if (pkiMessage == null) {
            throw new GeneralSecurityException("No CMP message could be parsed from received Der object.");
        }
        PKIHeader header = pkiMessage.getHeader();
        if (LOGGER.isDebugEnabled()) {
            if (header.getRecipNonce() == null) {
                LOGGER.debug("no recip nonce");
            } else {
                LOGGER.debug("recip nonce : " + Base64.toBase64String((byte[])header.getRecipNonce().getOctets()));
            }
            if (header.getSenderNonce() == null) {
                LOGGER.debug("no sender nonce");
            } else {
                LOGGER.debug("sender nonce : " + Base64.toBase64String((byte[])header.getSenderNonce().getOctets()));
            }
        }
        PKIBody body = pkiMessage.getBody();
        int tagno = body.getType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received CMP message with pvno=" + header.getPvno() + ", sender=" + header.getSender().toString() + ", recipient=" + header.getRecipient().toString());
            LOGGER.debug("Body is of type: " + tagno);
            LOGGER.debug("Transaction id: " + header.getTransactionID());
        }
        if (tagno == 23) {
            this.handleCMPError(body);
        } else if (tagno == 22) {
            LOGGER.debug("Rev response received");
            if (body.getContent() != null) {
                GenMsgContent genMsgContent = GenMsgContent.getInstance((Object)body.getContent());
                InfoTypeAndValue[] infoTypeAndValueArr = genMsgContent.toInfoTypeAndValueArray();
                if (infoTypeAndValueArr != null) {
                    for (InfoTypeAndValue infoTypeAndValue : infoTypeAndValueArr) {
                        LOGGER.info("infoTypeAndValue : " + infoTypeAndValue.getInfoType() + " / " + infoTypeAndValue.getInfoValue());
                    }
                } else {
                    LOGGER.debug("no certId ");
                }
                return genMsgContent;
            }
        } else {
            throw new GeneralSecurityException("unexpected PKI body type :" + tagno);
        }
        return null;
    }

    private void handleCMPError(PKIBody body) throws UnrecoverableEntryException {
        ErrorMsgContent errMsgContent = ErrorMsgContent.getInstance((Object)body.getContent());
        PKIFreeText pkiText = errMsgContent.getPKIStatusInfo().getStatusString();
        StringBuilder statusText = new StringBuilder();
        for (int i = 0; i < pkiText.size(); ++i) {
            try {
                statusText.append(" ").append(pkiText.getStringAt(i).getString());
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        String errMsg = "errMsg : #" + errMsgContent.getErrorCode() + " " + errMsgContent.getErrorDetails() + " / " + statusText;
        if ("Can not handle message type '21'.".equals(statusText.toString())) {
            LOGGER.debug(errMsg);
        } else {
            LOGGER.info(errMsg);
        }
        throw new UnrecoverableEntryException(errMsg);
    }

    public PKIMessage buildGeneralMessageRequest(String hmacSecret) throws CRMFException, CMPException {
        InfoTypeAndValue[] itvArr = new InfoTypeAndValue[]{};
        GenMsgContent genMsgContent = new GenMsgContent(itvArr);
        X500Name subjectDN = X500Name.getInstance((Object)new X500Name("CN=User1").toASN1Primitive());
        X500Name issuerDN = X500Name.getInstance((Object)new X500Name("CN=AdminCA1").toASN1Primitive());
        ProtectedPKIMessageBuilder pbuilder = this.getPKIBuilder(issuerDN, subjectDN);
        PKIBody pkiBody = new PKIBody(21, (ASN1Encodable)genMsgContent);
        pbuilder.setBody(pkiBody);
        MacCalculator macCalculator = this.getMacCalculator(hmacSecret);
        ProtectedPKIMessage message = pbuilder.build(macCalculator);
        PKIMessage pkiMessage = message.toASN1Structure();
        LOGGER.debug("sender nonce : " + Base64.toBase64String((byte[])pkiMessage.getHeader().getSenderNonce().getOctets()));
        return pkiMessage;
    }

    public PKIMessage buildCertRequest(long certReqId, X500Name subjectDN, Collection<Extension> certExtList, SubjectPublicKeyInfo keyInfo, String hmacSecret) throws GeneralSecurityException {
        CertificateRequestMessageBuilder msgbuilder = new CertificateRequestMessageBuilder(BigInteger.valueOf(certReqId));
        X500Name issuerDN = X500Name.getInstance((Object)new X500Name("CN=AdminCA1").toASN1Primitive());
        msgbuilder.setSubject(subjectDN);
        msgbuilder.setIssuer(issuerDN);
        try {
            for (Extension ext : certExtList) {
                LOGGER.debug("Csr Extension : " + ext.getExtnId().getId() + " -> " + ext.getExtnValue());
                boolean critical = ext.isCritical();
                msgbuilder.addExtension(ext.getExtnId(), critical, ext.getParsedValue());
            }
            msgbuilder.setPublicKey(keyInfo);
            GeneralName sender = new GeneralName(subjectDN);
            msgbuilder.setAuthInfoSender(sender);
            msgbuilder.setProofOfPossessionRaVerified();
            CertificateRequestMessage msg = msgbuilder.build();
            LOGGER.debug("CertTemplate : " + msg.getCertTemplate());
            ProtectedPKIMessageBuilder pbuilder = this.getPKIBuilder(issuerDN, subjectDN);
            CertReqMessages msgs = new CertReqMessages(msg.toASN1Structure());
            PKIBody pkibody = new PKIBody(0, (ASN1Encodable)msgs);
            pbuilder.setBody(pkibody);
            MacCalculator macCalculator = this.getMacCalculator(hmacSecret);
            ProtectedPKIMessage message = pbuilder.build(macCalculator);
            return message.toASN1Structure();
        }
        catch (IOException | CMPException | CRMFException crmfe) {
            LOGGER.warn("Exception occured processing extensions", crmfe);
            throw new GeneralSecurityException(crmfe.getMessage());
        }
    }

    public byte[] buildRevocationRequest(long certRevId, X500Name issuerDN, X500Name subjectDN, BigInteger serial, CRLReason crlReason, String hmacSecret) throws IOException, CRMFException, CMPException {
        CertTemplateBuilder myCertTemplate = new CertTemplateBuilder();
        myCertTemplate.setIssuer(issuerDN);
        myCertTemplate.setSerialNumber(new ASN1Integer(serial));
        ExtensionsGenerator extgen = new ExtensionsGenerator();
        extgen.addExtension(Extension.reasonCode, false, (ASN1Encodable)crlReason);
        Extensions exts = extgen.generate();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)myCertTemplate.build());
        v.add((ASN1Encodable)exts);
        DERSequence seq = new DERSequence(v);
        RevDetails myRevDetails = RevDetails.getInstance((Object)seq);
        RevReqContent myRevReqContent = new RevReqContent(myRevDetails);
        ProtectedPKIMessageBuilder pbuilder = this.getPKIBuilder(issuerDN, subjectDN);
        PKIBody pkiBody = new PKIBody(11, (ASN1Encodable)myRevReqContent);
        pbuilder.setBody(pkiBody);
        MacCalculator macCalculator = this.getMacCalculator(hmacSecret);
        ProtectedPKIMessage message = pbuilder.build(macCalculator);
        PKIMessage pkiMessage = message.toASN1Structure();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("sender nonce : " + Base64.toBase64String((byte[])pkiMessage.getHeader().getSenderNonce().getOctets()));
        }
        return pkiMessage.getEncoded();
    }

    private GeneralPKIMessage buildPKIMessage(byte[] responseBytes, String plainSecret) throws IOException, GeneralSecurityException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("response Bytes : " + Base64.toBase64String((byte[])responseBytes));
        }
        GeneralPKIMessage generalPKIMessage = new GeneralPKIMessage(responseBytes);
        this.printPKIMessageInfo(generalPKIMessage);
        if (generalPKIMessage.hasProtection()) {
            ProtectedPKIMessage protectedPKIMsg = new ProtectedPKIMessage(generalPKIMessage);
            try {
                if (!protectedPKIMsg.verify((PBEMacCalculatorProvider)this.getMacCalculatorBuilder(), plainSecret.toCharArray())) {
                    throw new GeneralSecurityException("received response message failed verification (by HMAC)!");
                }
                LOGGERContentProtection.debug("received response message verified successfully by HMAC");
            }
            catch (CMPException | CRMFException ex) {
                throw new GeneralSecurityException(ex);
            }
        } else {
            LOGGERContentProtection.info("received response message contains NO content protection!");
        }
        return generalPKIMessage;
    }
}

