/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.ExemptionMechanism;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoPolicy.class);
    private static boolean checked = false;
    private static boolean unlimited = false;

    private CryptoPolicy() {
    }

    public static synchronized boolean isUnlimitedStrengthCryptoAvailable() {
        if (!checked) {
            unlimited = CryptoPolicy.checkCrypto();
            checked = true;
        }
        return unlimited;
    }

    private static boolean checkCrypto() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey skey = keyGen.generateKey();
            byte[] raw = skey.getEncoded();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CFB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal("1234567890123456".getBytes());
            if (encrypted == null) {
                throw new RuntimeException("Encryption of test string failed!");
            }
            ExemptionMechanism em = cipher.getExemptionMechanism();
            if (em != null) {
                LOGGER.info("Cipher uses exemption mechanism " + em.getName());
                return false;
            }
        }
        catch (InvalidKeyException ikex) {
            LOGGER.error("Invalid key size - unlimited strength crypto NOT installed!", (Throwable)ikex);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("Caught unexpected exception: ", (Throwable)ex);
            return false;
        }
        return true;
    }
}

