/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core;

import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentFileSystemWatcher;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentParser;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentProcessingException;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.devtools.classpath.ClassPathFileSystemWatcher;
import org.springframework.boot.devtools.classpath.ClassPathRestartStrategy;
import org.springframework.boot.devtools.filewatch.FileSystemWatcherFactory;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"de.tschuehly.spring.viewcomponent.core"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration;", "", "()V", "LocalDevConfig", "spring-view-component-core"})
public class ViewComponentAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(value={"spring.view-component.local-development"})
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\bH\u0012J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/tschuehly/spring/viewcomponent/core/ViewComponentAutoConfiguration$LocalDevConfig;", "", "classPathRestartStrategy", "Lorg/springframework/boot/devtools/classpath/ClassPathRestartStrategy;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/springframework/boot/devtools/classpath/ClassPathRestartStrategy;Lorg/springframework/context/ApplicationEventPublisher;)V", "gradleKotlinBuildDir", "", "getGradleKotlinBuildDir", "()Ljava/lang/String;", "javaMavenBuildDir", "getJavaMavenBuildDir", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getSrcDir", "Lkotlin/Pair;", "Ljava/io/File;", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "classPath", "viewComponentFileSystemWatcher", "Lorg/springframework/boot/devtools/classpath/ClassPathFileSystemWatcher;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "fileSystemWatcherFactory", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcherFactory;", "restartStrategy", "applicationEventPublisher", "spring-view-component-core"})
    public static class LocalDevConfig {
        @NotNull
        private final ClassPathRestartStrategy classPathRestartStrategy;
        @NotNull
        private final ApplicationEventPublisher eventPublisher;
        @NotNull
        private final String gradleKotlinBuildDir;
        @NotNull
        private final String javaMavenBuildDir;
        private final Logger logger;

        public LocalDevConfig(@NotNull ClassPathRestartStrategy classPathRestartStrategy, @NotNull ApplicationEventPublisher eventPublisher) {
            Intrinsics.checkNotNullParameter((Object)classPathRestartStrategy, (String)"classPathRestartStrategy");
            Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
            this.classPathRestartStrategy = classPathRestartStrategy;
            this.eventPublisher = eventPublisher;
            this.gradleKotlinBuildDir = "build/classes/kotlin/main/";
            this.javaMavenBuildDir = "target/classes/";
            this.logger = LoggerFactory.getLogger(LocalDevConfig.class);
        }

        @NotNull
        public String getGradleKotlinBuildDir() {
            return this.gradleKotlinBuildDir;
        }

        @NotNull
        public String getJavaMavenBuildDir() {
            return this.javaMavenBuildDir;
        }

        @Bean
        @NotNull
        public ClassPathFileSystemWatcher viewComponentFileSystemWatcher(@NotNull ApplicationContext applicationContext, @NotNull FileSystemWatcherFactory fileSystemWatcherFactory, @NotNull ClassPathRestartStrategy restartStrategy, @NotNull ApplicationEventPublisher applicationEventPublisher) {
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            Intrinsics.checkNotNullParameter((Object)fileSystemWatcherFactory, (String)"fileSystemWatcherFactory");
            Intrinsics.checkNotNullParameter((Object)restartStrategy, (String)"restartStrategy");
            Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
            URL[] urls = Restarter.getInstance().getInitialUrls();
            Intrinsics.checkNotNullExpressionValue((Object)urls, (String)"urls");
            ViewComponentFileSystemWatcher watcher = new ViewComponentFileSystemWatcher(applicationContext, fileSystemWatcherFactory, this.classPathRestartStrategy, urls);
            watcher.setStopWatcherOnRestart(true);
            return watcher;
        }

        private Pair<File, ViewComponentParser.BuildType> getSrcDir(String classPath) {
            Object file;
            String srcDir;
            if (StringsKt.endsWith$default((String)classPath, (String)this.getGradleKotlinBuildDir(), (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{this.getGradleKotlinBuildDir()};
                srcDir = StringsKt.split$default((CharSequence)classPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0) + "/src/main/kotlin";
                file = new File(srcDir);
                if (((File)file).exists()) {
                    return TuplesKt.to((Object)file, (Object)((Object)ViewComponentParser.BuildType.GRADLE));
                }
            }
            if (StringsKt.endsWith$default((String)classPath, (String)this.getJavaMavenBuildDir(), (boolean)false, (int)2, null)) {
                file = new String[]{this.getJavaMavenBuildDir()};
                srcDir = StringsKt.split$default((CharSequence)classPath, (String[])file, (boolean)false, (int)0, (int)6, null).get(0) + "src/main/java";
                if (((File)(file = new File(srcDir))).exists()) {
                    return TuplesKt.to((Object)file, (Object)((Object)ViewComponentParser.BuildType.MAVEN));
                }
            }
            throw new ViewComponentProcessingException("No srcDir found", null);
        }
    }
}

