/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.spring.viewcomponent.core.processor;

import de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction;
import de.tschuehly.spring.viewcomponent.core.action.GetViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PatchViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PostViewAction;
import de.tschuehly.spring.viewcomponent.core.action.PutViewAction;
import de.tschuehly.spring.viewcomponent.core.action.ViewActionMethod;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentParser;
import de.tschuehly.spring.viewcomponent.core.processor.ViewComponentProcessingException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SupportedAnnotationTypes(value={"de.tschuehly.spring.viewcomponent.core.component.ViewComponent"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u001e\u001a\u00020\u000b*\u00020\u001fH\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u000b*\u00020\u001fH\u0002J\u0018\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020#0\"*\u00020\u001fH\u0002\u00a8\u0006$"}, d2={"Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "checkIfMethodIsPublic", "", "method", "Ljavax/lang/model/element/Element;", "element", "getSrcDir", "Ljava/nio/file/Path;", "rootDir", "", "messager", "Ljavax/annotation/processing/Messager;", "getSrcHtmlFile", "Ljava/io/File;", "srcDirPath", "viewComponentName", "Ljavax/lang/model/element/Name;", "getViewActionMethods", "", "Lde/tschuehly/spring/viewcomponent/core/action/ViewActionMethod;", "process", "", "annotations", "", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "verifyRenderMethodExists", "getJavaRootDir", "Ljavax/annotation/processing/ProcessingEnvironment;", "getKotlinRootDir", "getRootDirAndBuildType", "Lkotlin/Pair;", "Lde/tschuehly/spring/viewcomponent/core/processor/ViewComponentParser$BuildType;", "spring-view-component-core"})
@SourceDebugExtension(value={"SMAP\nViewComponentProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewComponentProcessor.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n766#2:204\n857#2,2:205\n1549#2:207\n1620#2,3:208\n1855#2,2:211\n766#2:213\n857#2,2:214\n1603#2,9:216\n1855#2:225\n1856#2:227\n1612#2:228\n1#3:226\n*S KotlinDebug\n*F\n+ 1 ViewComponentProcessor.kt\nde/tschuehly/spring/viewcomponent/core/processor/ViewComponentProcessor\n*L\n128#1:204\n128#1:205,2\n130#1:207\n130#1:208,3\n137#1:211,2\n153#1:213\n153#1:214,2\n153#1:216,9\n153#1:225\n153#1:227\n153#1:228\n153#1:226\n*E\n"})
public final class ViewComponentProcessor
extends AbstractProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                Object object;
                String viewComponentName;
                Messager messager = this.processingEnv.getMessager();
                Filer filer = this.processingEnv.getFiler();
                ProcessingEnvironment processingEnvironment = this.processingEnv;
                Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
                Pair<String, ViewComponentParser.BuildType> pair = this.getRootDirAndBuildType(processingEnvironment);
                String rootDir = (String)pair.component1();
                ViewComponentParser.BuildType buildType = (ViewComponentParser.BuildType)((Object)pair.component2());
                String separator = FileSystems.getDefault().getSeparator();
                String string = String.valueOf(element.getEnclosingElement());
                Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"separator");
                String packagePath = StringsKt.replace$default((String)string, (String)".", (String)separator, (boolean)false, (int)4, null);
                Path srcDir = this.getSrcDir(rootDir, messager);
                String[] stringArray = new String[]{packagePath};
                Path viewComponentDir = FileSystems.getDefault().getPath(((Object)srcDir).toString(), stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)viewComponentDir, (String)"viewComponentDir");
                Name name = element.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"element.simpleName");
                Intrinsics.checkNotNullExpressionValue((Object)messager, (String)"messager");
                File srcHtmlFile = this.getSrcHtmlFile(viewComponentDir, name, messager);
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                List<ViewActionMethod> methodList = this.getViewActionMethods(element);
                Intrinsics.checkNotNullExpressionValue((Object)element.getSimpleName().toString().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                this.verifyRenderMethodExists(element, messager);
                ViewComponentParser viewComponentParser = new ViewComponentParser(srcHtmlFile, buildType, methodList, viewComponentName, messager);
                String generatedFile = viewComponentParser.parseFile(false);
                if (generatedFile == null || StringsKt.endsWith$default((String)generatedFile, (String)"kt", (boolean)false, (int)2, null)) continue;
                FileObject fil = filer.getResource(StandardLocation.SOURCE_OUTPUT, StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)generatedFile, (String)"/", null, (int)2, null), (String)"/", (String)".", (boolean)false, (int)4, null), StringsKt.substringAfterLast$default((String)generatedFile, (String)"/", null, (int)2, null));
                Closeable closeable = fil.openReader(true);
                Object object2 = null;
                try {
                    Reader it = (Reader)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    object = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
                String generatedSourceText = object;
                JavaFileObject srcFile = this.processingEnv.getFiler().createSourceFile(StringsKt.replace$default((String)StringsKt.replace$default((String)generatedFile, (String)"/", (String)".", (boolean)false, (int)4, null), (String)".java", (String)"", (boolean)false, (int)4, null), new Element[0]);
                object2 = srcFile.openWriter();
                object = null;
                try {
                    Writer it = (Writer)object2;
                    boolean bl = false;
                    it.write(generatedSourceText);
                    it.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
            }
        }
        return true;
    }

    private final Path getSrcDir(String rootDir, Messager messager) {
        Path mainPath;
        block2: {
            Object object = new String[]{"src", "main"};
            mainPath = FileSystems.getDefault().getPath(rootDir, (String)object);
            Path path = mainPath.resolve("kotlin");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"mainPath.resolve(\"kotlin\")");
            object = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path2 = mainPath.resolve("kotlin");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"mainPath.resolve(\"kotlin\")");
                return path2;
            }
            Path path3 = mainPath.resolve("java");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"mainPath.resolve(\"java\")");
            object = path3;
            linkOptionArray = new LinkOption[]{};
            if (Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path4 = mainPath.resolve("java");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"mainPath.resolve(\"java\")");
                return path4;
            }
            Messager messager2 = messager;
            if (messager2 == null) break block2;
            messager2.printMessage(Diagnostic.Kind.ERROR, "No src main found");
        }
        throw new ViewComponentProcessingException(mainPath + "/src/main/[java,kotlin] not found", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJavaRootDir(ProcessingEnvironment $this$getJavaRootDir) {
        try {
            String fileName = "gen_" + new Date().toInstant().toEpochMilli();
            JavaFileObject sourceFile = $this$getJavaRootDir.getFiler().createSourceFile(fileName, new Element[0]);
            Closeable closeable = sourceFile.openWriter();
            Throwable throwable = null;
            try {
                Writer it = (Writer)closeable;
                boolean bl = false;
                it.close();
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Path it = Paths.get(sourceFile.toUri());
            boolean bl = false;
            return ((Object)it).toString();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to determine source file path!");
            $this$getJavaRootDir.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not get create class file");
            throw new ViewComponentProcessingException("Could not get create class file", null);
        }
    }

    private final String getKotlinRootDir(ProcessingEnvironment $this$getKotlinRootDir) {
        String string = $this$getKotlinRootDir.getOptions().get("kapt.kotlin.generated");
        if (string != null) {
            String filePath = string;
            boolean bl = false;
            return filePath;
        }
        return null;
    }

    private final Pair<String, ViewComponentParser.BuildType> getRootDirAndBuildType(ProcessingEnvironment $this$getRootDirAndBuildType) {
        String filePath;
        String string = this.getKotlinRootDir($this$getRootDirAndBuildType);
        if (string == null) {
            string = this.getJavaRootDir($this$getRootDirAndBuildType);
        }
        if (StringsKt.contains$default((CharSequence)(filePath = string), (CharSequence)"target", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"target"};
            return TuplesKt.to(StringsKt.split$default((CharSequence)filePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0), (Object)((Object)ViewComponentParser.BuildType.MAVEN));
        }
        if (StringsKt.contains$default((CharSequence)filePath, (CharSequence)"build", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"build"};
            return TuplesKt.to(StringsKt.split$default((CharSequence)filePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0), (Object)((Object)ViewComponentParser.BuildType.GRADLE));
        }
        $this$getRootDirAndBuildType.getMessager().printMessage(Diagnostic.Kind.ERROR, "No build or target folder found");
        throw new ViewComponentProcessingException("No build or target folder found", null);
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyRenderMethodExists(Element element, Messager messager) {
        void $this$mapTo$iv$iv;
        Element it;
        Iterable $this$filterTo$iv$iv;
        List<? extends Element> list = element.getEnclosedElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"element.enclosedElements");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Element)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ElementKind.METHOD)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)((Object)it.asType()).toString(), (String)"()", (String)"", (boolean)false, (int)4, null));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final File getSrcHtmlFile(Path srcDirPath, Name viewComponentName, Messager messager) {
        Object[] objectArray = new String[]{".html", ".jte", ".kte", ".th"};
        List fileEndings = CollectionsKt.listOf((Object[])objectArray);
        List testedFiles = new ArrayList();
        Iterable $this$forEach$iv = fileEndings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileEnding = (String)element$iv;
            boolean bl = false;
            Path path = srcDirPath.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath()");
            File file = path.resolve(viewComponentName + fileEnding).toFile();
            if (file.exists()) {
                messager.printMessage(Diagnostic.Kind.NOTE, "Found ViewComponent Template at " + file.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                return file;
            }
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            testedFiles.add(string);
        }
        messager.printMessage(Diagnostic.Kind.ERROR, "Couldn't find a template for " + viewComponentName + " tried at following paths: " + testedFiles);
        throw new ViewComponentProcessingException("Couldn't find a file at " + srcDirPath, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ViewActionMethod> getViewActionMethods(Element element) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List<? extends Element> list = element.getEnclosedElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"element.enclosedElements");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element it = (Element)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ElementKind.METHOD)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ViewActionMethod viewActionMethod;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element method = (Element)element$iv$iv;
            boolean bl2 = false;
            if (method.getAnnotation(GetViewAction.class) != null) {
                GetViewAction get;
                Intrinsics.checkNotNull((Object)method.getAnnotation(GetViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.GetViewAction");
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), get.path(), GetViewAction.class);
            } else if (method.getAnnotation(PostViewAction.class) != null) {
                PostViewAction post;
                Intrinsics.checkNotNull((Object)method.getAnnotation(PostViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PostViewAction");
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), post.path(), PostViewAction.class);
            } else if (method.getAnnotation(PutViewAction.class) != null) {
                PutViewAction put;
                Intrinsics.checkNotNull((Object)method.getAnnotation(PutViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PutViewAction");
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), put.path(), PutViewAction.class);
            } else if (method.getAnnotation(PatchViewAction.class) != null) {
                PatchViewAction patch;
                Intrinsics.checkNotNull((Object)method.getAnnotation(PatchViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.PatchViewAction");
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), patch.path(), PatchViewAction.class);
            } else if (method.getAnnotation(DeleteViewAction.class) != null) {
                DeleteViewAction delete;
                Intrinsics.checkNotNull((Object)method.getAnnotation(DeleteViewAction.class), (String)"null cannot be cast to non-null type de.tschuehly.spring.viewcomponent.core.action.DeleteViewAction");
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                this.checkIfMethodIsPublic(method, element);
                viewActionMethod = new ViewActionMethod(method.getSimpleName().toString(), delete.path(), DeleteViewAction.class);
            } else {
                viewActionMethod = null;
            }
            if (viewActionMethod == null) continue;
            ViewActionMethod it$iv$iv = viewActionMethod;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List methodList = (List)destination$iv$iv;
        return methodList;
    }

    private final void checkIfMethodIsPublic(Element method, Element element) {
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ViewComponentProcessingException("Method: " + element.getSimpleName() + "::" + method.getSimpleName() + " needs to be public", null);
        }
    }
}

