/*
 * Decompiled with CFR 0.152.
 */
package de.tschumacher.sqsservice;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import de.tschumacher.sqsservice.SQSQueue;
import de.tschumacher.sqsservice.SQSUtil;

public class DefaultSQSQueue
implements SQSQueue {
    private static final int VISIBILITY_TIMEOUT = 120;
    private static final int WAIT_TIME_SECONDS = 20;
    private static final int MAX_NUMBER_OF_MESSAGES = 1;
    private final AmazonSQS sqs;
    private final String queueUrl;

    public DefaultSQSQueue(String accessKey, String secretKey, String queueName) {
        BasicAWSCredentials credentials = new BasicAWSCredentials(accessKey, secretKey);
        this.sqs = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withRegion(Regions.EU_CENTRAL_1)).build();
        this.queueUrl = SQSUtil.createIfNotExists(this.sqs, queueName);
    }

    @Override
    public synchronized Message receiveMessage() {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.queueUrl).withWaitTimeSeconds(Integer.valueOf(20)).withMaxNumberOfMessages(Integer.valueOf(1)).withVisibilityTimeout(Integer.valueOf(120));
        ReceiveMessageResult receiveMessage = this.sqs.receiveMessage(receiveMessageRequest);
        if (receiveMessage.getMessages().size() > 0) {
            return (Message)receiveMessage.getMessages().get(0);
        }
        return null;
    }

    @Override
    public void deleteMessage(String receiptHandle) {
        DeleteMessageRequest deleteMessageRequest = new DeleteMessageRequest(this.queueUrl, receiptHandle);
        this.sqs.deleteMessage(deleteMessageRequest);
    }

    @Override
    public void changeMessageVisibility(String receiptHandle, int retrySeconds) {
        ChangeMessageVisibilityRequest changeMessageVisibilityRequest = new ChangeMessageVisibilityRequest(this.queueUrl, receiptHandle, Integer.valueOf(retrySeconds));
        this.sqs.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    @Override
    public void sendMessage(String messageBody) {
        this.sendMessage(messageBody, null);
    }

    @Override
    public void sendMessage(String messageBody, Integer delaySeconds) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(this.queueUrl, messageBody);
        sendMessageRequest.setDelaySeconds(delaySeconds);
        this.sqs.sendMessage(sendMessageRequest);
    }
}

