/*
 * Decompiled with CFR 0.152.
 */
package de.tschumacher.sqsservice;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;

public class SQSUtil {
    public static String getQueueUrl(AmazonSQS sqs, String queueName) {
        GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest(queueName);
        return sqs.getQueueUrl(getQueueUrlRequest).getQueueUrl();
    }

    public static String create(AmazonSQS sqs, String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest().withQueueName(queueName);
        String queueUrl = sqs.createQueue(createQueueRequest).getQueueUrl();
        return queueUrl;
    }

    public static String createIfNotExists(AmazonSQS sqs, String queueName) {
        String queueUrl;
        try {
            queueUrl = SQSUtil.getQueueUrl(sqs, queueName);
        }
        catch (QueueDoesNotExistException e) {
            queueUrl = SQSUtil.create(sqs, queueName);
        }
        return queueUrl;
    }
}

