/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools_mp;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools_mp.asn1.DerTlv;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import okio.Buffer;
import okio.InflaterSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007\u00a8\u0006\u001f"}, d2={"Lde/tsenger/vdstools_mp/DataParser;", "", "<init>", "()V", "decodeMaskedDate", "", "maskedDateBytes", "", "decodeDate", "Lkotlinx/datetime/LocalDate;", "dateBytes", "decodeDateTime", "Lkotlinx/datetime/LocalDateTime;", "dateTimeBytes", "parseDerTLvs", "", "Lde/tsenger/vdstools_mp/asn1/DerTlv;", "rawBytes", "toUnsignedInt", "", "value", "", "decodeC40", "bytes", "toChar", "", "intValue", "decodeBase256", "s", "unzip", "bytesToDecompress", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nDataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataParser.kt\nde/tsenger/vdstools_mp/DataParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nco/touchlab/kermit/Logger\n+ 4 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,192:1\n1#2:193\n82#3,2:194\n84#3:205\n54#4,9:196\n*S KotlinDebug\n*F\n+ 1 DataParser.kt\nde/tsenger/vdstools_mp/DataParser\n*L\n106#1:194,2\n106#1:205\n106#1:196,9\n*E\n"})
public final class DataParser {
    @NotNull
    public static final DataParser INSTANCE = new DataParser();

    private DataParser() {
    }

    @NotNull
    public final String decodeMaskedDate(@NotNull byte[] maskedDateBytes) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)maskedDateBytes, (String)"maskedDateBytes");
        if (!(maskedDateBytes.length == 4)) {
            boolean $i$a$-require-DataParser$decodeMaskedDate$22 = false;
            String $i$a$-require-DataParser$decodeMaskedDate$22 = "expected four bytes for masked date decoding";
            throw new IllegalArgumentException($i$a$-require-DataParser$decodeMaskedDate$22.toString());
        }
        byte mask = maskedDateBytes[0];
        long intval = (long)this.toUnsignedInt(maskedDateBytes[1]) * (long)256 * (long)256 + (long)this.toUnsignedInt(maskedDateBytes[2]) * 256L + (long)this.toUnsignedInt(maskedDateBytes[3]);
        int day = (int)(intval % (long)1000000 / (long)10000);
        int month = (int)(intval / (long)1000000);
        int year = (int)(intval % (long)10000);
        char[] cArray = (StringsKt.padStart((String)String.valueOf(month), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(day), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(year), (int)4, (char)'0')).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] dateCharArray = cArray;
        for (int i = 0; i < 8; ++i) {
            byte unknownBit = (byte)(mask >> 7 - i & 1);
            if (unknownBit != 1) continue;
            dateCharArray[i] = 120;
        }
        String dateString = StringsKt.concatToString((char[])dateCharArray);
        CharSequence charSequence = dateString;
        Regex regex = new Regex("(.{2})(.{2})(.{4})");
        String string = "$3-$1-$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @NotNull
    public final LocalDate decodeDate(@NotNull byte[] dateBytes) {
        Intrinsics.checkNotNullParameter((Object)dateBytes, (String)"dateBytes");
        if (!(dateBytes.length == 3)) {
            boolean bl = false;
            String string = "expected three bytes for date decoding";
            throw new IllegalArgumentException(string.toString());
        }
        long intval = (long)this.toUnsignedInt(dateBytes[0]) * (long)256 * (long)256 + (long)this.toUnsignedInt(dateBytes[1]) * 256L + (long)this.toUnsignedInt(dateBytes[2]);
        int day = (int)(intval % (long)1000000 / (long)10000);
        int month = (int)(intval / (long)1000000);
        int year = (int)(intval % (long)10000);
        return new LocalDate(year, month, day);
    }

    @NotNull
    public final LocalDateTime decodeDateTime(@NotNull byte[] dateTimeBytes) {
        Intrinsics.checkNotNullParameter((Object)dateTimeBytes, (String)"dateTimeBytes");
        if (!(dateTimeBytes.length == 6)) {
            boolean bl = false;
            String string = "Expected six bytes for date decoding";
            throw new IllegalArgumentException(string.toString());
        }
        long dateTimeLong = 0L;
        for (byte by : dateTimeBytes) {
            dateTimeLong = dateTimeLong << 8 | (long)by & 0xFFL;
        }
        String paddedDateString = StringsKt.padStart((String)String.valueOf(dateTimeLong), (int)14, (char)'0');
        String string = paddedDateString.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int month = Integer.parseInt(string);
        String string2 = paddedDateString.substring(2, 4);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int day = Integer.parseInt(string2);
        String string3 = paddedDateString.substring(4, 8);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        int year = Integer.parseInt(string3);
        String string4 = paddedDateString.substring(8, 10);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        int hour = Integer.parseInt(string4);
        String string5 = paddedDateString.substring(10, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        int minute = Integer.parseInt(string5);
        String string6 = paddedDateString.substring(12, 14);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        int second = Integer.parseInt(string6);
        return new LocalDateTime(year, month, day, hour, minute, second, 0, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DerTlv> parseDerTLvs(@NotNull byte[] rawBytes) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
        Buffer dataBuffer = new Buffer().write(rawBytes);
        List derTlvList = new ArrayList();
        while (!dataBuffer.exhausted()) {
            byte tag = dataBuffer.readByte();
            int le = dataBuffer.readByte() & 0xFF;
            if (le == 129) {
                le = dataBuffer.readByte() & 0xFF;
            } else if (le == 130) {
                le = (dataBuffer.readByte() & 0xFF) * 256 + (dataBuffer.readByte() & 0xFF);
            } else if (le == 131) {
                le = (dataBuffer.readByte() & 0xFF) * 4096 + (dataBuffer.readByte() & 0xFF) * 256 + (dataBuffer.readByte() & 0xFF);
            } else if (le > 127) {
                void this_$iv$iv;
                void $this$iv;
                Logger logger = (Logger)Logger.Companion;
                String string = Integer.toString(le, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String string3 = "Can't decode length: " + string2;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$e = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Error;
                boolean $i$f$log = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    void messageString$iv;
                    this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, (String)messageString$iv);
                }
                String string4 = Integer.toString(le, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                String string5 = StringsKt.padStart((String)string4, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                throw new IllegalArgumentException("Can't decode length: " + string5);
            }
            byte[] value = dataBuffer.readByteArray((long)le);
            derTlvList.add(new DerTlv(tag, value));
        }
        return derTlvList;
    }

    private final int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    @NotNull
    public final String decodeC40(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        StringBuilder sb = new StringBuilder();
        int n = bytes.length;
        for (int idx = 0; idx < n; ++idx) {
            int temp;
            if (idx % 2 != 0) continue;
            byte i1 = bytes[idx];
            byte i2 = bytes[idx + 1];
            if (i1 == -2) {
                sb.append((char)(i2 - 1));
                continue;
            }
            int v16 = (this.toUnsignedInt(i1) << 8) + this.toUnsignedInt(i2) - 1;
            int u1 = temp = v16 / 1600;
            v16 -= temp * 1600;
            int u2 = temp = v16 / 40;
            int u3 = v16 - temp * 40;
            if (u1 != 0) {
                sb.append(this.toChar(u1));
            }
            if (u2 != 0) {
                sb.append(this.toChar(u2));
            }
            if (u3 == 0) continue;
            sb.append(this.toChar(u3));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final char toChar(int intValue) {
        char c;
        block1: {
            int n;
            block0: {
                n = intValue;
                if (n != 3) break block0;
                c = ' ';
                break block1;
            }
            c = (4 <= n ? n < 14 : false) ? (char)(intValue + 44) : ((14 <= n ? n < 40 : false) ? (char)(intValue + 51) : (char)63);
        }
        return c;
    }

    @NotNull
    public final byte[] decodeBase256(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        char[] cArray = s.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] ca = cArray;
        byte[] ba = new byte[ca.length];
        int n = ba.length;
        for (int i = 0; i < n; ++i) {
            ba[i] = (byte)ca[i];
        }
        return ba;
    }

    @NotNull
    public final byte[] unzip(@NotNull byte[] bytesToDecompress) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
        Buffer inputBuffer = new Buffer().write(bytesToDecompress);
        InflaterSource inflaterSource = new InflaterSource((Source)inputBuffer, new Inflater());
        Buffer $this$unzip_u24lambda_u243 = buffer = new Buffer();
        boolean bl = false;
        $this$unzip_u24lambda_u243.writeAll((Source)inflaterSource);
        byte[] decompressedBytes = buffer.readByteArray();
        return decompressedBytes;
    }
}

