/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools_mp;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools_mp.vds.DigitalSeal;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.SHA224;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.algorithms.SHA384;
import dev.whyoleg.cryptography.algorithms.SHA512;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.operations.SignatureVerifier;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lde/tsenger/vdstools_mp/Verifier;", "", "digitalSeal", "Lde/tsenger/vdstools_mp/vds/DigitalSeal;", "ecPubKey", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "<init>", "(Lde/tsenger/vdstools_mp/vds/DigitalSeal;Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;)V", "getEcPubKey", "()Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "messageBytes", "", "signatureBytes", "fieldSize", "", "getFieldSize", "()I", "verify", "Lde/tsenger/vdstools_mp/Verifier$Result;", "Result", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Verifier.kt\nde/tsenger/vdstools_mp/Verifier\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,57:1\n67#2,2:58\n69#2:69\n67#2,2:70\n69#2:81\n67#2,2:82\n69#2:93\n67#2,2:94\n69#2:105\n82#2,2:106\n84#2:117\n54#3,9:60\n54#3,9:72\n54#3,9:84\n54#3,9:96\n54#3,9:108\n*S KotlinDebug\n*F\n+ 1 Verifier.kt\nde/tsenger/vdstools_mp/Verifier\n*L\n23#1:58,2\n23#1:69\n24#1:70,2\n24#1:81\n25#1:82,2\n25#1:93\n26#1:94,2\n26#1:105\n40#1:106,2\n40#1:117\n23#1:60,9\n24#1:72,9\n25#1:84,9\n26#1:96,9\n40#1:108,9\n*E\n"})
public final class Verifier {
    @NotNull
    private final ECDSA.PublicKey ecPubKey;
    @NotNull
    private final byte[] messageBytes;
    @NotNull
    private final byte[] signatureBytes;

    public Verifier(@NotNull DigitalSeal digitalSeal, @NotNull ECDSA.PublicKey ecPubKey) {
        BaseLogger this_$iv$iv;
        Logger $this$iv;
        Intrinsics.checkNotNullParameter((Object)digitalSeal, (String)"digitalSeal");
        Intrinsics.checkNotNullParameter((Object)ecPubKey, (String)"ecPubKey");
        this.ecPubKey = ecPubKey;
        this.messageBytes = digitalSeal.getHeaderAndMessageBytes();
        this.signatureBytes = digitalSeal.getSignatureBytes();
        Logger logger = (Logger)Logger.Companion;
        String messageString$iv = "Public Key bytes: 0x" + this.ecPubKey.encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE);
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        $this$iv = (Logger)Logger.Companion;
        messageString$iv = "Field bit length: " + this.getFieldSize();
        throwable$iv = null;
        tag$iv = $this$iv.getTag();
        $i$f$d = false;
        this_$iv$iv = (BaseLogger)$this$iv;
        severity$iv$iv = Severity.Debug;
        $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        $this$iv = (Logger)Logger.Companion;
        messageString$iv = "Message bytes: " + HexExtensionsKt.toHexString$default((byte[])this.messageBytes, null, (int)1, null);
        throwable$iv = null;
        tag$iv = $this$iv.getTag();
        $i$f$d = false;
        this_$iv$iv = (BaseLogger)$this$iv;
        severity$iv$iv = Severity.Debug;
        $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        $this$iv = (Logger)Logger.Companion;
        messageString$iv = "Signature bytes: " + HexExtensionsKt.toHexString$default((byte[])this.signatureBytes, null, (int)1, null);
        throwable$iv = null;
        tag$iv = $this$iv.getTag();
        $i$f$d = false;
        this_$iv$iv = (BaseLogger)$this$iv;
        severity$iv$iv = Severity.Debug;
        $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
    }

    @NotNull
    public final ECDSA.PublicKey getEcPubKey() {
        return this.ecPubKey;
    }

    public final int getFieldSize() {
        return (this.ecPubKey.encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE).length - 1) * 4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result verify() {
        CryptographyAlgorithmId cryptographyAlgorithmId;
        int n = this.getFieldSize();
        boolean bl = Integer.MIN_VALUE <= n ? n < 225 : false;
        if (bl) {
            cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA224.INSTANCE;
        } else {
            boolean bl2 = 225 <= n ? n < 257 : false;
            if (bl2) {
                cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA256.INSTANCE;
            } else {
                boolean bl3 = 257 <= n ? n < 385 : false;
                if (bl3) {
                    cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA384.INSTANCE;
                } else {
                    boolean bl4 = 385 <= n ? n < 513 : false;
                    if (bl4) {
                        cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA512.INSTANCE;
                    } else {
                        void this_$iv$iv;
                        void $this$iv;
                        Logger logger = (Logger)Logger.Companion;
                        String messageString$iv = "Bit length of Field is out of defined value: " + this.getFieldSize();
                        Throwable throwable$iv = null;
                        String tag$iv = $this$iv.getTag();
                        boolean $i$f$e = false;
                        BaseLogger baseLogger = (BaseLogger)$this$iv;
                        Severity severity$iv$iv = Severity.Error;
                        boolean $i$f$log = false;
                        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
                        }
                        return Result.VerifyError;
                    }
                }
            }
        }
        CryptographyAlgorithmId digest = cryptographyAlgorithmId;
        SignatureVerifier ecdsaVerify = this.ecPubKey.signatureVerifier(digest, ECDSA.SignatureFormat.RAW);
        ecdsaVerify.tryVerifySignatureBlocking(this.messageBytes, this.signatureBytes);
        return ecdsaVerify.tryVerifySignatureBlocking(this.messageBytes, this.signatureBytes) ? Result.SignatureValid : Result.SignatureInvalid;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lde/tsenger/vdstools_mp/Verifier$Result;", "", "<init>", "(Ljava/lang/String;I)V", "SignatureValid", "SignatureInvalid", "VerifyError", "vdstools_mp"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result SignatureValid = new Result();
        public static final /* enum */ Result SignatureInvalid = new Result();
        public static final /* enum */ Result VerifyError = new Result();
        private static final /* synthetic */ Result[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        @NotNull
        public static EnumEntries<Result> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultArray = new Result[]{Result.SignatureValid, Result.SignatureInvalid, Result.VerifyError};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

