/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools_mp.asn1;

import de.tsenger.vdstools_mp.asn1.ASN1Encoder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lde/tsenger/vdstools_mp/asn1/DerTlv;", "", "tag", "", "value", "", "<init>", "(B[B)V", "getTag", "()B", "getValue", "()[B", "encoded", "getEncoded", "Companion", "vdstools_mp"})
public final class DerTlv {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte tag;
    @NotNull
    private final byte[] value;

    public DerTlv(byte tag, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.tag = tag;
        this.value = value;
    }

    public final byte getTag() {
        return this.tag;
    }

    @NotNull
    public final byte[] getValue() {
        return this.value;
    }

    @NotNull
    public final byte[] getEncoded() {
        return ASN1Encoder.INSTANCE.getTlv(this.tag, this.value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lde/tsenger/vdstools_mp/asn1/DerTlv$Companion;", "", "<init>", "()V", "fromByteArray", "Lde/tsenger/vdstools_mp/asn1/DerTlv;", "derBytes", "", "vdstools_mp"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DerTlv fromByteArray(@NotNull byte[] derBytes) {
            int n;
            Intrinsics.checkNotNullParameter((Object)derBytes, (String)"derBytes");
            if (derBytes.length == 0) {
                return null;
            }
            byte tag = derBytes[0];
            int lengthByteCount = 1;
            int length = derBytes[1] & 0xFF;
            if (length > 127) {
                int lengthOfLength = length - 128;
                lengthByteCount += lengthOfLength;
                length = 0;
                n = 2 + lengthOfLength;
                for (int i = 2; i < n; ++i) {
                    length = length << 8 | derBytes[i] & 0xFF;
                }
            }
            byte[] byArray = derBytes;
            n = 1 + lengthByteCount;
            int n2 = 1 + lengthByteCount + length;
            byte[] valueBytes = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            return new DerTlv(tag, valueBytes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

