/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools_mp.idb;

import de.tsenger.vdstools_mp.Base32;
import de.tsenger.vdstools_mp.DataEncoder;
import de.tsenger.vdstools_mp.DataParser;
import de.tsenger.vdstools_mp.idb.IdbPayload;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lde/tsenger/vdstools_mp/idb/IcaoBarcode;", "", "barcodeFlag", "", "barcodePayload", "Lde/tsenger/vdstools_mp/idb/IdbPayload;", "<init>", "(CLde/tsenger/vdstools_mp/idb/IdbPayload;)V", "isSigned", "", "isZipped", "(ZZLde/tsenger/vdstools_mp/idb/IdbPayload;)V", "payLoad", "getPayLoad", "()Lde/tsenger/vdstools_mp/idb/IdbPayload;", "setPayLoad", "(Lde/tsenger/vdstools_mp/idb/IdbPayload;)V", "()Z", "encoded", "", "getEncoded", "()Ljava/lang/String;", "Companion", "vdstools_mp"})
public final class IcaoBarcode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private char barcodeFlag;
    @NotNull
    private IdbPayload payLoad;
    @NotNull
    public static final String BARCODE_IDENTIFIER = "NDB1";

    @NotNull
    public final IdbPayload getPayLoad() {
        return this.payLoad;
    }

    public final void setPayLoad(@NotNull IdbPayload idbPayload) {
        Intrinsics.checkNotNullParameter((Object)idbPayload, (String)"<set-?>");
        this.payLoad = idbPayload;
    }

    public IcaoBarcode(char barcodeFlag, @NotNull IdbPayload barcodePayload) {
        Intrinsics.checkNotNullParameter((Object)barcodePayload, (String)"barcodePayload");
        this.barcodeFlag = (char)65;
        this.barcodeFlag = barcodeFlag;
        this.payLoad = barcodePayload;
    }

    public IcaoBarcode(boolean isSigned, boolean isZipped, @NotNull IdbPayload barcodePayload) {
        Intrinsics.checkNotNullParameter((Object)barcodePayload, (String)"barcodePayload");
        this.barcodeFlag = (char)65;
        if (isSigned) {
            this.barcodeFlag = (char)(this.barcodeFlag + '\u0001');
        }
        if (isZipped) {
            this.barcodeFlag = (char)(this.barcodeFlag + 2);
        }
        this.payLoad = barcodePayload;
    }

    public final boolean isSigned() {
        return ((byte)((byte)this.barcodeFlag - 65) & 1) == 1;
    }

    public final boolean isZipped() {
        return ((byte)((byte)this.barcodeFlag - 65) & 2) == 2;
    }

    @NotNull
    public final String getEncoded() {
        StringBuilder strBuffer = new StringBuilder(BARCODE_IDENTIFIER);
        strBuffer.append(this.barcodeFlag);
        byte[] payloadBytes = this.isZipped() ? DataEncoder.INSTANCE.zip(this.payLoad.getEncoded()) : this.payLoad.getEncoded();
        String base32EncodedPayload = StringsKt.replace$default((String)Base32.INSTANCE.encode(payloadBytes), (String)"=", (String)"", (boolean)false, (int)4, null);
        strBuffer.append(base32EncodedPayload);
        String string = strBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/tsenger/vdstools_mp/idb/IcaoBarcode$Companion;", "", "<init>", "()V", "BARCODE_IDENTIFIER", "", "fromString", "Lkotlin/Result;", "Lde/tsenger/vdstools_mp/idb/IcaoBarcode;", "barcodeString", "fromString-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "vdstools_mp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object fromString-IoAF18A(@NotNull String barcodeString) {
            Intrinsics.checkNotNullParameter((Object)barcodeString, (String)"barcodeString");
            StringBuilder strBuffer = new StringBuilder(barcodeString);
            String string = strBuffer.substring(0, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            if (!new Regex(IcaoBarcode.BARCODE_IDENTIFIER).matches(charSequence)) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Didn't found an ICAO Barcode in the given String: " + barcodeString)));
            }
            char barcodeFlag = strBuffer.charAt(4);
            boolean isSigned = ((byte)((byte)barcodeFlag - 65) & 1) == 1;
            boolean isZipped = ((byte)((byte)barcodeFlag - 65) & 2) == 2;
            StringBuilder base32EncodedPayload = new StringBuilder(strBuffer.substring(5));
            while (base32EncodedPayload.length() % 8 != 0) {
                base32EncodedPayload.append("=");
            }
            String string2 = base32EncodedPayload.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            byte[] payloadBytes = Base32.INSTANCE.decode(string2);
            if (isZipped) {
                payloadBytes = DataParser.INSTANCE.unzip(payloadBytes);
            }
            IdbPayload payload = IdbPayload.Companion.fromByteArray(payloadBytes, isSigned);
            return Result.constructor-impl((Object)new IcaoBarcode(barcodeFlag, payload));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

