/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools_mp.idb;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools_mp.DataParser;
import de.tsenger.vdstools_mp.asn1.DerTlv;
import de.tsenger.vdstools_mp.idb.IdbHeader;
import de.tsenger.vdstools_mp.idb.IdbMessageGroup;
import de.tsenger.vdstools_mp.idb.IdbSignature;
import de.tsenger.vdstools_mp.idb.IdbSignerCertificate;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lde/tsenger/vdstools_mp/idb/IdbPayload;", "", "idbHeader", "Lde/tsenger/vdstools_mp/idb/IdbHeader;", "idbMessageGroup", "Lde/tsenger/vdstools_mp/idb/IdbMessageGroup;", "idbSignerCertificate", "Lde/tsenger/vdstools_mp/idb/IdbSignerCertificate;", "idbSignature", "Lde/tsenger/vdstools_mp/idb/IdbSignature;", "<init>", "(Lde/tsenger/vdstools_mp/idb/IdbHeader;Lde/tsenger/vdstools_mp/idb/IdbMessageGroup;Lde/tsenger/vdstools_mp/idb/IdbSignerCertificate;Lde/tsenger/vdstools_mp/idb/IdbSignature;)V", "getIdbHeader", "()Lde/tsenger/vdstools_mp/idb/IdbHeader;", "getIdbMessageGroup", "()Lde/tsenger/vdstools_mp/idb/IdbMessageGroup;", "getIdbSignerCertificate", "()Lde/tsenger/vdstools_mp/idb/IdbSignerCertificate;", "getIdbSignature", "()Lde/tsenger/vdstools_mp/idb/IdbSignature;", "encoded", "", "getEncoded", "()[B", "Companion", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nIdbPayload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbPayload.kt\nde/tsenger/vdstools_mp/idb/IdbPayload\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,61:1\n82#2,2:62\n84#2:73\n54#3,9:64\n*S KotlinDebug\n*F\n+ 1 IdbPayload.kt\nde/tsenger/vdstools_mp/idb/IdbPayload\n*L\n24#1:62,2\n24#1:73\n24#1:64,9\n*E\n"})
public final class IdbPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdbHeader idbHeader;
    @NotNull
    private final IdbMessageGroup idbMessageGroup;
    @Nullable
    private final IdbSignerCertificate idbSignerCertificate;
    @Nullable
    private final IdbSignature idbSignature;

    public IdbPayload(@NotNull IdbHeader idbHeader, @NotNull IdbMessageGroup idbMessageGroup, @Nullable IdbSignerCertificate idbSignerCertificate, @Nullable IdbSignature idbSignature) {
        Intrinsics.checkNotNullParameter((Object)idbHeader, (String)"idbHeader");
        Intrinsics.checkNotNullParameter((Object)idbMessageGroup, (String)"idbMessageGroup");
        this.idbHeader = idbHeader;
        this.idbMessageGroup = idbMessageGroup;
        this.idbSignerCertificate = idbSignerCertificate;
        this.idbSignature = idbSignature;
    }

    @NotNull
    public final IdbHeader getIdbHeader() {
        return this.idbHeader;
    }

    @NotNull
    public final IdbMessageGroup getIdbMessageGroup() {
        return this.idbMessageGroup;
    }

    @Nullable
    public final IdbSignerCertificate getIdbSignerCertificate() {
        return this.idbSignerCertificate;
    }

    @Nullable
    public final IdbSignature getIdbSignature() {
        return this.idbSignature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getEncoded() {
        Buffer buffer = new Buffer();
        buffer.write(this.idbHeader.getEncoded());
        buffer.write(this.idbMessageGroup.getEncoded());
        if (this.idbSignerCertificate != null) {
            buffer.write(this.idbMessageGroup.getEncoded());
        }
        if (this.idbSignature != null) {
            buffer.write(this.idbSignature.getEncoded());
        } else if (this.idbHeader.getSignatureAlgorithm() != null) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = (Logger)Logger.Companion;
            String messageString$iv = "Missing Signature Field! This field should be present if a signature algorithm has been specified in the header.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
        }
        return buffer.readByteArray();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools_mp/idb/IdbPayload$Companion;", "", "<init>", "()V", "fromByteArray", "Lde/tsenger/vdstools_mp/idb/IdbPayload;", "rawBytes", "", "isSigned", "", "vdstools_mp"})
    @SourceDebugExtension(value={"SMAP\nIdbPayload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbPayload.kt\nde/tsenger/vdstools_mp/idb/IdbPayload$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdbPayload fromByteArray(@NotNull byte[] rawBytes, boolean isSigned) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
            IdbHeader idbHeader = null;
            IdbMessageGroup idbMessageGroup = null;
            IdbSignerCertificate idbSignerCertificate = null;
            IdbSignature idbSignature = null;
            int offset = 0;
            int headerSize = isSigned ? 12 : 2;
            byte[] byArray = ArraysKt.sliceArray((byte[])rawBytes, (IntRange)RangesKt.until((int)0, (int)headerSize));
            Object object = byArray;
            IdbHeader.Companion companion = IdbHeader.Companion;
            boolean bl = false;
            idbHeader = companion.fromByteArray(byArray);
            List<DerTlv> derTlvList = DataParser.INSTANCE.parseDerTLvs(ArraysKt.sliceArray((byte[])rawBytes, (IntRange)RangesKt.until((int)(offset += headerSize), (int)rawBytes.length)));
            object = derTlvList.iterator();
            while (object.hasNext()) {
                DerTlv derTlv = (DerTlv)object.next();
                byte by = derTlv.getTag();
                if (by == 97) {
                    idbMessageGroup = IdbMessageGroup.Companion.fromByteArray(derTlv.getEncoded());
                    continue;
                }
                if (by == 126) {
                    idbSignerCertificate = IdbSignerCertificate.Companion.fromByteArray(derTlv.getEncoded());
                    continue;
                }
                if (by == 127) {
                    idbSignature = IdbSignature.Companion.fromByteArray(derTlv.getEncoded());
                    continue;
                }
                String string = Integer.toString(derTlv.getTag(), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                throw new IllegalArgumentException("Found unknown tag " + string2 + " in IdbPayload!");
            }
            if (idbMessageGroup == null) {
                throw new IllegalArgumentException("Didn't found a Message!");
            }
            return new IdbPayload(idbHeader, idbMessageGroup, idbSignerCertificate, idbSignature);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

