/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools_mp.vds;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools_mp.DataEncoder;
import de.tsenger.vdstools_mp.DataParser;
import de.tsenger.vdstools_mp.Signer;
import de.tsenger.vdstools_mp.asn1.DerTlv;
import de.tsenger.vdstools_mp.vds.Feature;
import de.tsenger.vdstools_mp.vds.VdsHeader;
import de.tsenger.vdstools_mp.vds.VdsMessage;
import de.tsenger.vdstools_mp.vds.VdsSignature;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlinx.datetime.LocalDate;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u00017B#\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u00104\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u00020\u000eJ\"\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0011\u0010+\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010(R\u0011\u0010-\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0010R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u000201008F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00068"}, d2={"Lde/tsenger/vdstools_mp/vds/DigitalSeal;", "", "vdsHeader", "Lde/tsenger/vdstools_mp/vds/VdsHeader;", "vdsMessage", "Lde/tsenger/vdstools_mp/vds/VdsMessage;", "vdsSignature", "Lde/tsenger/vdstools_mp/vds/VdsSignature;", "<init>", "(Lde/tsenger/vdstools_mp/vds/VdsHeader;Lde/tsenger/vdstools_mp/vds/VdsMessage;Lde/tsenger/vdstools_mp/vds/VdsSignature;)V", "signer", "Lde/tsenger/vdstools_mp/Signer;", "(Lde/tsenger/vdstools_mp/vds/VdsHeader;Lde/tsenger/vdstools_mp/vds/VdsMessage;Lde/tsenger/vdstools_mp/Signer;)V", "vdsType", "", "getVdsType", "()Ljava/lang/String;", "issuingCountry", "getIssuingCountry", "signerCertRef", "getSignerCertRef", "signerIdentifier", "getSignerIdentifier", "certificateReference", "getCertificateReference", "issuingDate", "Lkotlinx/datetime/LocalDate;", "getIssuingDate", "()Lkotlinx/datetime/LocalDate;", "sigDate", "getSigDate", "docFeatureRef", "", "getDocFeatureRef", "()B", "docTypeCat", "getDocTypeCat", "headerAndMessageBytes", "", "getHeaderAndMessageBytes", "()[B", "encoded", "getEncoded", "signatureBytes", "getSignatureBytes", "rawString", "getRawString", "featureList", "", "Lde/tsenger/vdstools_mp/vds/Feature;", "getFeatureList", "()Ljava/util/List;", "getFeature", "feature", "createVdsSignature", "Companion", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nDigitalSeal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools_mp/vds/DigitalSeal\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,134:1\n82#2,2:135\n84#2:146\n54#3,9:137\n*S KotlinDebug\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools_mp/vds/DigitalSeal\n*L\n82#1:135,2\n82#1:146\n82#1:137,9\n*E\n"})
public final class DigitalSeal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String vdsType;
    @NotNull
    private final VdsHeader vdsHeader;
    @NotNull
    private final VdsMessage vdsMessage;
    @Nullable
    private final VdsSignature vdsSignature;

    @NotNull
    public final String getVdsType() {
        return this.vdsType;
    }

    private DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = vdsSignature;
        this.vdsType = vdsHeader.getVdsType();
    }

    public DigitalSeal(@NotNull VdsHeader vdsHeader, @NotNull VdsMessage vdsMessage, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)vdsHeader, (String)"vdsHeader");
        Intrinsics.checkNotNullParameter((Object)vdsMessage, (String)"vdsMessage");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = this.createVdsSignature(vdsHeader, vdsMessage, signer);
        this.vdsType = vdsHeader.getVdsType();
    }

    @NotNull
    public final String getIssuingCountry() {
        return this.vdsHeader.getIssuingCountry();
    }

    @NotNull
    public final String getSignerCertRef() {
        return this.vdsHeader.getSignerCertRef();
    }

    @Nullable
    public final String getSignerIdentifier() {
        return this.vdsHeader.getSignerIdentifier();
    }

    @Nullable
    public final String getCertificateReference() {
        return this.vdsHeader.getCertificateReference();
    }

    @Nullable
    public final LocalDate getIssuingDate() {
        return this.vdsHeader.getIssuingDate();
    }

    @Nullable
    public final LocalDate getSigDate() {
        return this.vdsHeader.getSigDate();
    }

    public final byte getDocFeatureRef() {
        return this.vdsHeader.getDocFeatureRef();
    }

    public final byte getDocTypeCat() {
        return this.vdsHeader.getDocTypeCat();
    }

    @NotNull
    public final byte[] getHeaderAndMessageBytes() {
        return ArraysKt.plus((byte[])this.vdsHeader.getEncoded(), (byte[])this.vdsMessage.getEncoded());
    }

    @NotNull
    public final byte[] getEncoded() {
        Object object;
        byte[] byArray;
        block3: {
            block2: {
                byArray = ArraysKt.plus((byte[])this.vdsHeader.getEncoded(), (byte[])this.vdsMessage.getEncoded());
                object = this.vdsSignature;
                if (object == null) break block2;
                byte[] byArray2 = ((VdsSignature)object).getEncoded();
                object = byArray2;
                if (byArray2 != null) break block3;
            }
            object = new byte[0];
        }
        return ArraysKt.plus((byte[])byArray, (byte[])object);
    }

    @NotNull
    public final byte[] getSignatureBytes() {
        VdsSignature vdsSignature = this.vdsSignature;
        Intrinsics.checkNotNull((Object)vdsSignature);
        return vdsSignature.getPlainSignatureBytes();
    }

    @NotNull
    public final String getRawString() {
        return DataEncoder.INSTANCE.encodeBase256(this.getEncoded());
    }

    @NotNull
    public final List<Feature> getFeatureList() {
        return this.vdsMessage.getFeatureList();
    }

    @Nullable
    public final Feature getFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.vdsMessage.getFeature(feature);
    }

    /*
     * WARNING - void declaration
     */
    private final VdsSignature createVdsSignature(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        byte[] headerMessage = ArraysKt.plus((byte[])vdsHeader.getEncoded(), (byte[])vdsMessage.getEncoded());
        try {
            byte[] signatureBytes = signer.sign(headerMessage);
            return new VdsSignature(signatureBytes);
        }
        catch (Exception e) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = (Logger)Logger.Companion;
            String messageString$iv = "Signature creation failed: " + e.getMessage();
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            return null;
        }
    }

    public /* synthetic */ DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature, DefaultConstructorMarker $constructor_marker) {
        this(vdsHeader, vdsMessage, vdsSignature);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lde/tsenger/vdstools_mp/vds/DigitalSeal$Companion;", "", "<init>", "()V", "fromRawString", "Lde/tsenger/vdstools_mp/vds/DigitalSeal;", "rawString", "", "fromByteArray", "rawBytes", "", "parseVdsSeal", "vdstools_mp"})
    @SourceDebugExtension(value={"SMAP\nDigitalSeal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools_mp/vds/DigitalSeal$Companion\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,134:1\n82#2,2:135\n84#2:146\n82#2,2:147\n84#2:158\n62#2,2:159\n64#2:170\n54#3,9:137\n54#3,9:149\n54#3,9:161\n*S KotlinDebug\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools_mp/vds/DigitalSeal$Companion\n*L\n94#1:135,2\n94#1:146\n104#1:147,2\n104#1:158\n112#1:159,2\n112#1:170\n94#1:137,9\n104#1:149,9\n112#1:161,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DigitalSeal fromRawString(@NotNull String rawString) {
            DigitalSeal seal;
            block2: {
                Intrinsics.checkNotNullParameter((Object)rawString, (String)"rawString");
                seal = null;
                try {
                    seal = this.parseVdsSeal(DataParser.INSTANCE.decodeBase256(rawString));
                }
                catch (Exception e) {
                    void this_$iv$iv;
                    void $this$iv;
                    Logger logger = (Logger)Logger.Companion;
                    String messageString$iv = String.valueOf(e.getMessage());
                    Throwable throwable$iv = null;
                    String tag$iv = $this$iv.getTag();
                    boolean $i$f$e = false;
                    BaseLogger baseLogger = (BaseLogger)$this$iv;
                    Severity severity$iv$iv = Severity.Error;
                    boolean $i$f$log = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) break block2;
                    this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
                }
            }
            return seal;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DigitalSeal fromByteArray(@NotNull byte[] rawBytes) {
            DigitalSeal seal;
            block2: {
                Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
                seal = null;
                try {
                    seal = this.parseVdsSeal(rawBytes);
                }
                catch (Exception e) {
                    void this_$iv$iv;
                    void $this$iv;
                    Logger logger = (Logger)Logger.Companion;
                    String messageString$iv = String.valueOf(e.getMessage());
                    Throwable throwable$iv = null;
                    String tag$iv = $this$iv.getTag();
                    boolean $i$f$e = false;
                    BaseLogger baseLogger = (BaseLogger)$this$iv;
                    Severity severity$iv$iv = Severity.Error;
                    boolean $i$f$log = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) break block2;
                    this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
                }
            }
            return seal;
        }

        /*
         * WARNING - void declaration
         */
        private final DigitalSeal parseVdsSeal(byte[] rawBytes) {
            void this_$iv$iv;
            void $this$iv;
            Buffer rawDataBuffer = new Buffer().write(rawBytes);
            Logger logger = (Logger)Logger.Companion;
            String messageString$iv = "rawData: " + HexExtensionsKt.toHexString$default((byte[])rawBytes, null, (int)1, null);
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$v = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Verbose;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            VdsHeader vdsHeader = VdsHeader.Companion.fromBuffer(rawDataBuffer);
            VdsSignature vdsSignature = null;
            List<DerTlv> derTlvList = DataParser.INSTANCE.parseDerTLvs(rawDataBuffer.readByteArray());
            List featureList = new ArrayList(derTlvList.size() - 1);
            for (DerTlv derTlv : derTlvList) {
                if (derTlv.getTag() == -1) {
                    vdsSignature = VdsSignature.Companion.fromByteArray(derTlv.getEncoded());
                    continue;
                }
                featureList.add(derTlv);
            }
            VdsMessage vdsMessage = new VdsMessage(vdsHeader.getVdsType(), featureList);
            return new DigitalSeal(vdsHeader, vdsMessage, vdsSignature, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

