/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.idb.IdbSignatureAlgorithm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B)\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nB5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\b\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lde/tsenger/vdstools/idb/IdbHeader;", "", "countryIdentifier", "", "signatureAlgorithm", "", "certificateReference", "signatureCreationDate", "<init>", "([BB[B[B)V", "([B)V", "", "Lde/tsenger/vdstools/idb/IdbSignatureAlgorithm;", "(Ljava/lang/String;Lde/tsenger/vdstools/idb/IdbSignatureAlgorithm;[BLjava/lang/String;)V", "value", "getCertificateReference", "()[B", "getCountryIdentifier", "getSignatureAlgorithm", "getSignatureCreationDate", "encoded", "getEncoded", "Companion", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nIdbHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbHeader.kt\nde/tsenger/vdstools/idb/IdbHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class IdbHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] countryIdentifier;
    private byte signatureAlgorithm;
    @Nullable
    private byte[] certificateReference;
    @Nullable
    private byte[] signatureCreationDate;

    @Nullable
    public final byte[] getCertificateReference() {
        return this.certificateReference;
    }

    private IdbHeader(byte[] countryIdentifier, byte signatureAlgorithm, byte[] certificateReference, byte[] signatureCreationDate) {
        this.countryIdentifier = countryIdentifier;
        this.signatureAlgorithm = signatureAlgorithm;
        this.certificateReference = certificateReference;
        this.signatureCreationDate = signatureCreationDate;
    }

    private IdbHeader(byte[] countryIdentifier) {
        this.countryIdentifier = countryIdentifier;
    }

    public IdbHeader(@NotNull String countryIdentifier, @Nullable IdbSignatureAlgorithm signatureAlgorithm, @Nullable byte[] certificateReference, @Nullable String signatureCreationDate) {
        Intrinsics.checkNotNullParameter((Object)countryIdentifier, (String)"countryIdentifier");
        if (!(countryIdentifier.length() == 3)) {
            boolean bl = false;
            String string = "countryIdentifier must be a 3-letter String";
            throw new IllegalArgumentException(string.toString());
        }
        this.countryIdentifier = DataEncoder.INSTANCE.encodeC40(countryIdentifier);
        if (signatureAlgorithm != null) {
            this.signatureAlgorithm = signatureAlgorithm.getValue();
        }
        this.certificateReference = certificateReference;
        if (signatureCreationDate != null) {
            this.signatureCreationDate = DataEncoder.INSTANCE.encodeMaskedDate(signatureCreationDate);
        }
    }

    public /* synthetic */ IdbHeader(String string, IdbSignatureAlgorithm idbSignatureAlgorithm, byte[] byArray, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            idbSignatureAlgorithm = null;
        }
        if ((n & 4) != 0) {
            byArray = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, idbSignatureAlgorithm, byArray, string2);
    }

    @NotNull
    public final String getCountryIdentifier() {
        CharSequence charSequence = DataParser.INSTANCE.decodeC40(this.countryIdentifier);
        Regex regex = new Regex(" ");
        String string = "<";
        return regex.replace(charSequence, string);
    }

    @Nullable
    public final IdbSignatureAlgorithm getSignatureAlgorithm() {
        if (this.signatureAlgorithm == 0) {
            return null;
        }
        return IdbSignatureAlgorithm.Companion.valueOf(this.signatureAlgorithm);
    }

    @Nullable
    public final String getSignatureCreationDate() {
        if (this.signatureCreationDate == null) {
            return null;
        }
        Intrinsics.checkNotNull((Object)this.signatureCreationDate);
        return DataParser.INSTANCE.decodeMaskedDate(this.signatureCreationDate);
    }

    @NotNull
    public final byte[] getEncoded() {
        Buffer buffer;
        block2: {
            byte[] it;
            buffer = new Buffer();
            buffer.write(this.countryIdentifier);
            if (this.signatureAlgorithm != 0) {
                buffer.writeByte((int)this.signatureAlgorithm);
            }
            if (this.certificateReference != null) {
                it = this.certificateReference;
                boolean bl = false;
                buffer.write(it);
            }
            if (this.signatureCreationDate == null) break block2;
            it = this.signatureCreationDate;
            boolean bl = false;
            buffer.write(it);
        }
        return buffer.readByteArray();
    }

    public /* synthetic */ IdbHeader(byte[] countryIdentifier, DefaultConstructorMarker $constructor_marker) {
        this(countryIdentifier);
    }

    public /* synthetic */ IdbHeader(byte[] countryIdentifier, byte signatureAlgorithm, byte[] certificateReference, byte[] signatureCreationDate, DefaultConstructorMarker $constructor_marker) {
        this(countryIdentifier, signatureAlgorithm, certificateReference, signatureCreationDate);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lde/tsenger/vdstools/idb/IdbHeader$Companion;", "", "<init>", "()V", "fromByteArray", "Lde/tsenger/vdstools/idb/IdbHeader;", "rawBytes", "", "vdstools_mp"})
    @SourceDebugExtension(value={"SMAP\nIdbHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbHeader.kt\nde/tsenger/vdstools/idb/IdbHeader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdbHeader fromByteArray(@NotNull byte[] rawBytes) {
            Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
            if (!(rawBytes.length <= 12 && rawBytes.length >= 2)) {
                boolean $i$a$-require-IdbHeader$Companion$fromByteArray$22 = false;
                String $i$a$-require-IdbHeader$Companion$fromByteArray$22 = "Header must have a length between 2 and 12 bytes";
                throw new IllegalArgumentException($i$a$-require-IdbHeader$Companion$fromByteArray$22.toString());
            }
            Buffer rawData = new Buffer().write(rawBytes);
            byte[] countryIdentifier = rawData.readByteArray(2L);
            if (rawData.exhausted()) {
                return new IdbHeader(countryIdentifier, null);
            }
            byte signatureAlgorithm = rawData.readByte();
            byte[] certificateReference = rawData.readByteArray(5L);
            byte[] signatureCreationDate = rawData.readByteArray(4L);
            return new IdbHeader(countryIdentifier, signatureAlgorithm, certificateReference, signatureCreationDate, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

