/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.FeatureConverter;
import de.tsenger.vdstools.ReadTextResource_jvmKt;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.Feature;
import de.tsenger.vdstools.vds.FeatureCoding;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.SHA1;
import dev.whyoleg.cryptography.operations.Hasher;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Locale;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import okio.Buffer;
import okio.DeflaterSink;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u0016J\u0015\u0010*\u001a\u0004\u0018\u00010\u00162\u0006\u0010%\u001a\u00020\t\u00a2\u0006\u0002\u0010+J)\u0010,\u001a\u00020'\"\u0004\b\u0000\u0010-2\u0006\u0010%\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u0010\u0010\u001a\u0002H-\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/tsenger/vdstools/DataEncoder;", "", "<init>", "()V", "featureEncoder", "Lde/tsenger/vdstools/FeatureConverter;", "encodeDate", "", "dateString", "", "localDate", "Lkotlinx/datetime/LocalDate;", "encodeDateTime", "localDatetime", "Lkotlinx/datetime/LocalDateTime;", "numberToByteArray", "value", "", "encodeMaskedDate", "encodeC40", "string", "getC40Value", "", "c", "", "toUnsignedInt", "", "encodeBase256", "ba", "zip", "bytesToCompress", "setFeatureEncoder", "", "buildCertificateReference", "certificateBytes", "encodeDerTlv", "Lde/tsenger/vdstools/vds/Feature;", "vdsType", "derTlv", "Lde/tsenger/vdstools/asn1/DerTlv;", "getVdsType", "documentRef", "getDocumentRef", "(Ljava/lang/String;)Ljava/lang/Integer;", "encodeFeature", "T", "feature", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/asn1/DerTlv;", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nDataEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataEncoder.kt\nde/tsenger/vdstools/DataEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nco/touchlab/kermit/Logger\n+ 4 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,296:1\n1#2:297\n67#3,2:298\n69#3:309\n82#3,2:310\n84#3:321\n54#4,9:300\n54#4,9:312\n*S KotlinDebug\n*F\n+ 1 DataEncoder.kt\nde/tsenger/vdstools/DataEncoder\n*L\n251#1:298,2\n251#1:309\n31#1:310,2\n31#1:321\n251#1:300,9\n31#1:312,9\n*E\n"})
public final class DataEncoder {
    @NotNull
    public static final DataEncoder INSTANCE = new DataEncoder();
    private static FeatureConverter featureEncoder;

    private DataEncoder() {
    }

    @NotNull
    public final byte[] encodeDate(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        LocalDate dt = LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)dateString, null, (int)2, null);
        return this.encodeDate(dt);
    }

    @NotNull
    public final byte[] encodeDate(@Nullable LocalDate localDate) {
        if (localDate == null) {
            return new byte[3];
        }
        String formattedDate = StringsKt.padStart((String)String.valueOf(localDate.getMonthNumber()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDate.getDayOfMonth()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDate.getYear()), (int)4, (char)'0');
        int dateInt = Integer.parseInt(formattedDate);
        return this.numberToByteArray(dateInt);
    }

    @NotNull
    public final byte[] encodeDateTime(@NotNull LocalDateTime localDatetime) {
        Intrinsics.checkNotNullParameter((Object)localDatetime, (String)"localDatetime");
        String formattedDateTime = StringsKt.padStart((String)String.valueOf(localDatetime.getMonthNumber()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getDayOfMonth()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getYear()), (int)4, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getHour()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getMinute()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getSecond()), (int)2, (char)'0');
        long dateInt = Long.parseLong(formattedDateTime);
        return this.numberToByteArray(dateInt);
    }

    private final byte[] numberToByteArray(Number value) {
        byte[] byArray;
        Number number = value;
        if (number instanceof Long) {
            int n = 0;
            byte[] byArray2 = new byte[8];
            while (n < 8) {
                int n2 = n++;
                byArray2[n2] = (byte)(value.longValue() >> 8 * (7 - n2) & 0xFFL);
            }
            byte[] byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])byArray2, (int)6));
            n = 0;
            int n3 = 6 - byteArray.length;
            byte[] byArray3 = new byte[n3];
            while (n < n3) {
                int n4 = n++;
                byArray3[n4] = 0;
            }
            byArray = ArraysKt.plus((byte[])byArray3, (byte[])byteArray);
        } else if (number instanceof Integer) {
            int n = 0;
            byte[] byArray4 = new byte[4];
            while (n < 4) {
                int n5 = n++;
                byArray4[n5] = (byte)(value.intValue() >> 8 * (3 - n5) & 0xFF);
            }
            byte[] byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])byArray4, (int)3));
            n = 0;
            int n6 = 3 - byteArray.length;
            byte[] byArray5 = new byte[n6];
            while (n < n6) {
                int n7 = n++;
                byArray5[n7] = 0;
            }
            byArray = ArraysKt.plus((byte[])byArray5, (byte[])byteArray);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(value.getClass()));
        }
        return byArray;
    }

    @NotNull
    public final byte[] encodeMaskedDate(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        CharSequence charSequence = dateString;
        if (!new Regex("(.{4})-(.{2})-(.{2})").matches(charSequence)) {
            boolean $i$a$-require-DataEncoder$encodeMaskedDate$22 = false;
            String $i$a$-require-DataEncoder$encodeMaskedDate$22 = "Date string must be formated as yyyy-MM-dd.";
            throw new IllegalArgumentException($i$a$-require-DataEncoder$encodeMaskedDate$22.toString());
        }
        CharSequence $i$a$-require-DataEncoder$encodeMaskedDate$22 = dateString;
        Object object = new Regex("(.{4})-(.{2})-(.{2})");
        String string = "$2$3$1";
        String string2 = object.replace($i$a$-require-DataEncoder$encodeMaskedDate$22, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String formattedDate = string2;
        object = formattedDate;
        string = new Regex("x");
        String string3 = "0";
        int dateInt = Integer.parseInt(string.replace((CharSequence)object, string3));
        char[] cArray = formattedDate.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] dateCharArray = cArray;
        byte mask = 0;
        for (int i = 0; i < 8; ++i) {
            if (dateCharArray[i] != 'x') continue;
            mask = (byte)(mask | 128 >> i);
        }
        byte[] byArray = new byte[]{mask, (byte)(dateInt >>> 16), (byte)(dateInt >>> 8), (byte)dateInt};
        return byArray;
    }

    @NotNull
    public final byte[] encodeC40(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String dataString = string;
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int sum = 0;
        Buffer out = new Buffer();
        String string2 = dataString.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("<");
        String string3 = " ";
        dataString = regex.replace(charSequence, string3);
        int len = dataString.length();
        for (int i = 0; i < len; ++i) {
            Buffer buffer;
            if (i % 3 != 0) continue;
            if (i + 2 < len) {
                c1 = this.getC40Value(dataString.charAt(i));
                c2 = this.getC40Value(dataString.charAt(i + 1));
                c3 = this.getC40Value(dataString.charAt(i + 2));
                sum = 1600 * c1 + 40 * c2 + c3 + 1;
                out.writeByte(sum / 256);
                buffer = out.writeByte(sum % 256);
                continue;
            }
            if (i + 1 < len) {
                c1 = this.getC40Value(dataString.charAt(i));
                c2 = this.getC40Value(dataString.charAt(i + 1));
                sum = 1600 * c1 + 40 * c2 + 1;
                out.writeByte(sum / 256);
                buffer = out.writeByte(sum % 256);
                continue;
            }
            out.writeByte(254);
            buffer = out.writeByte(this.toUnsignedInt((byte)dataString.charAt(i)) + 1);
        }
        return out.readByteArray();
    }

    private final int getC40Value(char c) {
        int n;
        int value = this.toUnsignedInt((byte)c);
        if (value == 32) {
            n = 3;
        } else {
            boolean bl = 48 <= value ? value < 58 : false;
            if (bl) {
                n = value - 44;
            } else {
                boolean bl2 = 65 <= value ? value < 91 : false;
                if (bl2) {
                    n = value - 51;
                } else {
                    throw new IllegalArgumentException("Not a C40 encodable char: " + c + "value: " + value);
                }
            }
        }
        return n;
    }

    private final int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    @NotNull
    public final String encodeBase256(@NotNull byte[] ba) {
        Intrinsics.checkNotNullParameter((Object)ba, (String)"ba");
        char[] ca = new char[ba.length];
        int n = ba.length;
        for (int i = 0; i < n; ++i) {
            ca[i] = (char)(ba[i] & 0xFF);
        }
        return StringsKt.concatToString((char[])ca);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] zip(@NotNull byte[] bytesToCompress) {
        void this_$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)bytesToCompress, (String)"bytesToCompress");
        Buffer outputBuffer = new Buffer();
        Buffer inputBuffer = new Buffer().write(bytesToCompress);
        DeflaterSink compressor = new DeflaterSink((Sink)outputBuffer, new Deflater(9, false));
        compressor.write(inputBuffer, inputBuffer.size());
        compressor.close();
        byte[] compressedBytes = outputBuffer.readByteArray();
        Logger logger = (Logger)Logger.Companion;
        String string = "Zip ratio " + (float)bytesToCompress.length / (float)compressedBytes.length + ", input size " + bytesToCompress.length + ", compressed size " + compressedBytes.length;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            void messageString$iv;
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, (String)messageString$iv);
        }
        return compressedBytes;
    }

    public final void setFeatureEncoder(@NotNull FeatureConverter featureEncoder) {
        Intrinsics.checkNotNullParameter((Object)featureEncoder, (String)"featureEncoder");
        DataEncoder.featureEncoder = featureEncoder;
    }

    @NotNull
    public final byte[] buildCertificateReference(@NotNull byte[] certificateBytes) {
        Intrinsics.checkNotNullParameter((Object)certificateBytes, (String)"certificateBytes");
        Hasher hasher = ((Digest)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)SHA1.INSTANCE)).hasher();
        byte[] certSha12 = (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(hasher, certificateBytes, null){
            int label;
            final /* synthetic */ Hasher $hasher;
            final /* synthetic */ byte[] $certificateBytes;
            {
                this.$hasher = $hasher;
                this.$certificateBytes = $certificateBytes;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$hasher.hash(this.$certificateBytes, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return ArraysKt.sliceArray((byte[])certSha12, (IntRange)new IntRange(15, 19));
    }

    @Nullable
    public final Feature encodeDerTlv(@NotNull String vdsType, @NotNull DerTlv derTlv) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        Object value = featureConverter.decodeFeature(vdsType, derTlv);
        FeatureConverter featureConverter2 = featureEncoder;
        if (featureConverter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter2 = null;
        }
        String name = featureConverter2.getFeatureName(vdsType, derTlv);
        FeatureConverter featureConverter3 = featureEncoder;
        if (featureConverter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter3 = null;
        }
        FeatureCoding coding = featureConverter3.getFeatureCoding(vdsType, derTlv);
        if (Intrinsics.areEqual((Object)name, (Object)"") || coding == FeatureCoding.UNKNOWN) {
            return null;
        }
        return new Feature(name, value, coding);
    }

    @Nullable
    public final String getVdsType(int documentRef) {
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        return featureConverter.getVdsType(documentRef);
    }

    @Nullable
    public final Integer getDocumentRef(@NotNull String vdsType) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        return featureConverter.getDocumentRef(vdsType);
    }

    @NotNull
    public final <T> DerTlv encodeFeature(@NotNull String vdsType, @NotNull String feature, T value) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        return featureConverter.encodeFeature(vdsType, feature, value);
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            String jsonString = ReadTextResource_jvmKt.readTextResource("SealCodings.json");
            featureEncoder = new FeatureConverter(jsonString);
        }
        catch (FileNotFoundException e) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = (Logger)Logger.Companion;
            String messageString$iv = "Can't initialize FeatureEncoder: " + e.getMessage();
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            System.out.println((Object)("Can't initialize FeatureEncoder: " + e.getMessage()));
        }
    }
}

