/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ClockKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002,-B\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000b\u00a8\u0006."}, d2={"Lde/tsenger/vdstools/vds/VdsHeader;", "", "<init>", "()V", "builder", "Lde/tsenger/vdstools/vds/VdsHeader$Builder;", "(Lde/tsenger/vdstools/vds/VdsHeader$Builder;)V", "value", "", "issuingCountry", "getIssuingCountry", "()Ljava/lang/String;", "signerIdentifier", "getSignerIdentifier", "certificateReference", "getCertificateReference", "Lkotlinx/datetime/LocalDate;", "issuingDate", "getIssuingDate", "()Lkotlinx/datetime/LocalDate;", "sigDate", "getSigDate", "", "docFeatureRef", "getDocFeatureRef", "()B", "docTypeCat", "getDocTypeCat", "rawVersion", "getRawVersion", "signerCertRef", "getSignerCertRef", "documentRef", "", "getDocumentRef", "()I", "vdsType", "getVdsType", "encoded", "", "getEncoded", "()[B", "encodedSignerIdentifierAndCertificateReference", "getEncodedSignerIdentifierAndCertificateReference", "Builder", "Companion", "vdstools_mp"})
@SourceDebugExtension(value={"SMAP\nVdsHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VdsHeader.kt\nde/tsenger/vdstools/vds/VdsHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nco/touchlab/kermit/Logger\n+ 4 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,265:1\n1#2:266\n82#3,2:267\n84#3:278\n54#4,9:269\n*S KotlinDebug\n*F\n+ 1 VdsHeader.kt\nde/tsenger/vdstools/vds/VdsHeader\n*L\n83#1:267,2\n83#1:278\n83#1:269,9\n*E\n"})
public final class VdsHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String issuingCountry = "UTO";
    @Nullable
    private String signerIdentifier;
    @Nullable
    private String certificateReference;
    @Nullable
    private LocalDate issuingDate;
    @Nullable
    private LocalDate sigDate;
    private byte docFeatureRef;
    private byte docTypeCat;
    private byte rawVersion;
    public static final byte DC = -36;

    @NotNull
    public final String getIssuingCountry() {
        return this.issuingCountry;
    }

    @Nullable
    public final String getSignerIdentifier() {
        return this.signerIdentifier;
    }

    @Nullable
    public final String getCertificateReference() {
        return this.certificateReference;
    }

    @Nullable
    public final LocalDate getIssuingDate() {
        return this.issuingDate;
    }

    @Nullable
    public final LocalDate getSigDate() {
        return this.sigDate;
    }

    public final byte getDocFeatureRef() {
        return this.docFeatureRef;
    }

    public final byte getDocTypeCat() {
        return this.docTypeCat;
    }

    public final byte getRawVersion() {
        return this.rawVersion;
    }

    private VdsHeader() {
    }

    private VdsHeader(Builder builder) {
        this.issuingCountry = builder.getIssuingCountry();
        this.signerIdentifier = builder.getSignerIdentifier();
        this.certificateReference = builder.getCertificateReference();
        this.issuingDate = builder.getIssuingDate();
        this.sigDate = builder.getSigDate();
        this.docFeatureRef = builder.getDocFeatureRef();
        this.docTypeCat = builder.getDocTypeCat();
        this.rawVersion = builder.getRawVersion();
    }

    @NotNull
    public final String getSignerCertRef() {
        String string;
        Object object;
        String string2 = this.certificateReference;
        if (string2 != null && (string2 = StringsKt.trimStart((String)string2, (char[])(object = (Object)new char[]{'0'}))) != null) {
            Object object2;
            object = string2;
            if (object.length() == 0) {
                boolean bl = false;
                object2 = "0";
            } else {
                object2 = object;
            }
            string = (String)object2;
        } else {
            string = null;
        }
        String certRefInteger = string;
        String string3 = (this.signerIdentifier + certRefInteger).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return string3;
    }

    public final int getDocumentRef() {
        return ((this.docFeatureRef & 0xFF) << 8) + (this.docTypeCat & 0xFF);
    }

    @NotNull
    public final String getVdsType() {
        String vdsType = DataEncoder.INSTANCE.getVdsType(this.getDocumentRef());
        String string = vdsType;
        if (string == null) {
            string = "UNKNOWN";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getEncoded() {
        Buffer buffer;
        block2: {
            buffer = new Buffer();
            try {
                buffer.writeByte(-36);
                buffer.writeByte((int)this.rawVersion);
                buffer.write(DataEncoder.INSTANCE.encodeC40(this.issuingCountry));
                buffer.write(DataEncoder.INSTANCE.encodeC40(this.getEncodedSignerIdentifierAndCertificateReference()));
                buffer.write(DataEncoder.INSTANCE.encodeDate(this.issuingDate));
                buffer.write(DataEncoder.INSTANCE.encodeDate(this.sigDate));
                buffer.writeByte((int)this.docFeatureRef);
                buffer.writeByte((int)this.docTypeCat);
            }
            catch (Exception e) {
                void this_$iv$iv;
                void $this$iv;
                Logger logger = (Logger)Logger.Companion;
                String messageString$iv = "Error while encoding header data: " + e.getMessage();
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$e = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Error;
                boolean $i$f$log = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) break block2;
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
        }
        return buffer.readByteArray();
    }

    private final String getEncodedSignerIdentifierAndCertificateReference() {
        String string;
        if (this.rawVersion == 2) {
            String string2;
            String string3 = this.signerIdentifier;
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = this.certificateReference) == null) {
                string2 = "";
            }
            String string4 = (string3 + StringsKt.padStart((String)string2, (int)5, (char)' ')).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            string = StringsKt.replace$default((String)string4, (char)' ', (char)'0', (boolean)false, (int)4, null);
        } else if (this.rawVersion == 3) {
            String string5;
            String string6 = this.signerIdentifier;
            if (string6 == null) {
                string6 = "";
            }
            if ((string5 = this.certificateReference) == null) {
                string5 = "";
            }
            String string7 = Integer.toString(string5.length(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
            String string8 = StringsKt.padStart((String)string7, (int)2, (char)'0');
            String string9 = this.certificateReference;
            if (string9 == null) {
                string9 = "";
            }
            String string10 = (string6 + string8 + string9).toUpperCase(Locale.ROOT);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toUpperCase(...)");
        } else {
            string = "";
        }
        return string;
    }

    public /* synthetic */ VdsHeader(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public /* synthetic */ VdsHeader(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006'"}, d2={"Lde/tsenger/vdstools/vds/VdsHeader$Builder;", "", "vdsType", "", "<init>", "(Ljava/lang/String;)V", "value", "issuingCountry", "getIssuingCountry", "()Ljava/lang/String;", "signerIdentifier", "getSignerIdentifier", "certificateReference", "getCertificateReference", "Lkotlinx/datetime/LocalDate;", "issuingDate", "getIssuingDate", "()Lkotlinx/datetime/LocalDate;", "sigDate", "getSigDate", "", "docFeatureRef", "getDocFeatureRef", "()B", "docTypeCat", "getDocTypeCat", "rawVersion", "getRawVersion", "setIssuingCountry", "setSignerIdentifier", "setCertificateReference", "setIssuingDate", "setSigDate", "setRawVersion", "", "build", "Lde/tsenger/vdstools/vds/VdsHeader;", "setDocumentType", "", "vdstools_mp"})
    public static final class Builder {
        @NotNull
        private String issuingCountry;
        @NotNull
        private String signerIdentifier;
        @NotNull
        private String certificateReference;
        @NotNull
        private LocalDate issuingDate;
        @NotNull
        private LocalDate sigDate;
        private byte docFeatureRef;
        private byte docTypeCat;
        private byte rawVersion;

        public Builder(@NotNull String vdsType) {
            Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
            this.issuingCountry = "UTO";
            this.signerIdentifier = "UTXX";
            this.certificateReference = "12345";
            this.issuingDate = ClockKt.todayIn((Clock)((Clock)Clock.System.INSTANCE), (TimeZone)TimeZone.Companion.currentSystemDefault());
            this.sigDate = ClockKt.todayIn((Clock)((Clock)Clock.System.INSTANCE), (TimeZone)TimeZone.Companion.currentSystemDefault());
            this.rawVersion = (byte)3;
            this.setDocumentType(vdsType);
        }

        @NotNull
        public final String getIssuingCountry() {
            return this.issuingCountry;
        }

        @NotNull
        public final String getSignerIdentifier() {
            return this.signerIdentifier;
        }

        @NotNull
        public final String getCertificateReference() {
            return this.certificateReference;
        }

        @NotNull
        public final LocalDate getIssuingDate() {
            return this.issuingDate;
        }

        @NotNull
        public final LocalDate getSigDate() {
            return this.sigDate;
        }

        public final byte getDocFeatureRef() {
            return this.docFeatureRef;
        }

        public final byte getDocTypeCat() {
            return this.docTypeCat;
        }

        public final byte getRawVersion() {
            return this.rawVersion;
        }

        @NotNull
        public final Builder setIssuingCountry(@NotNull String issuingCountry) {
            Intrinsics.checkNotNullParameter((Object)issuingCountry, (String)"issuingCountry");
            this.issuingCountry = issuingCountry;
            return this;
        }

        @NotNull
        public final Builder setSignerIdentifier(@NotNull String signerIdentifier) {
            Intrinsics.checkNotNullParameter((Object)signerIdentifier, (String)"signerIdentifier");
            this.signerIdentifier = signerIdentifier;
            return this;
        }

        @NotNull
        public final Builder setCertificateReference(@NotNull String certificateReference) {
            Intrinsics.checkNotNullParameter((Object)certificateReference, (String)"certificateReference");
            this.certificateReference = certificateReference;
            return this;
        }

        @NotNull
        public final Builder setIssuingDate(@NotNull LocalDate issuingDate) {
            Intrinsics.checkNotNullParameter((Object)issuingDate, (String)"issuingDate");
            this.issuingDate = issuingDate;
            return this;
        }

        @NotNull
        public final Builder setSigDate(@NotNull LocalDate sigDate) {
            Intrinsics.checkNotNullParameter((Object)sigDate, (String)"sigDate");
            this.sigDate = sigDate;
            return this;
        }

        @NotNull
        public final Builder setRawVersion(int rawVersion) {
            this.rawVersion = (byte)rawVersion;
            return this;
        }

        @NotNull
        public final VdsHeader build() {
            return new VdsHeader(this, null);
        }

        private final void setDocumentType(String vdsType) {
            Integer docRef = DataEncoder.INSTANCE.getDocumentRef(vdsType);
            if (docRef != null) {
                this.docFeatureRef = (byte)(docRef >> 8 & 0xFF);
                this.docTypeCat = (byte)(docRef & 0xFF);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools/vds/VdsHeader$Companion;", "", "<init>", "()V", "DC", "", "fromBuffer", "Lde/tsenger/vdstools/vds/VdsHeader;", "rawdataBuffer", "Lokio/Buffer;", "vdstools_mp"})
    @SourceDebugExtension(value={"SMAP\nVdsHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VdsHeader.kt\nde/tsenger/vdstools/vds/VdsHeader$Companion\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,265:1\n82#2,2:266\n84#2:277\n82#2,2:278\n84#2:289\n67#2,2:290\n69#2:301\n67#2,2:302\n69#2:313\n67#2,2:314\n69#2:325\n54#3,9:268\n54#3,9:280\n54#3,9:292\n54#3,9:304\n54#3,9:316\n*S KotlinDebug\n*F\n+ 1 VdsHeader.kt\nde/tsenger/vdstools/vds/VdsHeader$Companion\n*L\n204#1:266,2\n204#1:277\n223#1:278,2\n223#1:289\n243#1:290,2\n243#1:301\n246#1:302,2\n246#1:313\n260#1:314,2\n260#1:325\n204#1:268,9\n223#1:280,9\n243#1:292,9\n246#1:304,9\n260#1:316,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VdsHeader fromBuffer(@NotNull Buffer rawdataBuffer) throws IllegalArgumentException {
            void this_$iv$iv;
            void $this$iv;
            String signerCertRef;
            BaseLogger throwable$iv;
            Intrinsics.checkNotNullParameter((Object)rawdataBuffer, (String)"rawdataBuffer");
            byte magicByte = rawdataBuffer.readByte();
            if (magicByte != -36) {
                void this_$iv$iv2;
                void $this$iv2;
                Logger logger = (Logger)Logger.Companion;
                String string = Integer.toString(magicByte, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String string3 = "Magic Constant mismatch:  " + string2 + ", instead of 0xDC";
                Throwable throwable$iv2 = null;
                String tag$iv = $this$iv2.getTag();
                boolean $i$f$e = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv2;
                Severity severity$iv$iv = Severity.Error;
                boolean $i$f$log = false;
                if (this_$iv$iv2.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    void messageString$iv;
                    this_$iv$iv2.processLog(severity$iv$iv, tag$iv, throwable$iv2, (String)messageString$iv);
                }
                String string4 = Integer.toString(magicByte, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                String string5 = StringsKt.padStart((String)string4, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                throw new IllegalArgumentException("Magic Constant mismatch:  " + string5 + ", instead of 0xDC");
            }
            VdsHeader vdsHeader = new VdsHeader(null);
            vdsHeader.rawVersion = rawdataBuffer.readByte();
            if (vdsHeader.getRawVersion() != 2 && vdsHeader.getRawVersion() != 3) {
                void this_$iv$iv3;
                void $this$iv3;
                Logger messageString$iv = (Logger)Logger.Companion;
                String string = Integer.toString(vdsHeader.getRawVersion(), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string6 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                String throwable$iv2 = "Unsupported rawVersion: " + string6;
                Throwable throwable$iv3 = null;
                String tag$iv = $this$iv3.getTag();
                boolean $i$f$e = false;
                BaseLogger severity$iv$iv = (BaseLogger)$this$iv3;
                Severity severity$iv$iv2 = Severity.Error;
                boolean $i$f$log = false;
                if (this_$iv$iv3.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv2) <= 0) {
                    void messageString$iv2;
                    this_$iv$iv3.processLog(severity$iv$iv2, tag$iv, throwable$iv3, (String)messageString$iv2);
                }
                String string7 = Integer.toString(vdsHeader.getRawVersion(), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
                String string8 = StringsKt.padStart((String)string7, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toUpperCase(...)");
                throw new IllegalArgumentException("Unsupported rawVersion: " + string8);
            }
            vdsHeader.issuingCountry = DataParser.INSTANCE.decodeC40(rawdataBuffer.readByteArray(2L));
            if (vdsHeader.getRawVersion() == 3) {
                void this_$iv$iv4;
                void $this$iv4;
                void this_$iv$iv5;
                void $this$iv5;
                String signerIdentifierAndCertRefLength = DataParser.INSTANCE.decodeC40(rawdataBuffer.readByteArray(4L));
                String string = signerIdentifierAndCertRefLength.substring(0, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                vdsHeader.signerIdentifier = string;
                String string9 = signerIdentifierAndCertRefLength.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                int certRefLength = Integer.parseInt(string9, CharsKt.checkRadix((int)16));
                Logger throwable$iv3 = (Logger)Logger.Companion;
                String messageString$iv = "version 4: certRefLength: " + certRefLength;
                Throwable throwable$iv4 = null;
                String tag$iv = $this$iv5.getTag();
                boolean $i$f$d = false;
                BaseLogger $i$f$log = (BaseLogger)$this$iv5;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$log2 = false;
                if (this_$iv$iv5.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    this_$iv$iv5.processLog(severity$iv$iv, tag$iv, throwable$iv4, messageString$iv);
                }
                int bytesToDecode = (certRefLength - 1) / 3 * 2 + 2;
                messageString$iv = (Logger)Logger.Companion;
                String messageString$iv3 = "version 4: bytesToDecode: " + bytesToDecode;
                throwable$iv = null;
                String tag$iv2 = $this$iv4.getTag();
                boolean $i$f$d2 = false;
                severity$iv$iv = (BaseLogger)$this$iv4;
                Severity severity$iv$iv3 = Severity.Debug;
                boolean $i$f$log3 = false;
                if (this_$iv$iv4.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv3) <= 0) {
                    this_$iv$iv4.processLog(severity$iv$iv3, tag$iv2, (Throwable)throwable$iv, messageString$iv3);
                }
                vdsHeader.certificateReference = DataParser.INSTANCE.decodeC40(rawdataBuffer.readByteArray((long)bytesToDecode));
            } else {
                signerCertRef = DataParser.INSTANCE.decodeC40(rawdataBuffer.readByteArray(6L));
                String string = signerCertRef.substring(0, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                vdsHeader.signerIdentifier = string;
                String string10 = signerCertRef.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"substring(...)");
                vdsHeader.certificateReference = string10;
            }
            vdsHeader.issuingDate = DataParser.INSTANCE.decodeDate(rawdataBuffer.readByteArray(3L));
            vdsHeader.sigDate = DataParser.INSTANCE.decodeDate(rawdataBuffer.readByteArray(3L));
            vdsHeader.docFeatureRef = rawdataBuffer.readByte();
            vdsHeader.docTypeCat = rawdataBuffer.readByte();
            signerCertRef = (Logger)Logger.Companion;
            String messageString$iv = "VdsHeader: " + vdsHeader;
            Throwable throwable$iv5 = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$d = false;
            throwable$iv = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Debug;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv5, messageString$iv);
            }
            return vdsHeader;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

