/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.FeatureCoding;
import de.tsenger.vdstools.vds.dto.FeaturesDto;
import de.tsenger.vdstools.vds.dto.SealDto;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ!\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010!J)\u0010\"\u001a\u00020\u001c\"\u0004\b\u0000\u0010 2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u0002H \u00a2\u0006\u0002\u0010%J+\u0010\"\u001a\u00020\u001c\"\u0004\b\u0000\u0010 2\u0006\u0010&\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u0002H H\u0002\u00a2\u0006\u0002\u0010'J#\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u0011H\u0002J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\n2\u0006\u0010,\u001a\u00020+H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\n2\u0006\u0010,\u001a\u00020+H\u0002J\u0010\u00100\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"Lde/tsenger/vdstools/FeatureConverter;", "", "jsonString", "", "<init>", "(Ljava/lang/String;)V", "log", "Lco/touchlab/kermit/Logger;", "sealDtoList", "", "Lde/tsenger/vdstools/vds/dto/SealDto;", "populateMappings", "", "availableVdsTypes", "getAvailableVdsTypes", "()Ljava/util/List;", "getDocumentRef", "", "vdsType", "(Ljava/lang/String;)Ljava/lang/Integer;", "getVdsType", "docRef", "availableVdsFeatures", "", "getAvailableVdsFeatures", "()Ljava/util/Set;", "getFeatureName", "derTlv", "Lde/tsenger/vdstools/asn1/DerTlv;", "getFeatureCoding", "Lde/tsenger/vdstools/vds/FeatureCoding;", "decodeFeature", "T", "(Ljava/lang/String;Lde/tsenger/vdstools/asn1/DerTlv;)Ljava/lang/Object;", "encodeFeature", "feature", "inputValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/asn1/DerTlv;", "sealDto", "(Lde/tsenger/vdstools/vds/dto/SealDto;Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/asn1/DerTlv;", "(Lde/tsenger/vdstools/vds/dto/SealDto;Lde/tsenger/vdstools/asn1/DerTlv;)Ljava/lang/Object;", "decodeC40Feature", "getTag", "", "tag", "getCoding", "getFeatureDto", "Lde/tsenger/vdstools/vds/dto/FeaturesDto;", "getSealDto", "Companion", "vdstools"})
@SourceDebugExtension(value={"SMAP\nFeatureConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureConverter.kt\nde/tsenger/vdstools/FeatureConverter\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\nco/touchlab/kermit/Logger\n+ 5 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,217:1\n147#2:218\n1863#3,2:219\n77#4,2:221\n79#4:232\n77#4,2:233\n79#4:244\n77#4,2:245\n79#4:256\n77#4,2:257\n79#4:268\n77#4,2:269\n79#4:280\n77#4,2:281\n79#4:292\n54#5,9:223\n54#5,9:235\n54#5,9:247\n54#5,9:259\n54#5,9:271\n54#5,9:283\n*S KotlinDebug\n*F\n+ 1 FeatureConverter.kt\nde/tsenger/vdstools/FeatureConverter\n*L\n24#1:218\n35#1:219,2\n56#1:221,2\n56#1:232\n66#1:233,2\n66#1:244\n77#1:245,2\n77#1:256\n88#1:257,2\n88#1:268\n92#1:269,2\n92#1:280\n103#1:281,2\n103#1:292\n56#1:223,9\n66#1:235,9\n77#1:247,9\n88#1:259,9\n92#1:271,9\n103#1:283,9\n*E\n"})
public final class FeatureConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private List<SealDto> sealDtoList;
    @NotNull
    private static final Map<String, Integer> vdsTypes = new HashMap();
    @NotNull
    private static final Map<Integer, String> vdsTypesReverse = new HashMap();
    @NotNull
    private static final Set<String> vdsFeatures = new LinkedHashSet();

    public FeatureConverter(@NotNull String jsonString) {
        Json json;
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log = Logger.Companion.withTag(string);
        Json this_$iv = json = JsonKt.Json$default(null, FeatureConverter::_init_$lambda$0, (int)1, null);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        this.sealDtoList = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SealDto.Companion.serializer()), jsonString);
        this.populateMappings();
    }

    private final void populateMappings() {
        for (SealDto sealDto : this.sealDtoList) {
            String documentType = sealDto.component1();
            String documentRef = sealDto.component2();
            List<FeaturesDto> features = sealDto.component4();
            if (!Intrinsics.areEqual((Object)documentType, (Object)"") && !Intrinsics.areEqual((Object)documentRef, (Object)"")) {
                vdsTypes.put(documentType, Integer.parseInt(documentRef, CharsKt.checkRadix((int)16)));
                vdsTypesReverse.put(Integer.parseInt(documentRef, CharsKt.checkRadix((int)16)), documentType);
            }
            Iterable $this$forEach$iv = features;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FeaturesDto it = (FeaturesDto)element$iv;
                boolean bl = false;
                vdsFeatures.add(it.getName());
            }
        }
    }

    @NotNull
    public final List<String> getAvailableVdsTypes() {
        return CollectionsKt.toList((Iterable)vdsTypes.keySet());
    }

    @Nullable
    public final Integer getDocumentRef(@NotNull String vdsType) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        return vdsTypes.get(vdsType);
    }

    @Nullable
    public final String getVdsType(int docRef) {
        return vdsTypesReverse.get(docRef);
    }

    @NotNull
    public final Set<String> getAvailableVdsFeatures() {
        return vdsFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFeatureName(@NotNull String vdsType, @NotNull DerTlv derTlv) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        if (!vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No seal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        return this.getFeatureName(sealDto, derTlv.getTag());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeatureCoding getFeatureCoding(@NotNull String vdsType, @NotNull DerTlv derTlv) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        if (!vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No seal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        byte tag = derTlv.getTag();
        return this.getCoding(sealDto, tag);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T decodeFeature(@NotNull String vdsType, @NotNull DerTlv derTlv) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        if (!vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No seal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        return this.decodeFeature(sealDto, derTlv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> DerTlv encodeFeature(@NotNull String vdsType, @NotNull String feature, T inputValue) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        if (!vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No VdsSeal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        if (!vdsFeatures.contains(feature)) {
            Logger $this$iv = this.log;
            String messageString$iv = "No VdsSeal feature with name '" + feature + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger this_$iv$iv = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No VdsSeal feature with name '" + feature + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        return this.encodeFeature(sealDto, feature, inputValue);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DerTlv encodeFeature(SealDto sealDto, String feature, T inputValue) throws IllegalArgumentException {
        byte tag = this.getTag(sealDto, feature);
        if (tag == 0) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "VdsType: " + sealDto.getDocumentType() + " has no Feature " + feature;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("VdsType: " + sealDto.getDocumentType() + " has no Feature " + feature);
        }
        FeatureCoding coding = this.getCoding(sealDto, feature);
        byte[] value = null;
        switch (WhenMappings.$EnumSwitchMapping$0[coding.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.String");
                CharSequence charSequence = (String)inputValue;
                Regex regex = new Regex("\r");
                String string = "";
                charSequence = regex.replace(charSequence, string);
                regex = new Regex("\n");
                string = "";
                String valueStr = regex.replace(charSequence, string);
                value = DataEncoder.INSTANCE.encodeC40(valueStr);
                break;
            }
            case 2: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.String");
                value = StringsKt.encodeToByteArray((String)((String)inputValue));
                break;
            }
            case 3: {
                byte[] byArray = new byte[1];
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.Byte");
                byArray[0] = (Byte)inputValue;
                value = byArray;
                break;
            }
            case 4: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                value = (byte[])inputValue;
                break;
            }
            case 5: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                value = (byte[])inputValue;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new DerTlv(tag, value);
    }

    private final <T> T decodeFeature(SealDto sealDto, DerTlv derTlv) {
        byte tag = derTlv.getTag();
        FeatureCoding coding = this.getCoding(sealDto, tag);
        Serializable result = switch (WhenMappings.$EnumSwitchMapping$0[coding.ordinal()]) {
            case 1 -> (Serializable)((Object)this.decodeC40Feature(sealDto, derTlv));
            case 2 -> (Serializable)((Object)StringsKt.decodeToString((byte[])derTlv.getValue()));
            case 3 -> Byte.valueOf(derTlv.getValue()[0]);
            case 4 -> (Serializable)derTlv.getValue();
            case 5 -> (Serializable)derTlv.getValue();
            default -> throw new NoWhenBranchMatchedException();
        };
        return (T)result;
    }

    private final String decodeC40Feature(SealDto sealDto, DerTlv derTlv) {
        byte tag = derTlv.getTag();
        String featureValue = DataParser.INSTANCE.decodeC40(derTlv.getValue());
        String featureName = this.getFeatureName(sealDto, tag);
        if (StringsKt.startsWith$default((String)featureName, (String)"MRZ", (boolean)false, (int)2, null)) {
            int mrzLength = this.getFeatureDto(sealDto, tag).getDecodedLength();
            String paddedMrz = StringsKt.replace$default((String)StringsKt.padEnd((String)featureValue, (int)mrzLength, (char)'<'), (char)' ', (char)'<', (boolean)false, (int)4, null);
            String string = paddedMrz.substring(0, mrzLength / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = paddedMrz.substring(mrzLength / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + "\n" + string2;
        }
        return featureValue;
    }

    private final byte getTag(SealDto sealDto, String feature) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            String name = featuresDto.component1();
            int tag = featuresDto.component2();
            if (!StringsKt.equals((String)name, (String)feature, (boolean)true)) continue;
            return (byte)tag;
        }
        throw new IllegalArgumentException("Feature '" + feature + "' is unspecified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final String getFeatureName(SealDto sealDto, int tag) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            String name = featuresDto.component1();
            int tag1 = featuresDto.component2();
            if (tag1 != tag) continue;
            return name;
        }
        throw new IllegalArgumentException("No Feature with tag '" + tag + "' is specified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final FeatureCoding getCoding(SealDto sealDto, String feature) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            String name = featuresDto.component1();
            FeatureCoding coding = featuresDto.component3();
            if (!StringsKt.equals((String)name, (String)feature, (boolean)true)) continue;
            return coding;
        }
        throw new IllegalArgumentException("Feature '" + feature + "' is unspecified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final FeatureCoding getCoding(SealDto sealDto, byte tag) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            int tag1 = featuresDto.component2();
            FeatureCoding coding = featuresDto.component3();
            if (tag1 != tag) continue;
            return coding;
        }
        throw new IllegalArgumentException("No Feature with tag '" + tag + "' is specified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final FeaturesDto getFeatureDto(SealDto sealDto, byte tag) throws IllegalArgumentException {
        for (FeaturesDto featureDto : sealDto.getFeatures()) {
            if (featureDto.getTag() != tag) continue;
            return featureDto;
        }
        throw new IllegalArgumentException("No Feature with tag '" + tag + "' is specified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final SealDto getSealDto(String vdsType) throws IllegalArgumentException {
        for (SealDto sealDto : this.sealDtoList) {
            if (!Intrinsics.areEqual((Object)sealDto.getDocumentType(), (Object)vdsType)) continue;
            return sealDto;
        }
        throw new IllegalArgumentException("VdsType '" + vdsType + "' is unspecified in SealCodings.");
    }

    private static final Unit _init_$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/tsenger/vdstools/FeatureConverter$Companion;", "", "<init>", "()V", "vdsTypes", "", "", "", "vdsTypesReverse", "vdsFeatures", "", "vdstools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureCoding.values().length];
            try {
                nArray[FeatureCoding.C40.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UTF8_STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

