/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.CustomCryptographyProvider_jvmKt;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.SHA224;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.algorithms.SHA384;
import dev.whyoleg.cryptography.algorithms.SHA512;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.operations.SignatureGenerator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lde/tsenger/vdstools/Signer;", "", "privKeyBytes", "", "curveName", "", "<init>", "([BLjava/lang/String;)V", "log", "Lco/touchlab/kermit/Logger;", "ecPrivKey", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "value", "", "fieldSize", "getFieldSize", "()I", "sign", "dataToSign", "vdstools"})
@SourceDebugExtension(value={"SMAP\nSigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signer.kt\nde/tsenger/vdstools/Signer\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,52:1\n82#2,2:53\n84#2:64\n72#2,2:65\n74#2:76\n54#3,9:55\n54#3,9:67\n*S KotlinDebug\n*F\n+ 1 Signer.kt\nde/tsenger/vdstools/Signer\n*L\n24#1:53,2\n24#1:64\n46#1:65,2\n46#1:76\n24#1:55,9\n46#1:67,9\n*E\n"})
public final class Signer {
    @NotNull
    private final Logger log;
    @NotNull
    private ECDSA.PrivateKey ecPrivKey;
    private int fieldSize;

    /*
     * WARNING - void declaration
     */
    public Signer(@NotNull byte[] privKeyBytes, @NotNull String curveName) {
        Intrinsics.checkNotNullParameter((Object)privKeyBytes, (String)"privKeyBytes");
        Intrinsics.checkNotNullParameter((Object)curveName, (String)"curveName");
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log = Logger.Companion.withTag(string);
        CryptographyProvider provider = CustomCryptographyProvider_jvmKt.getCryptoProvider();
        ECDSA ecdsa = (ECDSA)provider.get((CryptographyAlgorithmId)ECDSA.Companion);
        KeyDecoder keyDecoder = ecdsa.privateKeyDecoder-yfdS0HE(EC.Curve.constructor-impl((String)curveName));
        this.ecPrivKey = (ECDSA.PrivateKey)keyDecoder.decodeFromByteArrayBlocking((KeyFormat)EC.PrivateKey.Format.DER.Generic, privKeyBytes);
        this.fieldSize = this.ecPrivKey.encodeToByteArrayBlocking((KeyFormat)EC.PrivateKey.Format.RAW.INSTANCE).length * 8;
        int n = this.fieldSize;
        if (!(224 <= n ? n < 513 : false)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "Bit length of Field is out of defined value: " + this.fieldSize;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("Bit length of Field is out of defined value (224 to 512 bits): " + this.fieldSize);
        }
    }

    public final int getFieldSize() {
        return this.fieldSize;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] sign(@NotNull byte[] dataToSign) {
        void this_$iv$iv;
        void $this$iv;
        CryptographyAlgorithmId cryptographyAlgorithmId;
        Intrinsics.checkNotNullParameter((Object)dataToSign, (String)"dataToSign");
        int n = this.fieldSize;
        boolean bl = Integer.MIN_VALUE <= n ? n < 225 : false;
        if (bl) {
            cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA224.INSTANCE;
        } else {
            boolean bl2 = 225 <= n ? n < 257 : false;
            if (bl2) {
                cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA256.INSTANCE;
            } else {
                boolean bl3 = 257 <= n ? n < 385 : false;
                if (bl3) {
                    cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA384.INSTANCE;
                } else {
                    boolean bl4 = 385 <= n ? n < 513 : false;
                    if (bl4) {
                        cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA512.INSTANCE;
                    } else {
                        throw new IllegalArgumentException("Ung\u00fcltige fieldSize: " + this.fieldSize);
                    }
                }
            }
        }
        CryptographyAlgorithmId digest = cryptographyAlgorithmId;
        SignatureGenerator ecdsaSign = this.ecPrivKey.signatureGenerator(digest, ECDSA.SignatureFormat.RAW);
        Logger logger = this.log;
        String messageString$iv = "ECDSA algorithm: " + ecdsaSign;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$i = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Info;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        return ecdsaSign.generateSignatureBlocking(dataToSign);
    }
}

