/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.CustomCryptographyProvider_jvmKt;
import de.tsenger.vdstools.vds.DigitalSeal;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.SHA224;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.algorithms.SHA384;
import dev.whyoleg.cryptography.algorithms.SHA512;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.operations.SignatureVerifier;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lde/tsenger/vdstools/Verifier;", "", "digitalSeal", "Lde/tsenger/vdstools/vds/DigitalSeal;", "publicKeyBytes", "", "curveName", "", "<init>", "(Lde/tsenger/vdstools/vds/DigitalSeal;[BLjava/lang/String;)V", "log", "Lco/touchlab/kermit/Logger;", "keyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey$Format;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "ecPubKey", "messageBytes", "signatureBytes", "fieldSize", "", "getFieldSize", "()I", "verify", "Lde/tsenger/vdstools/Verifier$Result;", "Result", "vdstools"})
@SourceDebugExtension(value={"SMAP\nVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Verifier.kt\nde/tsenger/vdstools/Verifier\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,63:1\n62#2,2:64\n64#2:75\n62#2,2:76\n64#2:87\n62#2,2:88\n64#2:99\n62#2,2:100\n64#2:111\n82#2,2:112\n84#2:123\n54#3,9:66\n54#3,9:78\n54#3,9:90\n54#3,9:102\n54#3,9:114\n*S KotlinDebug\n*F\n+ 1 Verifier.kt\nde/tsenger/vdstools/Verifier\n*L\n29#1:64,2\n29#1:75\n30#1:76,2\n30#1:87\n31#1:88,2\n31#1:99\n32#1:100,2\n32#1:111\n46#1:112,2\n46#1:123\n29#1:66,9\n30#1:78,9\n31#1:90,9\n32#1:102,9\n46#1:114,9\n*E\n"})
public final class Verifier {
    @NotNull
    private final Logger log;
    @NotNull
    private final KeyDecoder<EC.PublicKey.Format, ECDSA.PublicKey> keyDecoder;
    @NotNull
    private final ECDSA.PublicKey ecPubKey;
    @NotNull
    private final byte[] messageBytes;
    @NotNull
    private final byte[] signatureBytes;

    public Verifier(@NotNull DigitalSeal digitalSeal, @NotNull byte[] publicKeyBytes, @NotNull String curveName) {
        BaseLogger this_$iv$iv;
        Logger $this$iv;
        Intrinsics.checkNotNullParameter((Object)digitalSeal, (String)"digitalSeal");
        Intrinsics.checkNotNullParameter((Object)publicKeyBytes, (String)"publicKeyBytes");
        Intrinsics.checkNotNullParameter((Object)curveName, (String)"curveName");
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log = Logger.Companion.withTag(string);
        this.keyDecoder = ((ECDSA)CustomCryptographyProvider_jvmKt.getCryptoProvider().get((CryptographyAlgorithmId)ECDSA.Companion)).publicKeyDecoder-yfdS0HE(EC.Curve.constructor-impl((String)curveName));
        this.ecPubKey = (ECDSA.PublicKey)this.keyDecoder.decodeFromByteArrayBlocking((KeyFormat)EC.PublicKey.Format.DER.INSTANCE, publicKeyBytes);
        this.messageBytes = digitalSeal.getHeaderAndMessageBytes();
        this.signatureBytes = digitalSeal.getSignatureBytes();
        Logger logger = this.log;
        String messageString$iv = "Public Key bytes: 0x" + this.ecPubKey.encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE);
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$v = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Verbose;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        $this$iv = this.log;
        messageString$iv = "Field bit length: " + this.getFieldSize();
        throwable$iv = null;
        tag$iv = $this$iv.getTag();
        $i$f$v = false;
        this_$iv$iv = (BaseLogger)$this$iv;
        severity$iv$iv = Severity.Verbose;
        $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        $this$iv = this.log;
        messageString$iv = "Message bytes: " + HexExtensionsKt.toHexString$default((byte[])this.messageBytes, null, (int)1, null);
        throwable$iv = null;
        tag$iv = $this$iv.getTag();
        $i$f$v = false;
        this_$iv$iv = (BaseLogger)$this$iv;
        severity$iv$iv = Severity.Verbose;
        $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        $this$iv = this.log;
        messageString$iv = "Signature bytes: " + HexExtensionsKt.toHexString$default((byte[])this.signatureBytes, null, (int)1, null);
        throwable$iv = null;
        tag$iv = $this$iv.getTag();
        $i$f$v = false;
        this_$iv$iv = (BaseLogger)$this$iv;
        severity$iv$iv = Severity.Verbose;
        $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
    }

    private final int getFieldSize() {
        return (this.ecPubKey.encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE).length - 1) * 4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result verify() {
        CryptographyAlgorithmId cryptographyAlgorithmId;
        int n = this.getFieldSize();
        boolean bl = Integer.MIN_VALUE <= n ? n < 225 : false;
        if (bl) {
            cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA224.INSTANCE;
        } else {
            boolean bl2 = 225 <= n ? n < 257 : false;
            if (bl2) {
                cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA256.INSTANCE;
            } else {
                boolean bl3 = 257 <= n ? n < 385 : false;
                if (bl3) {
                    cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA384.INSTANCE;
                } else {
                    boolean bl4 = 385 <= n ? n < 513 : false;
                    if (bl4) {
                        cryptographyAlgorithmId = (CryptographyAlgorithmId)SHA512.INSTANCE;
                    } else {
                        void this_$iv$iv;
                        void $this$iv;
                        Logger logger = this.log;
                        String messageString$iv = "Bit length of Field is out of defined value: " + this.getFieldSize();
                        Throwable throwable$iv = null;
                        String tag$iv = $this$iv.getTag();
                        boolean $i$f$e = false;
                        BaseLogger baseLogger = (BaseLogger)$this$iv;
                        Severity severity$iv$iv = Severity.Error;
                        boolean $i$f$log = false;
                        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
                        }
                        return Result.VerifyError;
                    }
                }
            }
        }
        CryptographyAlgorithmId digest = cryptographyAlgorithmId;
        SignatureVerifier ecdsaVerify = this.ecPubKey.signatureVerifier(digest, ECDSA.SignatureFormat.RAW);
        ecdsaVerify.tryVerifySignatureBlocking(this.messageBytes, this.signatureBytes);
        return ecdsaVerify.tryVerifySignatureBlocking(this.messageBytes, this.signatureBytes) ? Result.SignatureValid : Result.SignatureInvalid;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lde/tsenger/vdstools/Verifier$Result;", "", "<init>", "(Ljava/lang/String;I)V", "SignatureValid", "SignatureInvalid", "VerifyError", "vdstools"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result SignatureValid = new Result();
        public static final /* enum */ Result SignatureInvalid = new Result();
        public static final /* enum */ Result VerifyError = new Result();
        private static final /* synthetic */ Result[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        @NotNull
        public static EnumEntries<Result> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultArray = new Result[]{Result.SignatureValid, Result.SignatureInvalid, Result.VerifyError};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

