/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.Signer;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.Feature;
import de.tsenger.vdstools.vds.VdsHeader;
import de.tsenger.vdstools.vds.VdsMessage;
import de.tsenger.vdstools.vds.VdsSignature;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlinx.datetime.LocalDate;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B#\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u00107\u001a\u0004\u0018\u0001042\u0006\u00108\u001a\u00020\u0011J\"\u00109\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R\u0011\u0010.\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010+R\u0011\u00100\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0013R\u0017\u00102\u001a\b\u0012\u0004\u0012\u000204038F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006;"}, d2={"Lde/tsenger/vdstools/vds/DigitalSeal;", "", "vdsHeader", "Lde/tsenger/vdstools/vds/VdsHeader;", "vdsMessage", "Lde/tsenger/vdstools/vds/VdsMessage;", "vdsSignature", "Lde/tsenger/vdstools/vds/VdsSignature;", "<init>", "(Lde/tsenger/vdstools/vds/VdsHeader;Lde/tsenger/vdstools/vds/VdsMessage;Lde/tsenger/vdstools/vds/VdsSignature;)V", "signer", "Lde/tsenger/vdstools/Signer;", "(Lde/tsenger/vdstools/vds/VdsHeader;Lde/tsenger/vdstools/vds/VdsMessage;Lde/tsenger/vdstools/Signer;)V", "log", "Lco/touchlab/kermit/Logger;", "log$1", "vdsType", "", "getVdsType", "()Ljava/lang/String;", "issuingCountry", "getIssuingCountry", "signerCertRef", "getSignerCertRef", "signerIdentifier", "getSignerIdentifier", "certificateReference", "getCertificateReference", "issuingDate", "Lkotlinx/datetime/LocalDate;", "getIssuingDate", "()Lkotlinx/datetime/LocalDate;", "sigDate", "getSigDate", "docFeatureRef", "", "getDocFeatureRef", "()B", "docTypeCat", "getDocTypeCat", "headerAndMessageBytes", "", "getHeaderAndMessageBytes", "()[B", "encoded", "getEncoded", "signatureBytes", "getSignatureBytes", "rawString", "getRawString", "featureList", "", "Lde/tsenger/vdstools/vds/Feature;", "getFeatureList", "()Ljava/util/List;", "getFeature", "feature", "createVdsSignature", "Companion", "vdstools"})
@SourceDebugExtension(value={"SMAP\nDigitalSeal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools/vds/DigitalSeal\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,137:1\n82#2,2:138\n84#2:149\n54#3,9:140\n*S KotlinDebug\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools/vds/DigitalSeal\n*L\n84#1:138,2\n84#1:149\n84#1:140,9\n*E\n"})
public final class DigitalSeal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log$1;
    @NotNull
    private final String vdsType;
    @NotNull
    private final VdsHeader vdsHeader;
    @NotNull
    private final VdsMessage vdsMessage;
    @Nullable
    private final VdsSignature vdsSignature;
    @NotNull
    private static final Logger log;

    @NotNull
    public final String getVdsType() {
        return this.vdsType;
    }

    private DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature) {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log$1 = Logger.Companion.withTag(string);
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = vdsSignature;
        this.vdsType = vdsHeader.getVdsType();
    }

    public DigitalSeal(@NotNull VdsHeader vdsHeader, @NotNull VdsMessage vdsMessage, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)vdsHeader, (String)"vdsHeader");
        Intrinsics.checkNotNullParameter((Object)vdsMessage, (String)"vdsMessage");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log$1 = Logger.Companion.withTag(string);
        this.vdsHeader = vdsHeader;
        this.vdsMessage = vdsMessage;
        this.vdsSignature = this.createVdsSignature(vdsHeader, vdsMessage, signer);
        this.vdsType = vdsHeader.getVdsType();
    }

    @NotNull
    public final String getIssuingCountry() {
        return this.vdsHeader.getIssuingCountry();
    }

    @NotNull
    public final String getSignerCertRef() {
        return this.vdsHeader.getSignerCertRef();
    }

    @Nullable
    public final String getSignerIdentifier() {
        return this.vdsHeader.getSignerIdentifier();
    }

    @Nullable
    public final String getCertificateReference() {
        return this.vdsHeader.getCertificateReference();
    }

    @Nullable
    public final LocalDate getIssuingDate() {
        return this.vdsHeader.getIssuingDate();
    }

    @Nullable
    public final LocalDate getSigDate() {
        return this.vdsHeader.getSigDate();
    }

    public final byte getDocFeatureRef() {
        return this.vdsHeader.getDocFeatureRef();
    }

    public final byte getDocTypeCat() {
        return this.vdsHeader.getDocTypeCat();
    }

    @NotNull
    public final byte[] getHeaderAndMessageBytes() {
        return ArraysKt.plus((byte[])this.vdsHeader.getEncoded(), (byte[])this.vdsMessage.getEncoded());
    }

    @NotNull
    public final byte[] getEncoded() {
        Object object;
        byte[] byArray;
        block3: {
            block2: {
                byArray = ArraysKt.plus((byte[])this.vdsHeader.getEncoded(), (byte[])this.vdsMessage.getEncoded());
                object = this.vdsSignature;
                if (object == null) break block2;
                byte[] byArray2 = ((VdsSignature)object).getEncoded();
                object = byArray2;
                if (byArray2 != null) break block3;
            }
            object = new byte[0];
        }
        return ArraysKt.plus((byte[])byArray, (byte[])object);
    }

    @NotNull
    public final byte[] getSignatureBytes() {
        VdsSignature vdsSignature = this.vdsSignature;
        Intrinsics.checkNotNull((Object)vdsSignature);
        return vdsSignature.getPlainSignatureBytes();
    }

    @NotNull
    public final String getRawString() {
        return DataEncoder.INSTANCE.encodeBase256(this.getEncoded());
    }

    @NotNull
    public final List<Feature> getFeatureList() {
        return this.vdsMessage.getFeatureList();
    }

    @Nullable
    public final Feature getFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.vdsMessage.getFeature(feature);
    }

    /*
     * WARNING - void declaration
     */
    private final VdsSignature createVdsSignature(VdsHeader vdsHeader, VdsMessage vdsMessage, Signer signer) {
        byte[] headerMessage = ArraysKt.plus((byte[])vdsHeader.getEncoded(), (byte[])vdsMessage.getEncoded());
        try {
            byte[] signatureBytes = signer.sign(headerMessage);
            return new VdsSignature(signatureBytes);
        }
        catch (Exception e) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log$1;
            String messageString$iv = "Signature creation failed: " + e.getMessage();
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            return null;
        }
    }

    public /* synthetic */ DigitalSeal(VdsHeader vdsHeader, VdsMessage vdsMessage, VdsSignature vdsSignature, DefaultConstructorMarker $constructor_marker) {
        this(vdsHeader, vdsMessage, vdsSignature);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(Companion.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        log = Logger.Companion.withTag(string);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/tsenger/vdstools/vds/DigitalSeal$Companion;", "", "<init>", "()V", "log", "Lco/touchlab/kermit/Logger;", "fromRawString", "Lde/tsenger/vdstools/vds/DigitalSeal;", "rawString", "", "fromByteArray", "rawBytes", "", "parseVdsSeal", "vdstools"})
    @SourceDebugExtension(value={"SMAP\nDigitalSeal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools/vds/DigitalSeal$Companion\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,137:1\n82#2,2:138\n84#2:149\n82#2,2:150\n84#2:161\n62#2,2:162\n64#2:173\n54#3,9:140\n54#3,9:152\n54#3,9:164\n*S KotlinDebug\n*F\n+ 1 DigitalSeal.kt\nde/tsenger/vdstools/vds/DigitalSeal$Companion\n*L\n97#1:138,2\n97#1:149\n107#1:150,2\n107#1:161\n115#1:162,2\n115#1:173\n97#1:140,9\n107#1:152,9\n115#1:164,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DigitalSeal fromRawString(@NotNull String rawString) {
            DigitalSeal seal;
            block2: {
                Intrinsics.checkNotNullParameter((Object)rawString, (String)"rawString");
                seal = null;
                try {
                    seal = this.parseVdsSeal(DataParser.INSTANCE.decodeBase256(rawString));
                }
                catch (Exception e) {
                    void this_$iv$iv;
                    void $this$iv;
                    Logger logger = log;
                    String messageString$iv = String.valueOf(e.getMessage());
                    Throwable throwable$iv = null;
                    String tag$iv = $this$iv.getTag();
                    boolean $i$f$e = false;
                    BaseLogger baseLogger = (BaseLogger)$this$iv;
                    Severity severity$iv$iv = Severity.Error;
                    boolean $i$f$log = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) break block2;
                    this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
                }
            }
            return seal;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DigitalSeal fromByteArray(@NotNull byte[] rawBytes) {
            DigitalSeal seal;
            block2: {
                Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
                seal = null;
                try {
                    seal = this.parseVdsSeal(rawBytes);
                }
                catch (Exception e) {
                    void this_$iv$iv;
                    void $this$iv;
                    Logger logger = log;
                    String messageString$iv = String.valueOf(e.getMessage());
                    Throwable throwable$iv = null;
                    String tag$iv = $this$iv.getTag();
                    boolean $i$f$e = false;
                    BaseLogger baseLogger = (BaseLogger)$this$iv;
                    Severity severity$iv$iv = Severity.Error;
                    boolean $i$f$log = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) break block2;
                    this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
                }
            }
            return seal;
        }

        /*
         * WARNING - void declaration
         */
        private final DigitalSeal parseVdsSeal(byte[] rawBytes) {
            void this_$iv$iv;
            void $this$iv;
            Buffer rawDataBuffer = new Buffer().write(rawBytes);
            Logger logger = log;
            String messageString$iv = "rawData: " + HexExtensionsKt.toHexString$default((byte[])rawBytes, null, (int)1, null);
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$v = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Verbose;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            VdsHeader vdsHeader = VdsHeader.Companion.fromBuffer(rawDataBuffer);
            VdsSignature vdsSignature = null;
            List<DerTlv> derTlvList = DataParser.INSTANCE.parseDerTLvs(rawDataBuffer.readByteArray());
            List featureList = new ArrayList(derTlvList.size() - 1);
            for (DerTlv derTlv : derTlvList) {
                if (derTlv.getTag() == -1) {
                    vdsSignature = VdsSignature.Companion.fromByteArray(derTlv.getEncoded());
                    continue;
                }
                featureList.add(derTlv);
            }
            VdsMessage vdsMessage = new VdsMessage(vdsHeader.getVdsType(), featureList);
            return new DigitalSeal(vdsHeader, vdsMessage, vdsSignature, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

