/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.DataParser;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.Feature;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0002\u0010\tB\u0011\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lde/tsenger/vdstools/vds/VdsMessage;", "", "<init>", "()V", "vdsType", "", "derTlvList", "", "Lde/tsenger/vdstools/asn1/DerTlv;", "(Ljava/lang/String;Ljava/util/List;)V", "builder", "Lde/tsenger/vdstools/vds/VdsMessage$Builder;", "(Lde/tsenger/vdstools/vds/VdsMessage$Builder;)V", "value", "getVdsType", "()Ljava/lang/String;", "encoded", "", "getEncoded", "()[B", "featureList", "Lde/tsenger/vdstools/vds/Feature;", "getFeatureList", "()Ljava/util/List;", "getFeature", "featureName", "Builder", "Companion", "vdstools"})
@SourceDebugExtension(value={"SMAP\nVdsMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VdsMessage.kt\nde/tsenger/vdstools/vds/VdsMessage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n295#2,2:76\n*S KotlinDebug\n*F\n+ 1 VdsMessage.kt\nde/tsenger/vdstools/vds/VdsMessage\n*L\n50#1:76,2\n*E\n"})
public final class VdsMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<DerTlv> derTlvList;
    private String vdsType;

    @NotNull
    public final String getVdsType() {
        String string = this.vdsType;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"vdsType");
        return null;
    }

    private VdsMessage() {
    }

    public VdsMessage(@NotNull String vdsType, @NotNull List<DerTlv> derTlvList) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter(derTlvList, (String)"derTlvList");
        this();
        this.vdsType = vdsType;
        this.derTlvList = derTlvList;
    }

    private VdsMessage(Builder builder) {
        this.derTlvList = builder.getDerTlvList();
        this.vdsType = builder.getVdsType();
    }

    @NotNull
    public final byte[] getEncoded() {
        Buffer buffer = new Buffer();
        List<DerTlv> list = this.derTlvList;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"derTlvList");
            list = null;
        }
        for (DerTlv feature : list) {
            buffer.write(feature.getEncoded());
        }
        return buffer.readByteArray();
    }

    @NotNull
    public final List<Feature> getFeatureList() {
        List featureList = new ArrayList();
        List<DerTlv> list = this.derTlvList;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"derTlvList");
            list = null;
        }
        for (DerTlv derTlv : list) {
            Feature feature = DataEncoder.INSTANCE.encodeDerTlv(this.getVdsType(), derTlv);
            if (feature == null) continue;
            featureList.add(feature);
        }
        return featureList;
    }

    @Nullable
    public final Feature getFeature(@NotNull String featureName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            Iterable $this$firstOrNull$iv = this.getFeatureList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Feature feature = (Feature)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)feature.getName(), (Object)featureName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public /* synthetic */ VdsMessage(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\r\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lde/tsenger/vdstools/vds/VdsMessage$Builder;", "", "vdsType", "", "<init>", "(Ljava/lang/String;)V", "getVdsType", "()Ljava/lang/String;", "derTlvList", "", "Lde/tsenger/vdstools/asn1/DerTlv;", "getDerTlvList", "()Ljava/util/List;", "addDocumentFeature", "T", "feature", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/vds/VdsMessage$Builder;", "build", "Lde/tsenger/vdstools/vds/VdsMessage;", "vdstools"})
    public static final class Builder {
        @NotNull
        private final String vdsType;
        @NotNull
        private final List<DerTlv> derTlvList;

        public Builder(@NotNull String vdsType) {
            Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
            this.vdsType = vdsType;
            this.derTlvList = new ArrayList(5);
        }

        @NotNull
        public final String getVdsType() {
            return this.vdsType;
        }

        @NotNull
        public final List<DerTlv> getDerTlvList() {
            return this.derTlvList;
        }

        @NotNull
        public final <T> Builder addDocumentFeature(@NotNull String feature, T value) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            DerTlv derTlv = DataEncoder.INSTANCE.encodeFeature(this.vdsType, feature, value);
            this.derTlvList.add(derTlv);
            return this;
        }

        @NotNull
        public final VdsMessage build() {
            return new VdsMessage(this, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools/vds/VdsMessage$Companion;", "", "<init>", "()V", "fromByteArray", "Lde/tsenger/vdstools/vds/VdsMessage;", "rawBytes", "", "vdsType", "", "vdstools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VdsMessage fromByteArray(@NotNull byte[] rawBytes, @NotNull String vdsType) {
            Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
            Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
            List<DerTlv> derTlvList = DataParser.INSTANCE.parseDerTLvs(rawBytes);
            return new VdsMessage(vdsType, derTlvList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

