/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.asn1.ASN1Encoder;
import de.tsenger.vdstools.asn1.DerTlv;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\r"}, d2={"Lde/tsenger/vdstools/vds/VdsSignature;", "", "plainSignatureBytes", "", "<init>", "([B)V", "getPlainSignatureBytes", "()[B", "derSignatureBytes", "getDerSignatureBytes", "encoded", "getEncoded", "Companion", "vdstools"})
public final class VdsSignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] plainSignatureBytes;
    public static final byte TAG = -1;

    public VdsSignature(@NotNull byte[] plainSignatureBytes) {
        Intrinsics.checkNotNullParameter((Object)plainSignatureBytes, (String)"plainSignatureBytes");
        this.plainSignatureBytes = plainSignatureBytes;
    }

    @NotNull
    public final byte[] getPlainSignatureBytes() {
        return this.plainSignatureBytes;
    }

    @NotNull
    public final byte[] getDerSignatureBytes() {
        byte[] byArray = this.plainSignatureBytes;
        int n = 0;
        int n2 = this.plainSignatureBytes.length / 2;
        byte[] r = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        byte[] byArray2 = this.plainSignatureBytes;
        n2 = this.plainSignatureBytes.length / 2;
        int n3 = this.plainSignatureBytes.length;
        byte[] s = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
        byte[] rEncoded = ASN1Encoder.INSTANCE.getDerInteger(r);
        byte[] sEncoded = ASN1Encoder.INSTANCE.getDerInteger(s);
        byte[][] byArrayArray = new byte[][]{rEncoded, sEncoded};
        byte[] derSignatureBytes = ASN1Encoder.INSTANCE.getDerSequence(byArrayArray);
        return derSignatureBytes;
    }

    @NotNull
    public final byte[] getEncoded() {
        DerTlv derSignature = new DerTlv(-1, this.plainSignatureBytes);
        return derSignature.getEncoded();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools/vds/VdsSignature$Companion;", "", "<init>", "()V", "TAG", "", "fromByteArray", "Lde/tsenger/vdstools/vds/VdsSignature;", "rawBytes", "", "vdstools"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VdsSignature fromByteArray(@NotNull byte[] rawBytes) {
            Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
            if (!(rawBytes[0] == -1)) {
                boolean bl = false;
                String string = Integer.toString(-1, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String string3 = Integer.toString(rawBytes[0], CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                String string4 = StringsKt.padStart((String)string3, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                String string5 = "VdsSignature shall have tag " + string2 + ", but tag " + string4 + " was found instead.";
                throw new IllegalArgumentException(string5.toString());
            }
            DerTlv derTlv = DerTlv.Companion.fromByteArray(rawBytes);
            return derTlv != null ? new VdsSignature(derTlv.getValue()) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

