/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/tsenger/vdstools/Base32;", "", "<init>", "()V", "ALPHABET", "", "PADDING", "", "CHAR_TO_VALUE", "", "encode", "input", "", "decode", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nde/tsenger/vdstools/Base32\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,54:1\n13409#2,2:55\n1179#3,2:57\n1188#3,3:59\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nde/tsenger/vdstools/Base32\n*L\n17#1:55,2\n41#1:57,2\n8#1:59,3\n*E\n"})
public final class Base32 {
    @NotNull
    public static final Base32 INSTANCE;
    @NotNull
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final char PADDING = '=';
    @NotNull
    private static final int[] CHAR_TO_VALUE;

    private Base32() {
    }

    @NotNull
    public final String encode(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StringBuilder output = new StringBuilder();
        int buffer = 0;
        int bitsLeft = 0;
        byte[] $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte by = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            buffer = buffer << 8 | by & 0xFF;
            bitsLeft += 8;
            while (bitsLeft >= 5) {
                int index = buffer >> bitsLeft - 5 & 0x1F;
                output.append(ALPHABET.charAt(index));
                bitsLeft -= 5;
            }
        }
        if (bitsLeft > 0) {
            int index = buffer << 5 - bitsLeft & 0x1F;
            output.append(ALPHABET.charAt(index));
        }
        while (output.length() % 8 != 0) {
            output.append('=');
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final byte[] decode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        char[] cArray = new char[]{'='};
        String cleanedInput = StringsKt.trimEnd((String)input, (char[])cArray);
        List output = new ArrayList();
        int buffer = 0;
        int bitsLeft = 0;
        CharSequence $this$forEach$iv = cleanedInput;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            int value = CHAR_TO_VALUE[c];
            if (value == -1) {
                throw new IllegalArgumentException("Invalid Base32 character: " + c);
            }
            buffer = buffer << 5 | value;
            if ((bitsLeft += 5) < 8) continue;
            output.add((byte)(buffer >> bitsLeft - 8));
            bitsLeft -= 8;
        }
        return CollectionsKt.toByteArray((Collection)output);
    }

    static {
        int[] nArray;
        INSTANCE = new Base32();
        int n = 0;
        int[] nArray2 = new int[256];
        while (n < 256) {
            int n2 = n++;
            nArray2[n2] = -1;
        }
        int[] $this$CHAR_TO_VALUE_u24lambda_u241 = nArray = nArray2;
        boolean bl = false;
        CharSequence $this$forEachIndexed$iv = ALPHABET;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n3 = index$iv++;
            char c = item$iv;
            int index = n3;
            boolean bl2 = false;
            $this$CHAR_TO_VALUE_u24lambda_u241[char] = index;
        }
        CHAR_TO_VALUE = nArray;
    }
}

