/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.FeatureConverter;
import de.tsenger.vdstools.IdbMessageTypeParser;
import de.tsenger.vdstools.IdbNationalDocumentTypeParser;
import de.tsenger.vdstools.ReadTextResource_jvmKt;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.Feature;
import de.tsenger.vdstools.vds.FeatureCoding;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.SHA1;
import dev.whyoleg.cryptography.operations.Hasher;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import okio.Buffer;
import okio.DeflaterSink;
import okio.InflaterSource;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rJ\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\rJ\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u00100\u001a\u00020\u001eJ\u0015\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u00020\u000f\u00a2\u0006\u0002\u00102J)\u00103\u001a\u00020.\"\u0004\b\u0000\u001042\u0006\u0010,\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u0002H4\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u001eJ\u0015\u00109\u001a\u0004\u0018\u00010\u001e2\u0006\u0010:\u001a\u00020\u000f\u00a2\u0006\u0002\u00102J\u000e\u0010;\u001a\u00020<2\u0006\u0010:\u001a\u00020\u000fJ\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001eJ\u000e\u0010>\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u001eJ\u000e\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\rJ\u000e\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\rJ\u000e\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\rJ\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020.0F2\u0006\u0010G\u001a\u00020\rJ\u0010\u0010H\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020IH\u0002J\u000e\u0010J\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\rJ\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020\u001eH\u0002J\u000e\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u000fJ\u000e\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lde/tsenger/vdstools/DataEncoder;", "", "<init>", "()V", "featureEncoder", "Lde/tsenger/vdstools/FeatureConverter;", "idbMessageTypeParser", "Lde/tsenger/vdstools/IdbMessageTypeParser;", "idbDocumentTypeParser", "Lde/tsenger/vdstools/IdbNationalDocumentTypeParser;", "log", "Lco/touchlab/kermit/Logger;", "encodeDate", "", "dateString", "", "localDate", "Lkotlinx/datetime/LocalDate;", "encodeDateTime", "localDatetime", "Lkotlinx/datetime/LocalDateTime;", "numberToByteArray", "value", "", "encodeMaskedDate", "encodeC40", "string", "formatMRZ", "mrzString", "mrzLength", "", "getC40Value", "c", "", "encodeBase256", "ba", "zip", "bytesToCompress", "setFeatureEncoder", "", "buildCertificateReference", "certificateBytes", "encodeDerTlv", "Lde/tsenger/vdstools/vds/Feature;", "vdsType", "derTlv", "Lde/tsenger/vdstools/asn1/DerTlv;", "getVdsType", "documentRef", "getDocumentRef", "(Ljava/lang/String;)Ljava/lang/Integer;", "encodeFeature", "T", "feature", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/asn1/DerTlv;", "getIdbMessageTypeName", "tag", "getIdbMessageTypeTag", "messageTypeName", "getIdbMessageTypeCoding", "Lde/tsenger/vdstools/vds/FeatureCoding;", "messageTypeTag", "getIdbDocumentTypeName", "decodeMaskedDate", "maskedDateBytes", "decodeDate", "dateBytes", "decodeDateTime", "dateTimeBytes", "parseDerTLvs", "", "rawBytes", "toUnsignedInt", "", "decodeC40", "bytes", "toChar", "intValue", "decodeBase256", "s", "unzip", "bytesToDecompress", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nDataEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataEncoder.kt\nde/tsenger/vdstools/DataEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nco/touchlab/kermit/Logger\n+ 4 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,506:1\n1#2:507\n67#3,2:508\n69#3:519\n82#3,2:520\n84#3:531\n82#3,2:532\n84#3:543\n54#4,9:510\n54#4,9:522\n54#4,9:534\n*S KotlinDebug\n*F\n+ 1 DataEncoder.kt\nde/tsenger/vdstools/DataEncoder\n*L\n262#1:508,2\n262#1:519\n420#1:520,2\n420#1:531\n30#1:532,2\n30#1:543\n262#1:510,9\n420#1:522,9\n30#1:534,9\n*E\n"})
public final class DataEncoder {
    @NotNull
    public static final DataEncoder INSTANCE = new DataEncoder();
    private static FeatureConverter featureEncoder;
    private static IdbMessageTypeParser idbMessageTypeParser;
    private static IdbNationalDocumentTypeParser idbDocumentTypeParser;
    @NotNull
    private static final Logger log;

    private DataEncoder() {
    }

    @NotNull
    public final byte[] encodeDate(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        LocalDate dt = LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)dateString, null, (int)2, null);
        return this.encodeDate(dt);
    }

    @NotNull
    public final byte[] encodeDate(@Nullable LocalDate localDate) {
        if (localDate == null) {
            return new byte[3];
        }
        String formattedDate = StringsKt.padStart((String)String.valueOf(localDate.getMonthNumber()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDate.getDayOfMonth()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDate.getYear()), (int)4, (char)'0');
        int dateInt = Integer.parseInt(formattedDate);
        return this.numberToByteArray(dateInt);
    }

    @NotNull
    public final byte[] encodeDateTime(@NotNull LocalDateTime localDatetime) {
        Intrinsics.checkNotNullParameter((Object)localDatetime, (String)"localDatetime");
        String formattedDateTime = StringsKt.padStart((String)String.valueOf(localDatetime.getMonthNumber()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getDayOfMonth()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getYear()), (int)4, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getHour()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getMinute()), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(localDatetime.getSecond()), (int)2, (char)'0');
        long dateInt = Long.parseLong(formattedDateTime);
        return this.numberToByteArray(dateInt);
    }

    private final byte[] numberToByteArray(Number value) {
        byte[] byArray;
        Number number = value;
        if (number instanceof Long) {
            int n = 0;
            byte[] byArray2 = new byte[8];
            while (n < 8) {
                int n2 = n++;
                byArray2[n2] = (byte)(value.longValue() >> 8 * (7 - n2) & 0xFFL);
            }
            byte[] byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])byArray2, (int)6));
            n = 0;
            int n3 = 6 - byteArray.length;
            byte[] byArray3 = new byte[n3];
            while (n < n3) {
                int n4 = n++;
                byArray3[n4] = 0;
            }
            byArray = ArraysKt.plus((byte[])byArray3, (byte[])byteArray);
        } else if (number instanceof Integer) {
            int n = 0;
            byte[] byArray4 = new byte[4];
            while (n < 4) {
                int n5 = n++;
                byArray4[n5] = (byte)(value.intValue() >> 8 * (3 - n5) & 0xFF);
            }
            byte[] byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])byArray4, (int)3));
            n = 0;
            int n6 = 3 - byteArray.length;
            byte[] byArray5 = new byte[n6];
            while (n < n6) {
                int n7 = n++;
                byArray5[n7] = 0;
            }
            byArray = ArraysKt.plus((byte[])byArray5, (byte[])byteArray);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(value.getClass()));
        }
        return byArray;
    }

    @NotNull
    public final byte[] encodeMaskedDate(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        CharSequence charSequence = dateString;
        if (!new Regex("(.{4})-(.{2})-(.{2})").matches(charSequence)) {
            boolean $i$a$-require-DataEncoder$encodeMaskedDate$22 = false;
            String $i$a$-require-DataEncoder$encodeMaskedDate$22 = "Date string must be formated as yyyy-MM-dd.";
            throw new IllegalArgumentException($i$a$-require-DataEncoder$encodeMaskedDate$22.toString());
        }
        CharSequence $i$a$-require-DataEncoder$encodeMaskedDate$22 = dateString;
        Object object = new Regex("(.{4})-(.{2})-(.{2})");
        String string = "$2$3$1";
        String string2 = object.replace($i$a$-require-DataEncoder$encodeMaskedDate$22, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String formattedDate = string2;
        object = formattedDate;
        string = new Regex("x");
        String string3 = "0";
        int dateInt = Integer.parseInt(string.replace((CharSequence)object, string3));
        char[] cArray = formattedDate.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] dateCharArray = cArray;
        byte mask = 0;
        for (int i = 0; i < 8; ++i) {
            if (dateCharArray[i] != 'x') continue;
            mask = (byte)(mask | 128 >> i);
        }
        byte[] byArray = new byte[]{mask, (byte)(dateInt >>> 16), (byte)(dateInt >>> 8), (byte)dateInt};
        return byArray;
    }

    @NotNull
    public final byte[] encodeC40(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String dataString = string;
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int sum = 0;
        Buffer out = new Buffer();
        String string2 = dataString.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        CharSequence charSequence = StringsKt.replace$default((String)string2, (String)"<", (String)" ", (boolean)false, (int)4, null);
        Regex regex = new Regex("\r");
        String string3 = "";
        charSequence = regex.replace(charSequence, string3);
        regex = new Regex("\n");
        string3 = "";
        dataString = regex.replace(charSequence, string3);
        int len = dataString.length();
        for (int i = 0; i < len; ++i) {
            Buffer buffer;
            if (i % 3 != 0) continue;
            if (i + 2 < len) {
                c1 = this.getC40Value(dataString.charAt(i));
                c2 = this.getC40Value(dataString.charAt(i + 1));
                c3 = this.getC40Value(dataString.charAt(i + 2));
                sum = 1600 * c1 + 40 * c2 + c3 + 1;
                out.writeByte(sum / 256);
                buffer = out.writeByte(sum % 256);
                continue;
            }
            if (i + 1 < len) {
                c1 = this.getC40Value(dataString.charAt(i));
                c2 = this.getC40Value(dataString.charAt(i + 1));
                sum = 1600 * c1 + 40 * c2 + 1;
                out.writeByte(sum / 256);
                buffer = out.writeByte(sum % 256);
                continue;
            }
            out.writeByte(254);
            buffer = out.writeByte(this.toUnsignedInt((byte)dataString.charAt(i)) + 1);
        }
        return out.readByteArray();
    }

    @NotNull
    public final String formatMRZ(@NotNull String mrzString, int mrzLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mrzString, (String)"mrzString");
        String paddedMrz = StringsKt.replace$default((String)StringsKt.padEnd((String)mrzString, (int)mrzLength, (char)'<'), (char)' ', (char)'<', (boolean)false, (int)4, null);
        if (mrzLength == 90) {
            String string2 = paddedMrz.substring(0, 30);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = paddedMrz.substring(30, 60);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String string4 = paddedMrz.substring(60, 90);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = string2 + "\n" + string3 + "\n" + string4;
        } else {
            String string5 = paddedMrz.substring(0, mrzLength / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String string6 = paddedMrz.substring(mrzLength / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = string5 + "\n" + string6;
        }
        return string;
    }

    private final int getC40Value(char c) {
        int n;
        int value = this.toUnsignedInt((byte)c);
        if (value == 32) {
            n = 3;
        } else {
            boolean bl = 48 <= value ? value < 58 : false;
            if (bl) {
                n = value - 44;
            } else {
                boolean bl2 = 65 <= value ? value < 91 : false;
                if (bl2) {
                    n = value - 51;
                } else {
                    throw new IllegalArgumentException("Not a C40 encodable char: " + c + "value: " + value);
                }
            }
        }
        return n;
    }

    @NotNull
    public final String encodeBase256(@NotNull byte[] ba) {
        Intrinsics.checkNotNullParameter((Object)ba, (String)"ba");
        char[] ca = new char[ba.length];
        int n = ba.length;
        for (int i = 0; i < n; ++i) {
            ca[i] = (char)(ba[i] & 0xFF);
        }
        return StringsKt.concatToString((char[])ca);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] zip(@NotNull byte[] bytesToCompress) {
        void this_$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)bytesToCompress, (String)"bytesToCompress");
        Buffer outputBuffer = new Buffer();
        Buffer inputBuffer = new Buffer().write(bytesToCompress);
        DeflaterSink compressor = new DeflaterSink((Sink)outputBuffer, new Deflater(9, false));
        compressor.write(inputBuffer, inputBuffer.size());
        compressor.close();
        byte[] compressedBytes = outputBuffer.readByteArray();
        Logger logger = log;
        String string = "Zip ratio " + (float)bytesToCompress.length / (float)compressedBytes.length + ", input size " + bytesToCompress.length + ", compressed size " + compressedBytes.length;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            void messageString$iv;
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, (String)messageString$iv);
        }
        return compressedBytes;
    }

    public final void setFeatureEncoder(@NotNull FeatureConverter featureEncoder) {
        Intrinsics.checkNotNullParameter((Object)featureEncoder, (String)"featureEncoder");
        DataEncoder.featureEncoder = featureEncoder;
    }

    @NotNull
    public final byte[] buildCertificateReference(@NotNull byte[] certificateBytes) {
        Intrinsics.checkNotNullParameter((Object)certificateBytes, (String)"certificateBytes");
        Hasher hasher = ((Digest)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)SHA1.INSTANCE)).hasher();
        byte[] certSha12 = (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(hasher, certificateBytes, null){
            int label;
            final /* synthetic */ Hasher $hasher;
            final /* synthetic */ byte[] $certificateBytes;
            {
                this.$hasher = $hasher;
                this.$certificateBytes = $certificateBytes;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$hasher.hash(this.$certificateBytes, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return ArraysKt.sliceArray((byte[])certSha12, (IntRange)new IntRange(15, 19));
    }

    @Nullable
    public final Feature encodeDerTlv(@NotNull String vdsType, @NotNull DerTlv derTlv) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        byte[] value = derTlv.getValue();
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        String name = featureConverter.getFeatureName(vdsType, derTlv);
        byte tag = derTlv.getTag();
        FeatureConverter featureConverter2 = featureEncoder;
        if (featureConverter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter2 = null;
        }
        FeatureCoding coding = featureConverter2.getFeatureCoding(vdsType, derTlv);
        if (Intrinsics.areEqual((Object)name, (Object)"") || coding == FeatureCoding.UNKNOWN) {
            return null;
        }
        return new Feature(tag, name, value, coding);
    }

    @Nullable
    public final String getVdsType(int documentRef) {
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        return featureConverter.getVdsType(documentRef);
    }

    @Nullable
    public final Integer getDocumentRef(@NotNull String vdsType) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        return featureConverter.getDocumentRef(vdsType);
    }

    @NotNull
    public final <T> DerTlv encodeFeature(@NotNull String vdsType, @NotNull String feature, T value) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        FeatureConverter featureConverter = featureEncoder;
        if (featureConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureEncoder");
            featureConverter = null;
        }
        return featureConverter.encodeFeature(vdsType, feature, value);
    }

    @NotNull
    public final String getIdbMessageTypeName(int tag) {
        IdbMessageTypeParser idbMessageTypeParser = DataEncoder.idbMessageTypeParser;
        if (idbMessageTypeParser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idbMessageTypeParser");
            idbMessageTypeParser = null;
        }
        return idbMessageTypeParser.getMessageType(tag);
    }

    @Nullable
    public final Integer getIdbMessageTypeTag(@NotNull String messageTypeName) {
        Intrinsics.checkNotNullParameter((Object)messageTypeName, (String)"messageTypeName");
        IdbMessageTypeParser idbMessageTypeParser = DataEncoder.idbMessageTypeParser;
        if (idbMessageTypeParser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idbMessageTypeParser");
            idbMessageTypeParser = null;
        }
        return idbMessageTypeParser.getMessageType(messageTypeName);
    }

    @NotNull
    public final FeatureCoding getIdbMessageTypeCoding(@NotNull String messageTypeName) {
        Intrinsics.checkNotNullParameter((Object)messageTypeName, (String)"messageTypeName");
        IdbMessageTypeParser idbMessageTypeParser = DataEncoder.idbMessageTypeParser;
        if (idbMessageTypeParser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idbMessageTypeParser");
            idbMessageTypeParser = null;
        }
        return idbMessageTypeParser.getMessageTypeCoding(messageTypeName);
    }

    @NotNull
    public final FeatureCoding getIdbMessageTypeCoding(int messageTypeTag) {
        IdbMessageTypeParser idbMessageTypeParser = DataEncoder.idbMessageTypeParser;
        if (idbMessageTypeParser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idbMessageTypeParser");
            idbMessageTypeParser = null;
        }
        return idbMessageTypeParser.getMessageTypeCoding(messageTypeTag);
    }

    @NotNull
    public final String getIdbDocumentTypeName(int tag) {
        IdbNationalDocumentTypeParser idbNationalDocumentTypeParser = idbDocumentTypeParser;
        if (idbNationalDocumentTypeParser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idbDocumentTypeParser");
            idbNationalDocumentTypeParser = null;
        }
        return idbNationalDocumentTypeParser.getDocumentType(tag);
    }

    @NotNull
    public final String decodeMaskedDate(@NotNull byte[] maskedDateBytes) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)maskedDateBytes, (String)"maskedDateBytes");
        if (!(maskedDateBytes.length == 4)) {
            boolean $i$a$-require-DataEncoder$decodeMaskedDate$22 = false;
            String $i$a$-require-DataEncoder$decodeMaskedDate$22 = "expected four bytes for masked date decoding";
            throw new IllegalArgumentException($i$a$-require-DataEncoder$decodeMaskedDate$22.toString());
        }
        byte mask = maskedDateBytes[0];
        long intval = (long)this.toUnsignedInt(maskedDateBytes[1]) * (long)256 * (long)256 + (long)this.toUnsignedInt(maskedDateBytes[2]) * 256L + (long)this.toUnsignedInt(maskedDateBytes[3]);
        int day = (int)(intval % (long)1000000 / (long)10000);
        int month = (int)(intval / (long)1000000);
        int year = (int)(intval % (long)10000);
        char[] cArray = (StringsKt.padStart((String)String.valueOf(month), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(day), (int)2, (char)'0') + StringsKt.padStart((String)String.valueOf(year), (int)4, (char)'0')).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] dateCharArray = cArray;
        for (int i = 0; i < 8; ++i) {
            byte unknownBit = (byte)(mask >> 7 - i & 1);
            if (unknownBit != 1) continue;
            dateCharArray[i] = 120;
        }
        String dateString = StringsKt.concatToString((char[])dateCharArray);
        CharSequence charSequence = dateString;
        Regex regex = new Regex("(.{2})(.{2})(.{4})");
        String string = "$3-$1-$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @NotNull
    public final LocalDate decodeDate(@NotNull byte[] dateBytes) {
        Intrinsics.checkNotNullParameter((Object)dateBytes, (String)"dateBytes");
        if (!(dateBytes.length == 3)) {
            boolean bl = false;
            String string = "expected three bytes for date decoding";
            throw new IllegalArgumentException(string.toString());
        }
        long intval = (long)this.toUnsignedInt(dateBytes[0]) * (long)256 * (long)256 + (long)this.toUnsignedInt(dateBytes[1]) * 256L + (long)this.toUnsignedInt(dateBytes[2]);
        int day = (int)(intval % (long)1000000 / (long)10000);
        int month = (int)(intval / (long)1000000);
        int year = (int)(intval % (long)10000);
        return new LocalDate(year, month, day);
    }

    @NotNull
    public final LocalDateTime decodeDateTime(@NotNull byte[] dateTimeBytes) {
        Intrinsics.checkNotNullParameter((Object)dateTimeBytes, (String)"dateTimeBytes");
        if (!(dateTimeBytes.length == 6)) {
            boolean bl = false;
            String string = "Expected six bytes for date decoding";
            throw new IllegalArgumentException(string.toString());
        }
        long dateTimeLong = 0L;
        for (byte by : dateTimeBytes) {
            dateTimeLong = dateTimeLong << 8 | (long)by & 0xFFL;
        }
        String paddedDateString = StringsKt.padStart((String)String.valueOf(dateTimeLong), (int)14, (char)'0');
        String string = paddedDateString.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int month = Integer.parseInt(string);
        String string2 = paddedDateString.substring(2, 4);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int day = Integer.parseInt(string2);
        String string3 = paddedDateString.substring(4, 8);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        int year = Integer.parseInt(string3);
        String string4 = paddedDateString.substring(8, 10);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        int hour = Integer.parseInt(string4);
        String string5 = paddedDateString.substring(10, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        int minute = Integer.parseInt(string5);
        String string6 = paddedDateString.substring(12, 14);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        int second = Integer.parseInt(string6);
        return new LocalDateTime(year, month, day, hour, minute, second, 0, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DerTlv> parseDerTLvs(@NotNull byte[] rawBytes) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
        Buffer dataBuffer = new Buffer().write(rawBytes);
        List derTlvList = new ArrayList();
        while (!dataBuffer.exhausted()) {
            byte tag = dataBuffer.readByte();
            int le = dataBuffer.readByte() & 0xFF;
            if (le == 129) {
                le = dataBuffer.readByte() & 0xFF;
            } else if (le == 130) {
                le = (dataBuffer.readByte() & 0xFF) * 256 + (dataBuffer.readByte() & 0xFF);
            } else if (le == 131) {
                le = (dataBuffer.readByte() & 0xFF) * 4096 + (dataBuffer.readByte() & 0xFF) * 256 + (dataBuffer.readByte() & 0xFF);
            } else if (le > 127) {
                void this_$iv$iv;
                void $this$iv;
                Logger logger = log;
                String string = Integer.toString(le, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String string3 = "Can't decode length: " + string2;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$e = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Error;
                boolean $i$f$log = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    void messageString$iv;
                    this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, (String)messageString$iv);
                }
                String string4 = Integer.toString(le, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                String string5 = StringsKt.padStart((String)string4, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                throw new IllegalArgumentException("Can't decode length: " + string5);
            }
            byte[] value = dataBuffer.readByteArray((long)le);
            derTlvList.add(new DerTlv(tag, value));
        }
        return derTlvList;
    }

    private final int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    @NotNull
    public final String decodeC40(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        StringBuilder sb = new StringBuilder();
        int n = bytes.length;
        for (int idx = 0; idx < n; ++idx) {
            int temp;
            if (idx % 2 != 0) continue;
            byte i1 = bytes[idx];
            byte i2 = bytes[idx + 1];
            if (i1 == -2) {
                sb.append((char)(i2 - 1));
                continue;
            }
            int v16 = (this.toUnsignedInt(i1) << 8) + this.toUnsignedInt(i2) - 1;
            int u1 = temp = v16 / 1600;
            v16 -= temp * 1600;
            int u2 = temp = v16 / 40;
            int u3 = v16 - temp * 40;
            if (u1 != 0) {
                sb.append(this.toChar(u1));
            }
            if (u2 != 0) {
                sb.append(this.toChar(u2));
            }
            if (u3 == 0) continue;
            sb.append(this.toChar(u3));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final char toChar(int intValue) {
        char c;
        block1: {
            int n;
            block0: {
                n = intValue;
                if (n != 3) break block0;
                c = ' ';
                break block1;
            }
            c = (4 <= n ? n < 14 : false) ? (char)(intValue + 44) : ((14 <= n ? n < 40 : false) ? (char)(intValue + 51) : (char)63);
        }
        return c;
    }

    @NotNull
    public final byte[] decodeBase256(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        char[] cArray = s.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] ca = cArray;
        byte[] ba = new byte[ca.length];
        int n = ba.length;
        for (int i = 0; i < n; ++i) {
            ba[i] = (byte)ca[i];
        }
        return ba;
    }

    @NotNull
    public final byte[] unzip(@NotNull byte[] bytesToDecompress) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
        Buffer inputBuffer = new Buffer().write(bytesToDecompress);
        InflaterSource inflaterSource = new InflaterSource((Source)inputBuffer, new Inflater());
        Buffer $this$unzip_u24lambda_u244 = buffer = new Buffer();
        boolean bl = false;
        $this$unzip_u24lambda_u244.writeAll((Source)inflaterSource);
        byte[] decompressedBytes = buffer.readByteArray();
        return decompressedBytes;
    }

    /*
     * WARNING - void declaration
     */
    static {
        String string = Reflection.getOrCreateKotlinClass(INSTANCE.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        log = Logger.Companion.withTag(string);
        try {
            featureEncoder = new FeatureConverter(ReadTextResource_jvmKt.readTextResource("SealCodings.json"));
            idbMessageTypeParser = new IdbMessageTypeParser(ReadTextResource_jvmKt.readTextResource("IdbMessageTypes.json"));
            idbDocumentTypeParser = new IdbNationalDocumentTypeParser(ReadTextResource_jvmKt.readTextResource("IdbNationalDocumentTypes.json"));
        }
        catch (FileNotFoundException e) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = log;
            String messageString$iv = "JSON file not available: " + e.getMessage();
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            System.out.println((Object)("JSON file not available: " + e.getMessage()));
        }
    }
}

