/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.FeatureCoding;
import de.tsenger.vdstools.vds.dto.FeaturesDto;
import de.tsenger.vdstools.vds.dto.SealDto;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0015\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\rJ\u0016\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J)\u0010$\u001a\u00020!\"\u0004\b\u0000\u0010%2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u0002H%\u00a2\u0006\u0002\u0010(J+\u0010$\u001a\u00020!\"\u0004\b\u0000\u0010%2\u0006\u0010)\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u0002H%H\u0002\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\n2\u0006\u0010-\u001a\u00020\rH\u0002J\u0018\u0010.\u001a\u00020#2\u0006\u0010)\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u0010.\u001a\u00020#2\u0006\u0010)\u001a\u00020\n2\u0006\u0010-\u001a\u00020,H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020\n2\u0006\u0010-\u001a\u00020,H\u0002J\u0010\u00101\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00062"}, d2={"Lde/tsenger/vdstools/FeatureConverter;", "", "jsonString", "", "<init>", "(Ljava/lang/String;)V", "log", "Lco/touchlab/kermit/Logger;", "sealDtoList", "", "Lde/tsenger/vdstools/vds/dto/SealDto;", "vdsTypes", "", "", "vdsTypesReverse", "vdsFeatures", "", "populateMappings", "", "availableVdsTypes", "getAvailableVdsTypes", "()Ljava/util/List;", "getDocumentRef", "vdsType", "(Ljava/lang/String;)Ljava/lang/Integer;", "getVdsType", "docRef", "availableVdsFeatures", "", "getAvailableVdsFeatures", "()Ljava/util/Set;", "getFeatureName", "derTlv", "Lde/tsenger/vdstools/asn1/DerTlv;", "getFeatureCoding", "Lde/tsenger/vdstools/vds/FeatureCoding;", "encodeFeature", "T", "feature", "inputValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/asn1/DerTlv;", "sealDto", "(Lde/tsenger/vdstools/vds/dto/SealDto;Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/asn1/DerTlv;", "getTag", "", "tag", "getCoding", "getFeatureDto", "Lde/tsenger/vdstools/vds/dto/FeaturesDto;", "getSealDto", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nFeatureConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureConverter.kt\nde/tsenger/vdstools/FeatureConverter\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\nco/touchlab/kermit/Logger\n+ 5 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,175:1\n147#2:176\n1863#3,2:177\n77#4,2:179\n79#4:190\n77#4,2:191\n79#4:202\n77#4,2:203\n79#4:214\n77#4,2:215\n79#4:226\n77#4,2:227\n79#4:238\n54#5,9:181\n54#5,9:193\n54#5,9:205\n54#5,9:217\n54#5,9:229\n*S KotlinDebug\n*F\n+ 1 FeatureConverter.kt\nde/tsenger/vdstools/FeatureConverter\n*L\n22#1:176\n32#1:177,2\n53#1:179,2\n53#1:190\n63#1:191,2\n63#1:202\n75#1:203,2\n75#1:214\n79#1:215,2\n79#1:226\n90#1:227,2\n90#1:238\n53#1:181,9\n63#1:193,9\n75#1:205,9\n79#1:217,9\n90#1:229,9\n*E\n"})
public final class FeatureConverter {
    @NotNull
    private final Logger log;
    @NotNull
    private List<SealDto> sealDtoList;
    @NotNull
    private final Map<String, Integer> vdsTypes;
    @NotNull
    private final Map<Integer, String> vdsTypesReverse;
    @NotNull
    private final Set<String> vdsFeatures;

    public FeatureConverter(@NotNull String jsonString) {
        Json json;
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log = Logger.Companion.withTag(string);
        this.vdsTypes = new HashMap();
        this.vdsTypesReverse = new HashMap();
        this.vdsFeatures = new LinkedHashSet();
        Json this_$iv = json = JsonKt.Json$default(null, FeatureConverter::_init_$lambda$0, (int)1, null);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        this.sealDtoList = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SealDto.Companion.serializer()), jsonString);
        this.populateMappings();
    }

    private final void populateMappings() {
        for (SealDto sealDto : this.sealDtoList) {
            String documentType = sealDto.component1();
            String documentRef = sealDto.component2();
            List<FeaturesDto> features = sealDto.component4();
            if (!Intrinsics.areEqual((Object)documentType, (Object)"") && !Intrinsics.areEqual((Object)documentRef, (Object)"")) {
                this.vdsTypes.put(documentType, Integer.parseInt(documentRef, CharsKt.checkRadix((int)16)));
                this.vdsTypesReverse.put(Integer.parseInt(documentRef, CharsKt.checkRadix((int)16)), documentType);
            }
            Iterable $this$forEach$iv = features;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FeaturesDto it = (FeaturesDto)element$iv;
                boolean bl = false;
                this.vdsFeatures.add(it.getName());
            }
        }
    }

    @NotNull
    public final List<String> getAvailableVdsTypes() {
        return CollectionsKt.toList((Iterable)this.vdsTypes.keySet());
    }

    @Nullable
    public final Integer getDocumentRef(@NotNull String vdsType) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        return this.vdsTypes.get(vdsType);
    }

    @Nullable
    public final String getVdsType(int docRef) {
        return this.vdsTypesReverse.get(docRef);
    }

    @NotNull
    public final Set<String> getAvailableVdsFeatures() {
        return this.vdsFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFeatureName(@NotNull String vdsType, @NotNull DerTlv derTlv) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        if (!this.vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No seal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        return this.getFeatureName(sealDto, derTlv.getTag());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeatureCoding getFeatureCoding(@NotNull String vdsType, @NotNull DerTlv derTlv) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
        if (!this.vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No seal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        byte tag = derTlv.getTag();
        return this.getCoding(sealDto, tag);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> DerTlv encodeFeature(@NotNull String vdsType, @NotNull String feature, T inputValue) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        if (!this.vdsTypes.containsKey(vdsType)) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "No VdsSeal type with name '" + vdsType + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No seal type with name '" + vdsType + "' was found.");
        }
        if (!this.vdsFeatures.contains(feature)) {
            Logger $this$iv = this.log;
            String messageString$iv = "No VdsSeal feature with name '" + feature + "' was found.";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger this_$iv$iv = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("No VdsSeal feature with name '" + feature + "' was found.");
        }
        SealDto sealDto = this.getSealDto(vdsType);
        return this.encodeFeature(sealDto, feature, inputValue);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DerTlv encodeFeature(SealDto sealDto, String feature, T inputValue) throws IllegalArgumentException {
        byte tag = this.getTag(sealDto, feature);
        if (tag == 0) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = this.log;
            String messageString$iv = "VdsType: " + sealDto.getDocumentType() + " has no Feature " + feature;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            throw new IllegalArgumentException("VdsType: " + sealDto.getDocumentType() + " has no Feature " + feature);
        }
        FeatureCoding coding = this.getCoding(sealDto, feature);
        byte[] value = null;
        switch (WhenMappings.$EnumSwitchMapping$0[coding.ordinal()]) {
            case 1: 
            case 2: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.String");
                String valueStr = (String)inputValue;
                value = DataEncoder.INSTANCE.encodeC40(valueStr);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.String");
                value = StringsKt.encodeToByteArray((String)((String)inputValue));
                break;
            }
            case 4: {
                byte[] byArray = new byte[1];
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.Byte");
                byArray[0] = (Byte)inputValue;
                value = byArray;
                break;
            }
            case 5: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                value = (byte[])inputValue;
                break;
            }
            case 6: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.String");
                value = DataEncoder.INSTANCE.encodeMaskedDate((String)inputValue);
                break;
            }
            case 7: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.String");
                value = DataEncoder.INSTANCE.encodeDate((String)inputValue);
                break;
            }
            case 8: {
                Intrinsics.checkNotNull(inputValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                value = (byte[])inputValue;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new DerTlv(tag, value);
    }

    private final byte getTag(SealDto sealDto, String feature) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            String name = featuresDto.component1();
            int tag = featuresDto.component2();
            if (!StringsKt.equals((String)name, (String)feature, (boolean)true)) continue;
            return (byte)tag;
        }
        throw new IllegalArgumentException("Feature '" + feature + "' is unspecified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final String getFeatureName(SealDto sealDto, int tag) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            String name = featuresDto.component1();
            int tag1 = featuresDto.component2();
            if (tag1 != tag) continue;
            return name;
        }
        throw new IllegalArgumentException("No Feature with tag '" + tag + "' is specified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final FeatureCoding getCoding(SealDto sealDto, String feature) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            String name = featuresDto.component1();
            FeatureCoding coding = featuresDto.component3();
            if (!StringsKt.equals((String)name, (String)feature, (boolean)true)) continue;
            return coding;
        }
        throw new IllegalArgumentException("Feature '" + feature + "' is unspecified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final FeatureCoding getCoding(SealDto sealDto, byte tag) throws IllegalArgumentException {
        for (FeaturesDto featuresDto : sealDto.getFeatures()) {
            int tag1 = featuresDto.component2();
            FeatureCoding coding = featuresDto.component3();
            if (tag1 != tag) continue;
            return coding;
        }
        throw new IllegalArgumentException("No Feature with tag '" + tag + "' is specified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final FeaturesDto getFeatureDto(SealDto sealDto, byte tag) throws IllegalArgumentException {
        for (FeaturesDto featureDto : sealDto.getFeatures()) {
            if (featureDto.getTag() != tag) continue;
            return featureDto;
        }
        throw new IllegalArgumentException("No Feature with tag '" + tag + "' is specified for the given seal '" + sealDto.getDocumentType() + "'");
    }

    private final SealDto getSealDto(String vdsType) throws IllegalArgumentException {
        for (SealDto sealDto : this.sealDtoList) {
            if (!Intrinsics.areEqual((Object)sealDto.getDocumentType(), (Object)vdsType)) continue;
            return sealDto;
        }
        throw new IllegalArgumentException("VdsType '" + vdsType + "' is unspecified in SealCodings.");
    }

    private static final Unit _init_$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureCoding.values().length];
            try {
                nArray[FeatureCoding.C40.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MRZ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UTF8_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MASKED_DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.DATE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UNKNOWN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

