/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.generic;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.vds.FeatureCoding;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lde/tsenger/vdstools/generic/Message;", "", "typeTag", "", "typeName", "", "value", "", "coding", "Lde/tsenger/vdstools/vds/FeatureCoding;", "<init>", "(ILjava/lang/String;[BLde/tsenger/vdstools/vds/FeatureCoding;)V", "messageTypeTag", "getMessageTypeTag", "()I", "messageTypeName", "getMessageTypeName", "()Ljava/lang/String;", "messageContent", "messageCoding", "valueBytes", "getValueBytes", "()[B", "valueInt", "getValueInt", "valueStr", "getValueStr", "VdsTools"})
public final class Message {
    private final int messageTypeTag;
    @NotNull
    private final String messageTypeName;
    @NotNull
    private final byte[] messageContent;
    @NotNull
    private final FeatureCoding messageCoding;

    public Message(int typeTag, @NotNull String typeName, @NotNull byte[] value, @NotNull FeatureCoding coding) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)coding), (String)"coding");
        this.messageTypeTag = typeTag;
        this.messageTypeName = typeName;
        this.messageContent = value;
        this.messageCoding = coding;
    }

    public final int getMessageTypeTag() {
        return this.messageTypeTag;
    }

    @NotNull
    public final String getMessageTypeName() {
        return this.messageTypeName;
    }

    @NotNull
    public final byte[] getValueBytes() {
        return this.messageContent;
    }

    public final int getValueInt() {
        return this.messageContent[0] & 0xFF;
    }

    @NotNull
    public final String getValueStr() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.messageCoding.ordinal()]) {
            case 1 -> String.valueOf(this.getValueInt());
            case 2 -> DataEncoder.INSTANCE.decodeC40(this.messageContent);
            case 3 -> StringsKt.decodeToString((byte[])this.messageContent);
            case 4 -> DataEncoder.INSTANCE.decodeMaskedDate(this.messageContent);
            case 5 -> DataEncoder.INSTANCE.decodeDate(this.messageContent).toString();
            case 6, 7 -> HexExtensionsKt.toHexString$default((byte[])this.messageContent, null, (int)1, null);
            case 8 -> {
                String unformattedMrz = DataEncoder.INSTANCE.decodeC40(this.messageContent);
                String var3_2 = this.messageTypeName;
                int mrzLength = Intrinsics.areEqual((Object)var3_2, (Object)"MRZ_MRVA") ? 88 : (Intrinsics.areEqual((Object)var3_2, (Object)"MRZ_MRVB") ? 72 : unformattedMrz.length());
                yield DataEncoder.INSTANCE.formatMRZ(unformattedMrz, mrzLength);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureCoding.values().length];
            try {
                nArray[FeatureCoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.C40.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UTF8_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MASKED_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UNKNOWN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MRZ.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

