/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.generic;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import de.tsenger.vdstools.asn1.ASN1Encoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J?\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\r\u00a8\u0006("}, d2={"Lde/tsenger/vdstools/generic/SignatureInfo;", "", "plainSignatureBytes", "", "signerCertificateReference", "", "signingDate", "Lkotlinx/datetime/LocalDate;", "signerCertificateBytes", "signatureAlgorithm", "<init>", "([BLjava/lang/String;Lkotlinx/datetime/LocalDate;[BLjava/lang/String;)V", "getPlainSignatureBytes", "()[B", "getSignerCertificateReference", "()Ljava/lang/String;", "getSigningDate", "()Lkotlinx/datetime/LocalDate;", "getSignerCertificateBytes", "setSignerCertificateBytes", "([B)V", "getSignatureAlgorithm", "setSignatureAlgorithm", "(Ljava/lang/String;)V", "log", "Lco/touchlab/kermit/Logger;", "derSignatureBytes", "getDerSignatureBytes", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "copy", "toString", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nSignatureInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureInfo.kt\nde/tsenger/vdstools/generic/SignatureInfo\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,56:1\n67#2,2:57\n69#2:68\n54#3,9:59\n*S KotlinDebug\n*F\n+ 1 SignatureInfo.kt\nde/tsenger/vdstools/generic/SignatureInfo\n*L\n27#1:57,2\n27#1:68\n27#1:59,9\n*E\n"})
public final class SignatureInfo {
    @NotNull
    private final byte[] plainSignatureBytes;
    @NotNull
    private final String signerCertificateReference;
    @NotNull
    private final LocalDate signingDate;
    @Nullable
    private byte[] signerCertificateBytes;
    @Nullable
    private String signatureAlgorithm;
    @NotNull
    private final Logger log;

    public SignatureInfo(@NotNull byte[] plainSignatureBytes, @NotNull String signerCertificateReference, @NotNull LocalDate signingDate, @Nullable byte[] signerCertificateBytes, @Nullable String signatureAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)plainSignatureBytes, (String)"plainSignatureBytes");
        Intrinsics.checkNotNullParameter((Object)signerCertificateReference, (String)"signerCertificateReference");
        Intrinsics.checkNotNullParameter((Object)signingDate, (String)"signingDate");
        this.plainSignatureBytes = plainSignatureBytes;
        this.signerCertificateReference = signerCertificateReference;
        this.signingDate = signingDate;
        this.signerCertificateBytes = signerCertificateBytes;
        this.signatureAlgorithm = signatureAlgorithm;
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        this.log = Logger.Companion.withTag(string);
    }

    public /* synthetic */ SignatureInfo(byte[] byArray, String string, LocalDate localDate, byte[] byArray2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            byArray2 = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(byArray, string, localDate, byArray2, string2);
    }

    @NotNull
    public final byte[] getPlainSignatureBytes() {
        return this.plainSignatureBytes;
    }

    @NotNull
    public final String getSignerCertificateReference() {
        return this.signerCertificateReference;
    }

    @NotNull
    public final LocalDate getSigningDate() {
        return this.signingDate;
    }

    @Nullable
    public final byte[] getSignerCertificateBytes() {
        return this.signerCertificateBytes;
    }

    public final void setSignerCertificateBytes(@Nullable byte[] byArray) {
        this.signerCertificateBytes = byArray;
    }

    @Nullable
    public final String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final void setSignatureAlgorithm(@Nullable String string) {
        this.signatureAlgorithm = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getDerSignatureBytes() {
        void this_$iv$iv;
        void $this$iv;
        byte[] byArray = this.plainSignatureBytes;
        int n = 0;
        int n2 = this.plainSignatureBytes.length / 2;
        byte[] r = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        byte[] byArray2 = this.plainSignatureBytes;
        n2 = this.plainSignatureBytes.length / 2;
        int n3 = this.plainSignatureBytes.length;
        byte[] s = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
        byte[] rEncoded = ASN1Encoder.INSTANCE.getDerInteger(r);
        byte[] sEncoded = ASN1Encoder.INSTANCE.getDerInteger(s);
        Object object = new byte[][]{rEncoded, sEncoded};
        byte[] derSignatureBytes = ASN1Encoder.INSTANCE.getDerSequence((byte[][])object);
        object = this.log;
        String messageString$iv = "DER Signature bytes: " + HexExtensionsKt.toHexString$default((byte[])derSignatureBytes, null, (int)1, null);
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
        return derSignatureBytes;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SignatureInfo cfr_ignored_0 = (SignatureInfo)other;
        if (!Arrays.equals(this.plainSignatureBytes, ((SignatureInfo)other).plainSignatureBytes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signerCertificateReference, (Object)((SignatureInfo)other).signerCertificateReference)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signingDate, (Object)((SignatureInfo)other).signingDate)) {
            return false;
        }
        if (!Arrays.equals(this.signerCertificateBytes, ((SignatureInfo)other).signerCertificateBytes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signatureAlgorithm, (Object)((SignatureInfo)other).signatureAlgorithm);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.plainSignatureBytes);
        result = 31 * result + this.signerCertificateReference.hashCode();
        result = 31 * result + this.signingDate.hashCode();
        result = 31 * result + (this.signerCertificateBytes != null ? Arrays.hashCode(this.signerCertificateBytes) : 0);
        String string = this.signatureAlgorithm;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @NotNull
    public final byte[] component1() {
        return this.plainSignatureBytes;
    }

    @NotNull
    public final String component2() {
        return this.signerCertificateReference;
    }

    @NotNull
    public final LocalDate component3() {
        return this.signingDate;
    }

    @Nullable
    public final byte[] component4() {
        return this.signerCertificateBytes;
    }

    @Nullable
    public final String component5() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final SignatureInfo copy(@NotNull byte[] plainSignatureBytes, @NotNull String signerCertificateReference, @NotNull LocalDate signingDate, @Nullable byte[] signerCertificateBytes, @Nullable String signatureAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)plainSignatureBytes, (String)"plainSignatureBytes");
        Intrinsics.checkNotNullParameter((Object)signerCertificateReference, (String)"signerCertificateReference");
        Intrinsics.checkNotNullParameter((Object)signingDate, (String)"signingDate");
        return new SignatureInfo(plainSignatureBytes, signerCertificateReference, signingDate, signerCertificateBytes, signatureAlgorithm);
    }

    public static /* synthetic */ SignatureInfo copy$default(SignatureInfo signatureInfo, byte[] byArray, String string, LocalDate localDate, byte[] byArray2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = signatureInfo.plainSignatureBytes;
        }
        if ((n & 2) != 0) {
            string = signatureInfo.signerCertificateReference;
        }
        if ((n & 4) != 0) {
            localDate = signatureInfo.signingDate;
        }
        if ((n & 8) != 0) {
            byArray2 = signatureInfo.signerCertificateBytes;
        }
        if ((n & 0x10) != 0) {
            string2 = signatureInfo.signatureAlgorithm;
        }
        return signatureInfo.copy(byArray, string, localDate, byArray2, string2);
    }

    @NotNull
    public String toString() {
        return "SignatureInfo(plainSignatureBytes=" + Arrays.toString(this.plainSignatureBytes) + ", signerCertificateReference=" + this.signerCertificateReference + ", signingDate=" + this.signingDate + ", signerCertificateBytes=" + Arrays.toString(this.signerCertificateBytes) + ", signatureAlgorithm=" + this.signatureAlgorithm + ")";
    }
}

