/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.Base32;
import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.generic.Message;
import de.tsenger.vdstools.generic.Seal;
import de.tsenger.vdstools.generic.SignatureInfo;
import de.tsenger.vdstools.idb.IdbMessage;
import de.tsenger.vdstools.idb.IdbPayload;
import de.tsenger.vdstools.idb.IdbSignature;
import de.tsenger.vdstools.idb.IdbSignatureAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 32\u00020\u0001:\u00013B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001b\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0015R\u0013\u0010/\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0015R\u0013\u00101\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0015\u00a8\u00064"}, d2={"Lde/tsenger/vdstools/idb/IcaoBarcode;", "Lde/tsenger/vdstools/generic/Seal;", "barcodeFlag", "", "barcodePayload", "Lde/tsenger/vdstools/idb/IdbPayload;", "<init>", "(CLde/tsenger/vdstools/idb/IdbPayload;)V", "isSigned", "", "isZipped", "(ZZLde/tsenger/vdstools/idb/IdbPayload;)V", "payLoad", "getPayLoad", "()Lde/tsenger/vdstools/idb/IdbPayload;", "setPayLoad", "(Lde/tsenger/vdstools/idb/IdbPayload;)V", "()Z", "rawString", "", "getRawString", "()Ljava/lang/String;", "getMessage", "Lde/tsenger/vdstools/generic/Message;", "name", "tag", "", "documentType", "getDocumentType", "messageList", "", "getMessageList", "()Ljava/util/List;", "signatureInfo", "Lde/tsenger/vdstools/generic/SignatureInfo;", "getSignatureInfo", "()Lde/tsenger/vdstools/generic/SignatureInfo;", "signedBytes", "", "getSignedBytes", "()[B", "signature", "Lde/tsenger/vdstools/idb/IdbSignature;", "getSignature", "()Lde/tsenger/vdstools/idb/IdbSignature;", "issuingCountry", "getIssuingCountry", "signatureAlgorithmName", "getSignatureAlgorithmName", "signatureCreationDate", "getSignatureCreationDate", "Companion", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nIcaoBarcode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IcaoBarcode.kt\nde/tsenger/vdstools/idb/IcaoBarcode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n1557#3:154\n1628#3,3:155\n*S KotlinDebug\n*F\n+ 1 IcaoBarcode.kt\nde/tsenger/vdstools/idb/IcaoBarcode\n*L\n75#1:154\n75#1:155,3\n*E\n"})
public final class IcaoBarcode
extends Seal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private char barcodeFlag;
    @NotNull
    private IdbPayload payLoad;
    @NotNull
    public static final String BARCODE_IDENTIFIER = "NDB1";

    @NotNull
    public final IdbPayload getPayLoad() {
        return this.payLoad;
    }

    public final void setPayLoad(@NotNull IdbPayload idbPayload) {
        Intrinsics.checkNotNullParameter((Object)idbPayload, (String)"<set-?>");
        this.payLoad = idbPayload;
    }

    public IcaoBarcode(char barcodeFlag, @NotNull IdbPayload barcodePayload) {
        Intrinsics.checkNotNullParameter((Object)barcodePayload, (String)"barcodePayload");
        this.barcodeFlag = (char)65;
        this.barcodeFlag = barcodeFlag;
        this.payLoad = barcodePayload;
    }

    public IcaoBarcode(boolean isSigned, boolean isZipped, @NotNull IdbPayload barcodePayload) {
        Intrinsics.checkNotNullParameter((Object)barcodePayload, (String)"barcodePayload");
        this.barcodeFlag = (char)65;
        if (isSigned) {
            this.barcodeFlag = (char)(this.barcodeFlag + '\u0001');
        }
        if (isZipped) {
            this.barcodeFlag = (char)(this.barcodeFlag + 2);
        }
        this.payLoad = barcodePayload;
    }

    public final boolean isSigned() {
        return ((byte)((byte)this.barcodeFlag - 65) & 1) == 1;
    }

    public final boolean isZipped() {
        return ((byte)((byte)this.barcodeFlag - 65) & 2) == 2;
    }

    @Override
    @NotNull
    public String getRawString() {
        StringBuilder strBuffer = new StringBuilder(BARCODE_IDENTIFIER);
        strBuffer.append(this.barcodeFlag);
        byte[] payloadBytes = this.isZipped() ? DataEncoder.INSTANCE.zip(this.payLoad.getEncoded()) : this.payLoad.getEncoded();
        String base32EncodedPayload = StringsKt.replace$default((String)Base32.INSTANCE.encode(payloadBytes), (String)"=", (String)"", (boolean)false, (int)4, null);
        strBuffer.append(base32EncodedPayload);
        String string = strBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @Nullable
    public Message getMessage(@NotNull String name) {
        Message message;
        IdbMessage idbMessage;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IdbMessage idbMessage2 = idbMessage = this.payLoad.getIdbMessageGroup().getMessage(name);
        if (idbMessage2 != null) {
            IdbMessage it = idbMessage2;
            boolean bl = false;
            message = new Message(it.getMessageTypeTag(), it.getMessageTypeName(), it.getValueBytes(), it.getCoding());
        } else {
            message = null;
        }
        return message;
    }

    @Override
    @Nullable
    public Message getMessage(int tag) {
        Message message;
        IdbMessage idbMessage;
        IdbMessage idbMessage2 = idbMessage = this.payLoad.getIdbMessageGroup().getMessage(tag);
        if (idbMessage2 != null) {
            IdbMessage it = idbMessage2;
            boolean bl = false;
            message = new Message(it.getMessageTypeTag(), it.getMessageTypeName(), it.getValueBytes(), it.getCoding());
        } else {
            message = null;
        }
        return message;
    }

    @Override
    @NotNull
    public String getDocumentType() {
        Message message = this.getMessage(134);
        Integer docTypeId = message != null ? Integer.valueOf(message.getValueInt()) : null;
        return docTypeId != null ? DataEncoder.INSTANCE.getIdbDocumentTypeName(docTypeId) : CollectionsKt.joinToString$default((Iterable)this.getMessageList(), (CharSequence)", ", null, null, (int)0, null, IcaoBarcode::_get_documentType_$lambda$2, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Message> getMessageList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.payLoad.getIdbMessageGroup().getMessagesList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void idbMessage;
            IdbMessage idbMessage2 = (IdbMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Message(idbMessage.getMessageTypeTag(), idbMessage.getMessageTypeName(), idbMessage.getValueBytes(), idbMessage.getCoding()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public SignatureInfo getSignatureInfo() {
        Object object;
        byte[] byArray;
        LocalDate sigDate;
        block8: {
            block7: {
                IdbSignature idbSignature = this.payLoad.getIdbSignature();
                if (!this.isSigned() || idbSignature == null) {
                    return null;
                }
                sigDate = new LocalDate(1970, 1, 1);
                try {
                    String string = this.payLoad.getIdbHeader().getSignatureCreationDate();
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "1970-01-01";
                    }
                    sigDate = LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)string2, null, (int)2, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                byArray = idbSignature.getPlainSignatureBytes();
                object = this.payLoad.getIdbHeader().getCertificateReference();
                if (object == null) break block7;
                String string = HexExtensionsKt.toHexString$default((byte[])object, null, (int)1, null);
                object = string;
                if (string != null) break block8;
            }
            object = "";
        }
        IdbSignatureAlgorithm idbSignatureAlgorithm = this.payLoad.getIdbHeader().getSignatureAlgorithm();
        return new SignatureInfo(byArray, (String)object, sigDate, null, idbSignatureAlgorithm != null ? idbSignatureAlgorithm.name() : null);
    }

    @Override
    @Nullable
    public byte[] getSignedBytes() {
        return ArraysKt.plus((byte[])this.payLoad.getIdbHeader().getEncoded(), (byte[])this.payLoad.getIdbMessageGroup().getEncoded());
    }

    @Nullable
    public final IdbSignature getSignature() {
        return this.payLoad.getIdbSignature();
    }

    @Override
    @NotNull
    public String getIssuingCountry() {
        return this.payLoad.getIdbHeader().getCountryIdentifier();
    }

    @Nullable
    public final String getSignatureAlgorithmName() {
        IdbSignatureAlgorithm idbSignatureAlgorithm = this.payLoad.getIdbHeader().getSignatureAlgorithm();
        return idbSignatureAlgorithm != null ? idbSignatureAlgorithm.name() : null;
    }

    @Nullable
    public final String getSignatureCreationDate() {
        return this.payLoad.getIdbHeader().getSignatureCreationDate();
    }

    private static final CharSequence _get_documentType_$lambda$2(Message it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessageTypeName();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/tsenger/vdstools/idb/IcaoBarcode$Companion;", "", "<init>", "()V", "BARCODE_IDENTIFIER", "", "fromString", "Lde/tsenger/vdstools/generic/Seal;", "barcodeString", "VdsTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Seal fromString(@NotNull String barcodeString) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)barcodeString, (String)"barcodeString");
            StringBuilder strBuffer = new StringBuilder(barcodeString);
            String string = strBuffer.substring(0, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            if (!new Regex(IcaoBarcode.BARCODE_IDENTIFIER).matches(charSequence)) {
                throw new IllegalArgumentException("Didn't found an ICAO Barcode in the given String: " + barcodeString);
            }
            char barcodeFlag = strBuffer.charAt(4);
            boolean isSigned = ((byte)((byte)barcodeFlag - 65) & 1) == 1;
            boolean isZipped = ((byte)((byte)barcodeFlag - 65) & 2) == 2;
            StringBuilder base32EncodedPayload = new StringBuilder(strBuffer.substring(5));
            while (base32EncodedPayload.length() % 8 != 0) {
                base32EncodedPayload.append("=");
            }
            String string2 = base32EncodedPayload.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            byte[] payloadBytes = Base32.INSTANCE.decode(string2);
            if (isZipped) {
                payloadBytes = DataEncoder.INSTANCE.unzip(payloadBytes);
            }
            IdbPayload payload = IdbPayload.Companion.fromByteArray(payloadBytes, isSigned);
            return new IcaoBarcode(barcodeFlag, payload);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

