/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.FeatureCoding;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lde/tsenger/vdstools/idb/IdbMessage;", "", "messageTypeName", "", "messageContent", "", "<init>", "(Ljava/lang/String;[B)V", "messageTypeTag", "", "(I[B)V", "getMessageTypeTag", "()I", "getMessageTypeName", "()Ljava/lang/String;", "encoded", "getEncoded", "()[B", "valueBytes", "getValueBytes", "valueInt", "getValueInt", "coding", "Lde/tsenger/vdstools/vds/FeatureCoding;", "getCoding", "()Lde/tsenger/vdstools/vds/FeatureCoding;", "valueStr", "getValueStr", "Companion", "VdsTools"})
public final class IdbMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int messageTypeTag;
    @NotNull
    private final String messageTypeName;
    @NotNull
    private final byte[] messageContent;

    public final int getMessageTypeTag() {
        return this.messageTypeTag;
    }

    @NotNull
    public final String getMessageTypeName() {
        return this.messageTypeName;
    }

    public IdbMessage(@NotNull String messageTypeName, @NotNull byte[] messageContent) {
        Intrinsics.checkNotNullParameter((Object)messageTypeName, (String)"messageTypeName");
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        this.messageTypeName = messageTypeName;
        Integer n = DataEncoder.INSTANCE.getIdbMessageTypeTag(messageTypeName);
        this.messageTypeTag = n != null ? n : 0;
        this.messageContent = messageContent;
    }

    public IdbMessage(int messageTypeTag, @NotNull byte[] messageContent) {
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        this.messageTypeName = DataEncoder.INSTANCE.getIdbMessageTypeName(messageTypeTag);
        this.messageTypeTag = messageTypeTag;
        this.messageContent = messageContent;
    }

    @NotNull
    public final byte[] getEncoded() {
        return new DerTlv((byte)this.messageTypeTag, this.messageContent).getEncoded();
    }

    @NotNull
    public final byte[] getValueBytes() {
        return this.messageContent;
    }

    public final int getValueInt() {
        return this.messageContent[0] & 0xFF;
    }

    @NotNull
    public final FeatureCoding getCoding() {
        return DataEncoder.INSTANCE.getIdbMessageTypeCoding(this.messageTypeName);
    }

    @NotNull
    public final String getValueStr() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getCoding().ordinal()]) {
            case 1 -> String.valueOf(this.getValueInt());
            case 2 -> DataEncoder.INSTANCE.decodeC40(this.messageContent);
            case 3 -> this.messageContent.toString();
            case 4 -> DataEncoder.INSTANCE.decodeMaskedDate(this.messageContent);
            case 5 -> DataEncoder.INSTANCE.decodeDate(this.messageContent).toString();
            case 6, 7 -> HexExtensionsKt.toHexString$default((byte[])this.messageContent, null, (int)1, null);
            case 8 -> {
                String unformattedMrz = DataEncoder.INSTANCE.decodeC40(this.messageContent);
                yield DataEncoder.INSTANCE.formatMRZ(unformattedMrz, unformattedMrz.length());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lde/tsenger/vdstools/idb/IdbMessage$Companion;", "", "<init>", "()V", "fromDerTlv", "Lde/tsenger/vdstools/idb/IdbMessage;", "derTlv", "Lde/tsenger/vdstools/asn1/DerTlv;", "fromByteArray", "rawMessageBytes", "", "VdsTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdbMessage fromDerTlv(@NotNull DerTlv derTlv) {
            Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
            int messageTypeTag = derTlv.getTag() & 0xFF;
            byte[] messageContent = derTlv.getValue();
            return new IdbMessage(messageTypeTag, messageContent);
        }

        @NotNull
        public final IdbMessage fromByteArray(@NotNull byte[] rawMessageBytes) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)rawMessageBytes, (String)"rawMessageBytes");
            DerTlv tlvMessage = DerTlv.Companion.fromByteArray(rawMessageBytes);
            if (tlvMessage == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return this.fromDerTlv(tlvMessage);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureCoding.values().length];
            try {
                nArray[FeatureCoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.C40.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UTF8_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MASKED_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UNKNOWN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MRZ.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

