/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.idb;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.idb.IdbMessage;
import de.tsenger.vdstools.vds.FeatureCoding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011R*\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lde/tsenger/vdstools/idb/IdbMessageGroup;", "", "messagesList", "", "Lde/tsenger/vdstools/idb/IdbMessage;", "<init>", "(Ljava/util/List;)V", "builder", "Lde/tsenger/vdstools/idb/IdbMessageGroup$Builder;", "(Lde/tsenger/vdstools/idb/IdbMessageGroup$Builder;)V", "value", "getMessagesList", "()Ljava/util/List;", "getMessage", "messageTag", "", "messageName", "", "encoded", "", "getEncoded", "()[B", "Builder", "Companion", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nIdbMessageGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbMessageGroup.kt\nde/tsenger/vdstools/idb/IdbMessageGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n295#2,2:113\n295#2,2:115\n*S KotlinDebug\n*F\n+ 1 IdbMessageGroup.kt\nde/tsenger/vdstools/idb/IdbMessageGroup\n*L\n23#1:113,2\n27#1:115,2\n*E\n"})
public final class IdbMessageGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<IdbMessage> messagesList;
    public static final byte TAG = 97;

    @NotNull
    public final List<IdbMessage> getMessagesList() {
        return this.messagesList;
    }

    public IdbMessageGroup(@NotNull List<IdbMessage> messagesList) {
        Intrinsics.checkNotNullParameter(messagesList, (String)"messagesList");
        this.messagesList = CollectionsKt.emptyList();
        this.messagesList = messagesList;
    }

    private IdbMessageGroup(Builder builder) {
        this.messagesList = CollectionsKt.emptyList();
        this.messagesList = builder.getMessageList();
    }

    @Nullable
    public final IdbMessage getMessage(int messageTag) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.messagesList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdbMessage it = (IdbMessage)element$iv;
                boolean bl = false;
                if (!(it.getMessageTypeTag() == messageTag)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final IdbMessage getMessage(@NotNull String messageName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)messageName, (String)"messageName");
            Iterable $this$firstOrNull$iv = this.messagesList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdbMessage it = (IdbMessage)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMessageTypeName(), (Object)messageName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final byte[] getEncoded() {
        Buffer messages = new Buffer();
        for (IdbMessage message : this.messagesList) {
            messages.write(message.getEncoded());
        }
        return new DerTlv(97, messages.readByteArray()).getEncoded();
    }

    public /* synthetic */ IdbMessageGroup(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\u0000\"\u0006\b\u0000\u0010\n\u0018\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\nH\u0086\b\u00a2\u0006\u0002\u0010\u000eJ&\u0010\t\u001a\u00020\u0000\"\u0006\b\u0000\u0010\n\u0018\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u0002H\nH\u0086\b\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lde/tsenger/vdstools/idb/IdbMessageGroup$Builder;", "", "<init>", "()V", "messageList", "", "Lde/tsenger/vdstools/idb/IdbMessage;", "getMessageList", "()Ljava/util/List;", "addMessage", "T", "tag", "", "value", "(ILjava/lang/Object;)Lde/tsenger/vdstools/idb/IdbMessageGroup$Builder;", "name", "", "(Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/idb/IdbMessageGroup$Builder;", "build", "Lde/tsenger/vdstools/idb/IdbMessageGroup;", "VdsTools"})
    @SourceDebugExtension(value={"SMAP\nIdbMessageGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbMessageGroup.kt\nde/tsenger/vdstools/idb/IdbMessageGroup$Builder\n*L\n1#1,112:1\n44#1,36:113\n*S KotlinDebug\n*F\n+ 1 IdbMessageGroup.kt\nde/tsenger/vdstools/idb/IdbMessageGroup$Builder\n*L\n84#1:113,36\n*E\n"})
    public static final class Builder {
        @NotNull
        private final List<IdbMessage> messageList = new ArrayList(5);

        @NotNull
        public final List<IdbMessage> getMessageList() {
            return this.messageList;
        }

        public final /* synthetic */ <T> Builder addMessage(int tag, T value) throws IllegalArgumentException {
            block11: {
                block10: {
                    boolean $i$f$addMessage = false;
                    FeatureCoding coding = DataEncoder.INSTANCE.getIdbMessageTypeCoding(tag);
                    T t = value;
                    if (!(t instanceof String) && !(t instanceof byte[]) && !(t instanceof Integer)) break block10;
                    switch (WhenMappings.$EnumSwitchMapping$0[coding.ordinal()]) {
                        case 1: {
                            List<IdbMessage> list = this.getMessageList();
                            T t2 = value;
                            Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag, DataEncoder.INSTANCE.encodeC40((String)t2)));
                            break block11;
                        }
                        case 2: {
                            List<IdbMessage> list = this.getMessageList();
                            T t3 = value;
                            Intrinsics.checkNotNull(t3, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag, StringsKt.encodeToByteArray((String)((String)t3))));
                            break block11;
                        }
                        case 3: {
                            List<IdbMessage> list = this.getMessageList();
                            T t4 = value;
                            Intrinsics.checkNotNull(t4, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                            boolean bl = list.add(new IdbMessage(tag, (byte[])t4));
                            break block11;
                        }
                        case 4: {
                            List<IdbMessage> list = this.getMessageList();
                            byte[] byArray = new byte[1];
                            T t5 = value;
                            Intrinsics.checkNotNull(t5, (String)"null cannot be cast to non-null type kotlin.Int");
                            byArray[0] = (byte)((Integer)t5 & 0xFF);
                            boolean bl = list.add(new IdbMessage(tag, byArray));
                            break block11;
                        }
                        case 5: {
                            List<IdbMessage> list = this.getMessageList();
                            T t6 = value;
                            Intrinsics.checkNotNull(t6, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag, DataEncoder.INSTANCE.encodeMaskedDate((String)t6)));
                            break block11;
                        }
                        case 6: {
                            List<IdbMessage> list = this.getMessageList();
                            T t7 = value;
                            Intrinsics.checkNotNull(t7, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag, DataEncoder.INSTANCE.encodeDate((String)t7)));
                            break block11;
                        }
                        case 7: {
                            List<IdbMessage> list = this.getMessageList();
                            T t8 = value;
                            Intrinsics.checkNotNull(t8, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag, DataEncoder.INSTANCE.encodeC40((String)t8)));
                            break block11;
                        }
                        case 8: {
                            throw new IllegalArgumentException("Unsupported tag: " + tag);
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T> Builder addMessage(String name, T value) throws IllegalArgumentException {
            void this_$iv;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    boolean $i$f$addMessage = false;
                    Builder builder = this;
                    Integer n = DataEncoder.INSTANCE.getIdbMessageTypeTag(name);
                    int tag$iv = n != null ? n : 0;
                    boolean $i$f$addMessage2 = false;
                    FeatureCoding coding$iv = DataEncoder.INSTANCE.getIdbMessageTypeCoding(tag$iv);
                    T t = value;
                    if (!(t instanceof String) && !(t instanceof byte[]) && !(t instanceof Integer)) break block10;
                    switch (WhenMappings.$EnumSwitchMapping$0[coding$iv.ordinal()]) {
                        case 1: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            T t2 = value;
                            Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag$iv, DataEncoder.INSTANCE.encodeC40((String)t2)));
                            break block11;
                        }
                        case 2: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            T t3 = value;
                            Intrinsics.checkNotNull(t3, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag$iv, StringsKt.encodeToByteArray((String)((String)t3))));
                            break block11;
                        }
                        case 3: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            T t4 = value;
                            Intrinsics.checkNotNull(t4, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                            boolean bl = list.add(new IdbMessage(tag$iv, (byte[])t4));
                            break block11;
                        }
                        case 4: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            byte[] byArray = new byte[1];
                            T t5 = value;
                            Intrinsics.checkNotNull(t5, (String)"null cannot be cast to non-null type kotlin.Int");
                            byArray[0] = (byte)((Integer)t5 & 0xFF);
                            boolean bl = list.add(new IdbMessage(tag$iv, byArray));
                            break block11;
                        }
                        case 5: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            T t6 = value;
                            Intrinsics.checkNotNull(t6, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag$iv, DataEncoder.INSTANCE.encodeMaskedDate((String)t6)));
                            break block11;
                        }
                        case 6: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            T t7 = value;
                            Intrinsics.checkNotNull(t7, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag$iv, DataEncoder.INSTANCE.encodeDate((String)t7)));
                            break block11;
                        }
                        case 7: {
                            List<IdbMessage> list = this_$iv.getMessageList();
                            T t8 = value;
                            Intrinsics.checkNotNull(t8, (String)"null cannot be cast to non-null type kotlin.String");
                            boolean bl = list.add(new IdbMessage(tag$iv, DataEncoder.INSTANCE.encodeC40((String)t8)));
                            break block11;
                        }
                        case 8: {
                            throw new IllegalArgumentException("Unsupported tag: " + tag$iv);
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
            }
            return this_$iv;
        }

        @NotNull
        public final IdbMessageGroup build() {
            return new IdbMessageGroup(this, null);
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=176)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FeatureCoding.values().length];
                try {
                    nArray[FeatureCoding.C40.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.UTF8_STRING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.BYTES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.BYTE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.MASKED_DATE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.DATE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.MRZ.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureCoding.UNKNOWN.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools/idb/IdbMessageGroup$Companion;", "", "<init>", "()V", "TAG", "", "fromByteArray", "Lde/tsenger/vdstools/idb/IdbMessageGroup;", "rawBytes", "", "VdsTools"})
    @SourceDebugExtension(value={"SMAP\nIdbMessageGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdbMessageGroup.kt\nde/tsenger/vdstools/idb/IdbMessageGroup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1557#2:113\n1628#2,3:114\n*S KotlinDebug\n*F\n+ 1 IdbMessageGroup.kt\nde/tsenger/vdstools/idb/IdbMessageGroup$Companion\n*L\n105#1:113\n105#1:114,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IdbMessageGroup fromByteArray(@NotNull byte[] rawBytes) throws IllegalArgumentException {
            void $this$mapTo$iv$iv;
            Object object;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
                    if (!(rawBytes[0] == 97)) {
                        boolean $i$a$-require-IdbMessageGroup$Companion$fromByteArray$22 = false;
                        String string = Integer.toString(97, CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                        String string3 = Integer.toString(rawBytes[0], CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                        String string4 = StringsKt.padStart((String)string3, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                        String $i$a$-require-IdbMessageGroup$Companion$fromByteArray$22 = "IdbMessageGroup shall have tag " + string2 + ", but tag " + string4 + " was found instead.";
                        throw new IllegalArgumentException($i$a$-require-IdbMessageGroup$Companion$fromByteArray$22.toString());
                    }
                    object = DerTlv.Companion.fromByteArray(rawBytes);
                    if (object == null) break block5;
                    byte[] byArray = ((DerTlv)object).getValue();
                    object = byArray;
                    if (byArray != null) break block6;
                }
                object = new byte[0];
            }
            Object valueBytes = object;
            List<DerTlv> derTlvMessagesList = DataEncoder.INSTANCE.parseDerTLvs((byte[])valueBytes);
            Iterable $this$map$iv = derTlvMessagesList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DerTlv derTlv = (DerTlv)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(IdbMessage.Companion.fromDerTlv((DerTlv)it));
            }
            List messageList = (List)destination$iv$iv;
            return new IdbMessageGroup(messageList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

