/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.FeatureCoding;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lde/tsenger/vdstools/vds/Feature;", "", "tag", "", "name", "", "value", "", "coding", "Lde/tsenger/vdstools/vds/FeatureCoding;", "<init>", "(ILjava/lang/String;[BLde/tsenger/vdstools/vds/FeatureCoding;)V", "getTag", "()I", "getName", "()Ljava/lang/String;", "getCoding", "()Lde/tsenger/vdstools/vds/FeatureCoding;", "valueBytes", "getValueBytes", "()[B", "valueInt", "getValueInt", "valueStr", "getValueStr", "Companion", "VdsTools"})
public final class Feature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int tag;
    @NotNull
    private final String name;
    @NotNull
    private final byte[] value;
    @NotNull
    private final FeatureCoding coding;

    public Feature(int tag, @NotNull String name, @NotNull byte[] value, @NotNull FeatureCoding coding) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)coding), (String)"coding");
        this.tag = tag;
        this.name = name;
        this.value = value;
        this.coding = coding;
    }

    public final int getTag() {
        return this.tag;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final FeatureCoding getCoding() {
        return this.coding;
    }

    @NotNull
    public final byte[] getValueBytes() {
        return this.value;
    }

    public final int getValueInt() {
        return this.value[0] & 0xFF;
    }

    @NotNull
    public final String getValueStr() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.coding.ordinal()]) {
            case 1 -> String.valueOf(this.getValueInt());
            case 2 -> DataEncoder.INSTANCE.decodeC40(this.value);
            case 3 -> StringsKt.decodeToString((byte[])this.value);
            case 4 -> DataEncoder.INSTANCE.decodeMaskedDate(this.value);
            case 5 -> DataEncoder.INSTANCE.decodeDate(this.value).toString();
            case 6, 7 -> HexExtensionsKt.toHexString$default((byte[])this.value, null, (int)1, null);
            case 8 -> {
                String unformattedMrz = DataEncoder.INSTANCE.decodeC40(this.value);
                yield DataEncoder.INSTANCE.formatMRZ(unformattedMrz, unformattedMrz.length());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools/vds/Feature$Companion;", "", "<init>", "()V", "fromDerTlv", "Lde/tsenger/vdstools/vds/Feature;", "vdsType", "", "derTlv", "Lde/tsenger/vdstools/asn1/DerTlv;", "VdsTools"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Feature fromDerTlv(@NotNull String vdsType, @NotNull DerTlv derTlv) {
            Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
            Intrinsics.checkNotNullParameter((Object)derTlv, (String)"derTlv");
            return DataEncoder.INSTANCE.encodeDerTlv(vdsType, derTlv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureCoding.values().length];
            try {
                nArray[FeatureCoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.C40.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UTF8_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MASKED_DATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.BYTES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.UNKNOWN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureCoding.MRZ.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

