/*
 * Decompiled with CFR 0.152.
 */
package de.tsenger.vdstools.vds;

import de.tsenger.vdstools.DataEncoder;
import de.tsenger.vdstools.asn1.DerTlv;
import de.tsenger.vdstools.vds.Feature;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lde/tsenger/vdstools/vds/VdsMessage;", "", "vdsType", "", "derTlvList", "", "Lde/tsenger/vdstools/asn1/DerTlv;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "builder", "Lde/tsenger/vdstools/vds/VdsMessage$Builder;", "(Lde/tsenger/vdstools/vds/VdsMessage$Builder;)V", "value", "getVdsType", "()Ljava/lang/String;", "encoded", "", "getEncoded", "()[B", "featureList", "Lde/tsenger/vdstools/vds/Feature;", "getFeatureList", "()Ljava/util/List;", "getFeature", "featureName", "featureTag", "", "Builder", "Companion", "VdsTools"})
@SourceDebugExtension(value={"SMAP\nVdsMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VdsMessage.kt\nde/tsenger/vdstools/vds/VdsMessage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n295#3,2:76\n295#3,2:78\n*S KotlinDebug\n*F\n+ 1 VdsMessage.kt\nde/tsenger/vdstools/vds/VdsMessage\n*L\n45#1:76,2\n49#1:78,2\n*E\n"})
public final class VdsMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<DerTlv> derTlvList;
    @NotNull
    private String vdsType;

    @NotNull
    public final String getVdsType() {
        return this.vdsType;
    }

    public VdsMessage(@NotNull String vdsType, @NotNull List<DerTlv> derTlvList) {
        Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
        Intrinsics.checkNotNullParameter(derTlvList, (String)"derTlvList");
        this.vdsType = vdsType;
        this.derTlvList = derTlvList;
    }

    private VdsMessage(Builder builder) {
        this.derTlvList = builder.getDerTlvList();
        this.vdsType = builder.getVdsType();
    }

    @NotNull
    public final byte[] getEncoded() {
        Buffer buffer = new Buffer();
        for (DerTlv feature : this.derTlvList) {
            buffer.write(feature.getEncoded());
        }
        return buffer.readByteArray();
    }

    @NotNull
    public final List<Feature> getFeatureList() {
        List featureList = new ArrayList();
        for (DerTlv derTlv : this.derTlvList) {
            Feature it;
            if (Feature.Companion.fromDerTlv(this.vdsType, derTlv) == null) continue;
            boolean bl = false;
            featureList.add(it);
        }
        return featureList;
    }

    @Nullable
    public final Feature getFeature(@NotNull String featureName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            Iterable $this$firstOrNull$iv = this.getFeatureList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Feature feature = (Feature)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)feature.getName(), (Object)featureName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Feature getFeature(int featureTag) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getFeatureList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Feature feature = (Feature)element$iv;
                boolean bl = false;
                if (!(feature.getTag() == featureTag)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public /* synthetic */ VdsMessage(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\r\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lde/tsenger/vdstools/vds/VdsMessage$Builder;", "", "vdsType", "", "<init>", "(Ljava/lang/String;)V", "getVdsType", "()Ljava/lang/String;", "derTlvList", "", "Lde/tsenger/vdstools/asn1/DerTlv;", "getDerTlvList", "()Ljava/util/List;", "addDocumentFeature", "T", "feature", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lde/tsenger/vdstools/vds/VdsMessage$Builder;", "build", "Lde/tsenger/vdstools/vds/VdsMessage;", "VdsTools"})
    public static final class Builder {
        @NotNull
        private final String vdsType;
        @NotNull
        private final List<DerTlv> derTlvList;

        public Builder(@NotNull String vdsType) {
            Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
            this.vdsType = vdsType;
            this.derTlvList = new ArrayList(5);
        }

        @NotNull
        public final String getVdsType() {
            return this.vdsType;
        }

        @NotNull
        public final List<DerTlv> getDerTlvList() {
            return this.derTlvList;
        }

        @NotNull
        public final <T> Builder addDocumentFeature(@NotNull String feature, T value) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            DerTlv derTlv = DataEncoder.INSTANCE.encodeFeature(this.vdsType, feature, value);
            this.derTlvList.add(derTlv);
            return this;
        }

        @NotNull
        public final VdsMessage build() {
            return new VdsMessage(this, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lde/tsenger/vdstools/vds/VdsMessage$Companion;", "", "<init>", "()V", "fromByteArray", "Lde/tsenger/vdstools/vds/VdsMessage;", "rawBytes", "", "vdsType", "", "VdsTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VdsMessage fromByteArray(@NotNull byte[] rawBytes, @NotNull String vdsType) {
            Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
            Intrinsics.checkNotNullParameter((Object)vdsType, (String)"vdsType");
            List<DerTlv> derTlvList = DataEncoder.INSTANCE.parseDerTLvs(rawBytes);
            return new VdsMessage(vdsType, derTlvList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

