/*******************************************************************************
 * Copyright (c) 2010 Torsten Zesch.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     Torsten Zesch - initial API and implementation
 ******************************************************************************/
package de.tudarmstadt.ukp.wikipedia.parser.tutorial;

public class TestFile {

    private static final String LF = "\n";
    
    public static String getFileText() {
        StringBuilder sb = new StringBuilder();
        sb.append("'''Darmstadt''' is a city in the [[States of Germany|Bundesland]] (federal state) of [[Hesse]]n in [[Germany]]. As of 2005, its population was 139,000. The city is located in the southern part of the [[Frankfurt Rhine Main Area|Rhine Main Metropolitan Area]].");
        sb.append(LF);
        sb.append(LF);
        sb.append("== History ==");
        sb.append(LF);
        sb.append("The name Darmstadt first appears towards the end of the [[11th century]], then ''Darmundestat''; Darmstadt was chartered as a city by the [[Holy Roman Emperor]] [[Louis IV, Holy Roman Emperor|Ludwig the Bavarian]] in 1330. The seat of the ruling [[Landgraf|landgraves]] (1567-1806) and thereafter (to 1918) to the [[Grand Duke of Hesse and by Rhine|Grand Dukes of Hesse]], the city grew in population during the [[19th century]] from little over 10,000 to 72,000 inhabitants. A polytechnical school, which later became a Technical University now known as [[Darmstadt University of Technology|TU Darmstadt]], was established in 1877. ");
        sb.append(LF);
        sb.append("In the beginning of the 20th Century Darmstadt was an important centre for the art movement of [[Art Nouveau|Jugendstil]], the German variant of [[Art Nouveau]]. Annual architectural competitions led to the building of many architectural treasures of this period.  Also during this period, in [[1912]] the chemist [[Anton Kollisch]], working for the pharmaceutical company [[Merck]], first synthesised the chemical [[MDMA]] (ecstasy) in Darmstadt.");
        sb.append(LF);
        sb.append("Darmstadt's municipal area was extended in 1937 to include the neighbouring localities of Arheilgen [not Arheil''i''gen] and Eberstadt, and in 1938 the city was separated administratively from the surrounding district (''Kreis''). Its old city centre was largely destroyed in a [[Bombing of Darmstadt in World War II|British bombing raid]] of [[September 11]] [[1944]], which killed an estimated 12,300 inhabitants and rendered 66,000 homeless. Most of Darmstadt's 3000 [[Jew]]s were killed by the [[Nazism|Nazi]] regime between 1933 and 1945. ");
        sb.append(LF);
        sb.append("Darmstadt is home to many technology companies and research institutes, and has been promoting itself as a \"city of science\" since 1997. It is well known as the high-tech centre in the vicinity of [[Frankfurt International Airport|Frankfurt Airport]], with important activities in spacecraft operations, chemistry, pharmacy, information technology, biotechnology, telecommunications and mechatronics. The [[Darmstadt University of Technology|TU Darmstadt]] is one of the important technical institutes in Germany and is well known for its research and teaching in the Electrical, Mechanical and Civil Engineering disciplines.");
        sb.append(LF);
        sb.append(LF);
        sb.append("== Institutions ==");
        sb.append(LF);
        sb.append("Darmstadt is the site of one of the leading German universities, the [[Darmstadt University of Technology]], renowned for its engineering departments and the [[Darmstadt University of Applied Sciences]]. Related institutes are the [[Gesellschaft für Schwerionenforschung]] (see also 'Trivia', below) and the four Institutes of the [[Fraunhofer Society]]. The European Space Operations Center ([[ESOC]]) of the [[European Space Agency]] is located in Darmstadt, as is [[EUMETSAT]], which operates [[meteorological]] [[satellite]]s. Darmstadt is a centre for the pharmaceutical and chemical industry, with [[Merck KGaA|Merck]], Röhm and Schenck RoTec (part of The Dürr Group) having their main plants and centres here.");
        sb.append(LF);
        sb.append("The [http://www.jazzinstitut.de Jazz-Institut Darmstadt] is Germany's largest publicly accessible [[Jazz]] archive.");
        sb.append(LF);
        sb.append("The [http://www.imd.darmstadt.de/ Internationales Musikinstitut Darmstadt], harboring one of the world's largest collections of [[post-war]] [[sheet music]], also hosts the biannual ''[[International Summer Courses for New Music|Internationale Ferienkurse für Neue Musik]]'', a summer school in [[contemporary classical music]] founded by [[Wolfgang Steinecke]]. A large number of avant-garde [[composer]]s have attended and given lectures there, including [[Olivier Messiaen]], [[Luciano Berio]], [[Milton Babbitt]], [[Pierre Boulez]], [[John Cage]], [[György Ligeti]], [[Iannis Xenakis]], [[Karlheinz Stockhausen]] and [[Mauricio Kagel]].");
        sb.append(LF);
        sb.append("The [http://www.deutscheakademie.de/ Deutsche Akademie für Sprache und Dichtung] (German Academy for Language and Poetry) provides writers and scholars with a place to research the German language. The Academy's annual ''Georg-Büchner-Preis'', named in memory of [[Georg Büchner]], is considered the most renowned literary award for writers of German language.");
        sb.append(LF);
        sb.append(LF);
        sb.append("== Sons and Daughters of the City ==");
        sb.append(LF);
        sb.append("* Justus von Liebig, Chemist ");
        sb.append(LF);
        sb.append("* Georg Büchner, German Poet");
        sb.append(LF);
        sb.append("* [[Dr Walter Köbel]], German  politician");
        sb.append(LF);
        sb.append("* [[August Anton Ullrich]], German industrialist (1865-1919)");
        sb.append(LF);
        sb.append("* [[Fabian Scheuermann]], World traveller");
        sb.append(LF);
        sb.append("* [[Björn Phau]], Tennis player");
        sb.append(LF);
        sb.append("* [[Friedrich August Kekulé von Stradonitz]], Organic Chemist");
        sb.append(LF);
        sb.append(LF);
        sb.append("== Military ==");
        sb.append(LF);
        sb.append("There are still [[U.S. Army]] personnel stationed in the Darmstadt area. Just outside the Darmstadt centre is the U.S. Army Garrison Darmstadt on Cambrai-Fritsch Kaserne. The barracks was originally built in the 1930s as two separate German Army barracks (Cambrai Kaserne and Freiherr von Fritsch Kaserne). ");
        sb.append(LF);
        sb.append("It is possible to listen to the military entertainment radio for the American troops in the region. The station is called [[American Forces Network|AFN Europe]] and broadcasts from Frankfurt on FM 98.7 or AM 873.");
        sb.append(LF);
        sb.append("The base has already started deactivation and will be closed around 2008-2010, at that time AFN Europe will be moved to Mannheim.");
        sb.append(LF);
        sb.append(LF);
        sb.append("== Trivia ==");
        sb.append(LF);
        sb.append("Literally translated, the German name \"Darmstadt\" means \"City of the intestine\". But that is just a coincidence, as the name derives from the medieval name \"darmundestat\".  The Darm(bach) is a small creek running through the city.");
        sb.append(LF);
        sb.append("The [[chemical element]] [[Darmstadtium]] ([[atomic number]]: 110), first discovered at the [[Gesellschaft für Schwerionenforschung]] was named after the city in 2003, making Darmstadt only the sixth city with an element named after it (the other five cities are [[Ytterby]] in [[Sweden]] (four elements); [[Strontian]] in [[Scotland]]; [[Copenhagen]] in [[Denmark]] (whose latin name gives [[Hafnium]]); [[Berkeley, California]]; and [[Dubna]] in [[Russia]]). [[Meitnerium]] ([[atomic number]]: 109) (1982), [[Hassium]] ([[atomic number]]: 108) (1984) and [[Roentgenium]] ([[atomic number]]: 111) (1994) and [[Ununbium]] ([[atomic number]]: 112) (1996) were also synthesized in this facility.");
        sb.append(LF);
        sb.append("Darmstadt also happens to be one of the small number of cities worldwide which do not lie close to a river or coast.");
        sb.append(LF);
        sb.append("Darmstadt is the home of [[Software AG]], a software company.");
        sb.append(LF);
        sb.append("Frankenstein Castle, ''[http://de.wikipedia.org/wiki/Burg_Frankenstein_%28Bergstrasse%29 Burg Frankenstein]'' (in German), possibly Mary Shelley's inspiration for the title of her famous 1818 novel ''[[Frankenstein | Frankenstein; or, The Modern Prometheus]]'', is located nearby.");
        sb.append(LF);
        sb.append(LF);
        sb.append("== Twinning ==");
        sb.append(LF);
        sb.append("Darmstadt is [[twinned]] with:");
        sb.append(LF);
        sb.append(LF);
        sb.append("*{{flagicon|Netherlands}}[[Alkmaar]], [[Netherlands]]");
        sb.append(LF);
        sb.append("*{{flagicon|Italy}}[[Brescia]], [[Italy]]");
        sb.append(LF);
        sb.append("*{{flagicon|Turkey}}[[Bursa, Turkey|Bursa]], [[Turkey]]");
        sb.append(LF);
        sb.append("*{{flagicon|United Kingdom}}[[Chesterfield]], [[United Kingdom|UK]]");
        sb.append(LF);
        sb.append("*{{flagicon|Austria}}[[Graz]], [[Austria]]");
        sb.append(LF);
        sb.append("*{{flagicon|Latvia}}[[Liepaja]], [[Latvia]]");
        sb.append(LF);
        sb.append("*{{flagicon|Spain}}[[Logroño]], [[Spain]]");
        sb.append(LF);
        sb.append("*{{flagicon|Poland}}[[Płock]], [[Poland]]");
        sb.append(LF);
        sb.append("*{{flagicon|Hungary}}[[Szeged]], [[Hungary]]");
        sb.append(LF);
        sb.append("*{{flagicon|Norway}}[[Trondheim]], [[Norway]]");
        sb.append(LF);
        sb.append("*{{flagicon|France}}[[Troyes]], [[France]]");
        sb.append(LF);
        sb.append("*{{flagicon|Ukraine}}[[Uzhhorod]], [[Ukraine]]");
        sb.append(LF);
        sb.append("*{{flagicon|Switzerland}}[[Saanen]], [[Switzerland]]");
        sb.append(LF);
        sb.append(LF);
        sb.append("==External links==");
        sb.append(LF);
        sb.append("{{commonscat|Darmstadt, Germany}}");
        sb.append(LF);
        sb.append("*[http://www.darmstadt.de/ Official site of the city of Darmstadt] (German, English)");
        sb.append(LF);
        sb.append("*[[wikitravel:Darmstadt|Darmstadt]] on [[wikitravel:Main Page|Wikitravel]]");
        sb.append(LF);
        sb.append("*[http://www.mathildenhoehe.info Mathildenhoehe]");
        sb.append(LF);
        sb.append("*[http://public-transport.net/bim/Darmstadt.htm Details of Trams and Buses used in Darmstadt]");
        sb.append(LF);
        sb.append("*[http://www.rmv.de/ Public Transport in Darmstadt - Maps, Timetables, Fares]");
        sb.append(LF);
        sb.append("*[http://sites-of-memory.de/main/location.html#darmstadt War memorials in Darmstadt]");
        sb.append(LF);
        sb.append("*[http://www.darmstadt.army.mil/ Webpage of the U.S. army in Darmstadt]");
        sb.append(LF);
        sb.append(LF);
        sb.append("===Notable institutions===");
        sb.append(LF);
        sb.append("* [http://www.tu-darmstadt.de/index.en.html Darmstadt University of Technology]");
        sb.append(LF);
        sb.append("* [http://www.hochschule-darmstadt.de/engl/engl.htm University of Applied Sciences Darmstadt]");
        sb.append(LF);
        sb.append("* [http://www.igd.fraunhofer.de/ Fraunhofer Institute for Computer Graphics]");
        sb.append(LF);
        sb.append("* [http://www.sit.fraunhofer.de/ Fraunhofer Institute for Secure Information Technology]");
        sb.append(LF);
        sb.append("* [http://www.ipsi.fraunhofer.de/ Fraunhofer Institute for Integrated Publication and Information Systems]");
        sb.append(LF);
        sb.append("* [http://www.lbf.fhg.de/ Fraunhofer Institute for Structural Durability]");
        sb.append(LF);
        sb.append("* [http://www.deutscheakademie.de/ Deutsche Akademie für Sprache und Dichtung]");
        sb.append(LF);
        sb.append("* [http://www.gsi.de/ Gesellschaft für Schwerionenforschung]");
        sb.append(LF);
        sb.append("* [http://www.esa.int/SPECIALS/ESOC/ European Space Operations Centre] (ESOC)");
        sb.append(LF);
        sb.append("* [http://www.eumetsat.int/ European Organisation for the Exploitation of Meteorological Satellites (EUMETSAT)]");
        sb.append(LF);
        sb.append(LF);
        sb.append("[[Category:Cities in Hesse]]");
        sb.append(LF);
        sb.append("[[Category:Merck]]");
        sb.append(LF);
        sb.append("[[ar:دارمشتادت]]");
        sb.append(LF);
        sb.append("[[an:Darmstadt]]");
        sb.append(LF);
        sb.append("[[bg:Дармщат]]");
        sb.append(LF);
        sb.append("[[ca:Darmstadt]]");
        sb.append(LF);
        sb.append("[[cs:Darmstadt]]");
        sb.append(LF);
        sb.append("[[da:Darmstadt]]");
        sb.append(LF);
        sb.append("[[de:Darmstadt]]");
        sb.append(LF);
        sb.append("[[et:Darmstadt]]");
        sb.append(LF);
        sb.append("[[el:Ντάρμστατ]]");
        sb.append(LF);
        sb.append("[[es:Darmstadt]]");
        sb.append(LF);
        sb.append("[[eo:Darmstadt]]");
        sb.append(LF);
        sb.append("[[fr:Darmstadt]]");
        sb.append(LF);
        sb.append("[[ko:다름슈타트]]");
        sb.append(LF);
        sb.append("[[id:Darmstadt]]");
        sb.append(LF);
        sb.append("[[it:Darmstadt]]");
        sb.append(LF);
        sb.append("[[la:Darmstadium]]");
        sb.append(LF);
        sb.append("[[hu:Darmstadt]]");
        sb.append(LF);
        sb.append("[[nl:Darmstadt]]");
        sb.append(LF);
        sb.append("[[ja:ダルムシュタット]]");
        sb.append(LF);
        sb.append("[[no:Darmstadt]]");
        sb.append(LF);
        sb.append("[[nds:Darmstadt]]");
        sb.append(LF);
        sb.append("[[pl:Darmstadt]]");
        sb.append(LF);
        sb.append("[[pt:Darmstadt]]");
        sb.append(LF);
        sb.append("[[ro:Darmstadt]]");
        sb.append(LF);
        sb.append("[[ru:Дармштадт]]");
        sb.append(LF);
        sb.append("[[simple:Darmstadt]]");
        sb.append(LF);
        sb.append("[[fi:Darmstadt]]");
        sb.append(LF);
        sb.append("[[sv:Darmstadt]]");
        sb.append(LF);
        sb.append("[[tr:Darmstadt]]");
        sb.append(LF);
        sb.append("[[vo:Darmstadt]]");
        sb.append(LF);
        sb.append("[[zh:达姆施塔特]]");
        sb.append(LF);

        return sb.toString();
    }
}
