/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPageObject;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import java.util.ArrayList;
import java.util.List;

public abstract class ContentContainer
extends ParsedPageObject
implements Content {
    protected List<Content> ccl;

    @Override
    public boolean empty() {
        return this.ccl.size() == 0;
    }

    @Override
    public String getText() {
        StringBuilder result = new StringBuilder();
        for (Content cc : this.ccl) {
            if (cc == null) continue;
            result.append(cc.getText() + " ");
        }
        int temp = result.length() - 1;
        if (temp >= 0) {
            result.deleteCharAt(temp);
        }
        return result.toString();
    }

    public String getText(List<Span> sl) {
        String temp = this.getText();
        StringBuilder result = new StringBuilder();
        for (Span s : sl) {
            result.append(s.getText(temp) + ' ');
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    @Override
    public int length() {
        int length = 0;
        for (Content cc : this.ccl) {
            if (cc == null) continue;
            length += cc.length() + 1;
        }
        if (length > 0) {
            --length;
        }
        return length;
    }

    public int size() {
        return this.ccl.size();
    }

    @Override
    public List<Span> getFormatSpans(Content.FormatType t) {
        ArrayList<Span> result = new ArrayList<Span>();
        int offset = 0;
        for (Content c : this.ccl) {
            for (Span b : c.getFormatSpans(t)) {
                result.add(b.clone().adjust(offset));
            }
            offset += 1 + c.length();
        }
        return result;
    }

    @Override
    public List<Span> getFormatSpans(Content.FormatType t, int start, int end) {
        return this.getFormatSpans(t, new Span(start, end));
    }

    @Override
    public List<Span> getFormatSpans(Content.FormatType t, Span s) {
        ArrayList<Span> result = new ArrayList<Span>();
        Span a = new Span(-1, -1);
        for (Content c : this.ccl) {
            int offset = a.getEnd() + 1;
            if (!(a = new Span(offset, offset + c.length())).hits(s)) continue;
            for (Span b : c.getFormatSpans(t, s.clone().adjust(-offset))) {
                result.add(b.clone().adjust(offset));
            }
        }
        return result;
    }

    @Override
    public List<Content.FormatType> getFormats() {
        boolean bold = false;
        boolean italic = false;
        boolean tag = false;
        boolean math = false;
        boolean nowiki = false;
        for (Content c : this.ccl) {
            for (Content.FormatType t : c.getFormats()) {
                switch (t) {
                    case BOLD: {
                        bold = true;
                        break;
                    }
                    case ITALIC: {
                        italic = true;
                        break;
                    }
                    case TAG: {
                        tag = true;
                        break;
                    }
                    case MATH: {
                        math = true;
                        break;
                    }
                    case NOWIKI: {
                        nowiki = true;
                    }
                }
            }
            if (!bold || !italic || !tag || !math || !nowiki) continue;
            break;
        }
        ArrayList<Content.FormatType> result = new ArrayList<Content.FormatType>();
        if (bold) {
            result.add(Content.FormatType.BOLD);
        }
        if (italic) {
            result.add(Content.FormatType.ITALIC);
        }
        if (tag) {
            result.add(Content.FormatType.TAG);
        }
        if (math) {
            result.add(Content.FormatType.MATH);
        }
        if (nowiki) {
            result.add(Content.FormatType.NOWIKI);
        }
        return result;
    }

    @Override
    public List<Content.FormatType> getFormats(int start, int end) {
        return this.getFormats(new Span(start, end));
    }

    @Override
    public List<Content.FormatType> getFormats(Span s) {
        boolean bold = false;
        boolean italic = false;
        boolean tag = false;
        boolean math = false;
        boolean nowiki = false;
        Span a = new Span(-1, -1);
        for (Content c : this.ccl) {
            int offset = a.getEnd() + 1;
            if ((a = new Span(offset, offset + c.length())).hits(s)) {
                for (Content.FormatType t : c.getFormats(s.clone().adjust(-offset))) {
                    switch (t) {
                        case BOLD: {
                            bold = true;
                            break;
                        }
                        case ITALIC: {
                            italic = true;
                            break;
                        }
                        case TAG: {
                            tag = true;
                            break;
                        }
                        case MATH: {
                            math = true;
                            break;
                        }
                        case NOWIKI: {
                            nowiki = true;
                        }
                    }
                }
            }
            if (!bold || !italic) continue;
            break;
        }
        ArrayList<Content.FormatType> result = new ArrayList<Content.FormatType>();
        if (bold) {
            result.add(Content.FormatType.BOLD);
        }
        if (italic) {
            result.add(Content.FormatType.ITALIC);
        }
        if (tag) {
            result.add(Content.FormatType.TAG);
        }
        if (math) {
            result.add(Content.FormatType.MATH);
        }
        if (nowiki) {
            result.add(Content.FormatType.NOWIKI);
        }
        return result;
    }

    @Override
    public List<Link> getLinks(Link.type linkType) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Content c : this.ccl) {
            result.addAll(c.getLinks(linkType));
        }
        return result;
    }

    @Override
    public List<Link> getLinks(Link.type linkType, int start, int end) {
        return this.getLinks(linkType, new Span(start, end));
    }

    @Override
    public List<Link> getLinks(Link.type linkType, Span s) {
        ArrayList<Link> result = new ArrayList<Link>();
        Span a = new Span(-1, -1);
        for (Content c : this.ccl) {
            int offset = a.getEnd() + 1;
            if (!(a = new Span(offset, offset + c.length())).hits(s)) continue;
            result.addAll(c.getLinks(linkType, s.clone().adjust(-offset)));
        }
        return result;
    }

    @Override
    public List<Link> getLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Content c : this.ccl) {
            result.addAll(c.getLinks());
        }
        return result;
    }

    @Override
    public List<Template> getTemplates() {
        ArrayList<Template> result = new ArrayList<Template>();
        for (Content cc : this.ccl) {
            result.addAll(cc.getTemplates());
        }
        return result;
    }

    @Override
    public List<Template> getTemplates(int start, int end) {
        return this.getTemplates(new Span(start, end));
    }

    @Override
    public List<Template> getTemplates(Span s) {
        ArrayList<Template> result = new ArrayList<Template>();
        Span a = new Span(-1, -1);
        for (Content c : this.ccl) {
            int offset = a.getEnd() + 1;
            if (!(a = new Span(offset, offset + c.length())).hits(s)) continue;
            result.addAll(c.getTemplates(s.clone().adjust(-offset)));
        }
        return result;
    }
}

