/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPageObject;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import java.util.ArrayList;
import java.util.List;

public class ContentElement
extends ParsedPageObject
implements Content {
    private String text = "";
    private List<Span> boldSpans;
    private List<Span> italicSpans;
    private List<Link> links = new ArrayList<Link>();
    private List<Template> templates = new ArrayList<Template>();
    private List<Span> tags;
    private List<Span> mathSpans;
    private List<Span> noWikiSpans;

    public ContentElement() {
        this.boldSpans = new ArrayList<Span>();
        this.italicSpans = new ArrayList<Span>();
        this.tags = new ArrayList<Span>();
        this.mathSpans = new ArrayList<Span>();
        this.noWikiSpans = new ArrayList<Span>();
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getText(List<Span> sl) {
        StringBuilder result = new StringBuilder();
        for (Span s : sl) {
            result.append(s.getText(this.text) + ' ');
        }
        int delChar = result.length() - 1;
        if (delChar > 0) {
            result.deleteCharAt(delChar);
        }
        return result.toString();
    }

    @Override
    public int length() {
        return this.text.length();
    }

    @Override
    public boolean empty() {
        return this.text.length() == 0 && this.links.size() == 0 && this.templates.size() == 0 && this.tags.size() == 0 && this.mathSpans.size() == 0;
    }

    public void setFormatSpans(Content.FormatType t, List<Span> spans) {
        switch (t) {
            case BOLD: {
                this.boldSpans = spans;
                break;
            }
            case ITALIC: {
                this.italicSpans = spans;
                break;
            }
            case TAG: {
                this.tags = spans;
                break;
            }
            case MATH: {
                this.mathSpans = spans;
                break;
            }
            case NOWIKI: {
                this.noWikiSpans = spans;
            }
        }
    }

    @Override
    public List<Span> getFormatSpans(Content.FormatType t) {
        switch (t) {
            case BOLD: {
                return this.boldSpans;
            }
            case ITALIC: {
                return this.italicSpans;
            }
            case TAG: {
                return this.tags;
            }
            case MATH: {
                return this.mathSpans;
            }
            case NOWIKI: {
                return this.noWikiSpans;
            }
        }
        return null;
    }

    @Override
    public List<Span> getFormatSpans(Content.FormatType t, int start, int end) {
        return this.getFormatSpans(t, new Span(start, end));
    }

    @Override
    public List<Span> getFormatSpans(Content.FormatType t, Span s) {
        ArrayList<Span> result = new ArrayList<Span>();
        for (Span s2 : this.getFormatSpans(t)) {
            if (!s2.hits(s)) continue;
            result.add(s2);
        }
        return result;
    }

    @Override
    public List<Content.FormatType> getFormats() {
        ArrayList<Content.FormatType> ftl = new ArrayList<Content.FormatType>();
        if (this.boldSpans.size() != 0) {
            ftl.add(Content.FormatType.BOLD);
        }
        if (this.italicSpans.size() != 0) {
            ftl.add(Content.FormatType.ITALIC);
        }
        if (this.tags.size() != 0) {
            ftl.add(Content.FormatType.TAG);
        }
        if (this.mathSpans.size() != 0) {
            ftl.add(Content.FormatType.MATH);
        }
        if (this.noWikiSpans.size() != 0) {
            ftl.add(Content.FormatType.NOWIKI);
        }
        return ftl;
    }

    @Override
    public List<Content.FormatType> getFormats(int start, int end) {
        return this.getFormats(new Span(start, end));
    }

    @Override
    public List<Content.FormatType> getFormats(Span s) {
        ArrayList<Content.FormatType> result = new ArrayList<Content.FormatType>();
        for (Span s2 : this.boldSpans) {
            if (!s.hits(s2)) continue;
            result.add(Content.FormatType.BOLD);
            break;
        }
        for (Span s2 : this.italicSpans) {
            if (!s.hits(s2)) continue;
            result.add(Content.FormatType.ITALIC);
            break;
        }
        return result;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    public List<Link> getLinks(Link.type t) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.links) {
            if (l.getType() != t) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public List<Link> getLinks(Link.type t, Span s) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.links) {
            if (l.getType() != t || !l.getPos().hits(s)) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public List<Link> getLinks(Link.type t, int begin, int end) {
        return this.getLinks(t, new Span(begin, end));
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }

    @Override
    public List<Template> getTemplates() {
        return this.templates;
    }

    @Override
    public List<Template> getTemplates(int start, int end) {
        return this.getTemplates(new Span(start, end));
    }

    @Override
    public List<Template> getTemplates(Span s) {
        ArrayList<Template> result = new ArrayList<Template>();
        for (Template t : this.templates) {
            if (!t.getPos().hits(s)) continue;
            result.add(t);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CE_TEXT: \"" + this.text + "\"");
        result.append("\nCE_BOLD_SPANS: ");
        if (this.boldSpans != null) {
            result.append(this.boldSpans.size());
            for (Span s : this.boldSpans) {
                result.append("\n\t" + s + " : \"" + s.getText(this.text) + "\"");
            }
        } else {
            result.append("ERROR: boldSpans == null");
        }
        result.append("\nCE_ITALIC_SPANS: ");
        if (this.italicSpans != null) {
            result.append(this.italicSpans.size());
            for (Span s : this.italicSpans) {
                result.append("\n\t" + s + " : \"" + s.getText(this.text) + "\"");
            }
        } else {
            result.append("ERROR: italicSpans == null");
        }
        result.append("\nCE_LINKS: ");
        if (this.links != null) {
            result.append(this.links.size());
            for (Link l : this.links) {
                result.append("\n" + l);
            }
        } else {
            result.append("ERROR: links == null");
        }
        result.append("\nCE_TEMPLATES: ");
        if (this.templates != null) {
            result.append(this.templates.size());
            for (Template t : this.templates) {
                result.append("\n" + t);
            }
        } else {
            result.append("ERROR: templates == null");
        }
        result.append("\nCE_TAGS: ");
        if (this.templates != null) {
            result.append(this.tags.size());
            for (Span s : this.tags) {
                result.append("\n" + s);
            }
        } else {
            result.append("ERROR: templates == null");
        }
        return result.toString();
    }
}

