/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.ContentContainer;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import java.util.ArrayList;
import java.util.List;

public class DefinitionList
extends ContentContainer {
    private ContentElement definedTerm;
    private List<ContentElement> definitions;

    public DefinitionList() {
        this.ccl = new ArrayList();
        this.definedTerm = null;
        this.definitions = new ArrayList<ContentElement>();
    }

    public DefinitionList(ContentElement definedTerm, List<ContentElement> definitions) {
        this.ccl = new ArrayList();
        this.definedTerm = definedTerm;
        this.definitions = definitions;
        this.ccl.add(definedTerm);
        this.ccl.addAll(definitions);
    }

    public DefinitionList(List<ContentElement> content) {
        this.ccl = new ArrayList<ContentElement>(content);
        this.definitions = new ArrayList<ContentElement>();
        if (content.size() > 0) {
            this.definedTerm = content.get(0);
            if (content.size() > 1) {
                this.definitions.addAll(content);
                this.definitions.remove(0);
            }
        } else {
            this.definedTerm = null;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("DL_DEFINEDTERM:\n");
        result.append(this.definedTerm);
        if (this.definitions.size() != 0) {
            result.append("\nDL_DEFINITIONS:");
            for (ContentElement ce : this.definitions) {
                result.append("\n" + ce);
            }
        }
        return result.toString();
    }

    public ContentElement getDefinedTerm() {
        return this.definedTerm;
    }

    public void setDefinedTerm(ContentElement definedTerm) {
        if (definedTerm != null) {
            if (this.definedTerm == null) {
                this.ccl.add(0, definedTerm);
            } else {
                this.ccl.set(0, definedTerm);
            }
        } else if (this.definedTerm != null) {
            this.ccl.remove(this.definedTerm);
        }
        this.definedTerm = definedTerm;
    }

    public int nrOfDefinitions() {
        return this.definitions.size();
    }

    public void removeDefinition(ContentElement ce) {
        this.definitions.remove(ce);
        this.ccl.remove(ce);
    }

    public void addDefiniton(ContentElement ce) {
        this.definitions.add(ce);
        this.ccl.add(ce);
    }

    public ContentElement getDefinition(int i) {
        if (this.definitions.size() > i) {
            return this.definitions.get(i);
        }
        return null;
    }

    public List<ContentElement> getDefinitions() {
        return new ArrayList<ContentElement>(this.definitions);
    }
}

