/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.Title;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParserFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LinkAnchorExtractor {
    private MediaWikiParser parser;

    public LinkAnchorExtractor() {
        MediaWikiParserFactory pf = new MediaWikiParserFactory(WikiConstants.Language.english);
        this.parser = pf.createParser();
    }

    public LinkAnchorExtractor(WikiConstants.Language lang) {
        MediaWikiParserFactory pf = new MediaWikiParserFactory(lang);
        this.parser = pf.createParser();
    }

    public LinkAnchorExtractor(MediaWikiParser parser) {
        this.parser = parser;
    }

    public Set<String> getInlinkAnchors(Page page) throws WikiTitleParsingException {
        HashSet<String> inAnchors = new HashSet<String>();
        for (Page p : page.getInlinks()) {
            ParsedPage pp = this.parser.parse(p.getText());
            if (pp == null) {
                return inAnchors;
            }
            for (Link l : pp.getLinks()) {
                String pageTitle = page.getTitle().getPlainTitle();
                String anchorText = l.getText();
                if (!l.getTarget().equals(pageTitle) || anchorText.equals(pageTitle)) continue;
                inAnchors.add(anchorText);
            }
        }
        return inAnchors;
    }

    public Map<String, Set<String>> getOutlinkAnchors(Page page) throws WikiTitleParsingException {
        HashMap<String, Set<String>> outAnchors = new HashMap<String, Set<String>>();
        ParsedPage pp = this.parser.parse(page.getText());
        if (pp == null) {
            return outAnchors;
        }
        for (Link l : pp.getLinks()) {
            String anchorText;
            if (l.getTarget().length() == 0) continue;
            String targetTitle = new Title(l.getTarget()).getPlainTitle();
            if (l.getType().equals((Object)Link.type.EXTERNAL) || l.getType().equals((Object)Link.type.IMAGE) || l.getType().equals((Object)Link.type.AUDIO) || l.getType().equals((Object)Link.type.VIDEO) || targetTitle.contains(":") || (anchorText = l.getText()).equals(targetTitle)) continue;
            Set anchors = outAnchors.containsKey(targetTitle) ? (Set)outAnchors.get(targetTitle) : new HashSet();
            anchors.add(anchorText);
            outAnchors.put(targetTitle, anchors);
        }
        return outAnchors;
    }
}

